/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.internal.io;

import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.crypto.CipherOutputStream;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.StreamException;
import org.bouncycastle.crypto.internal.BufferedBlockCipher;
import org.bouncycastle.crypto.internal.StreamCipher;
import org.bouncycastle.crypto.internal.io.StreamIOException;
import org.bouncycastle.crypto.internal.io.Utils;
import org.bouncycastle.crypto.internal.modes.AEADBlockCipher;

public class CipherOutputStreamImpl
extends CipherOutputStream {
    private final String algorithmName;
    private final boolean isApprovedMode;
    private OutputStream out;
    private BufferedBlockCipher bufferedBlockCipher;
    private StreamCipher streamCipher;
    private AEADBlockCipher aeadBlockCipher;
    private final byte[] oneByte = new byte[1];
    private byte[] buf;

    public CipherOutputStreamImpl(OutputStream outputStream, BufferedBlockCipher bufferedBlockCipher) {
        this.isApprovedMode = CryptoServicesRegistrar.isInApprovedOnlyMode();
        this.algorithmName = bufferedBlockCipher.getUnderlyingCipher().getAlgorithmName();
        this.out = outputStream;
        this.bufferedBlockCipher = bufferedBlockCipher;
    }

    public CipherOutputStreamImpl(OutputStream outputStream, StreamCipher streamCipher) {
        this.isApprovedMode = CryptoServicesRegistrar.isInApprovedOnlyMode();
        this.algorithmName = streamCipher.getAlgorithmName();
        this.out = outputStream;
        this.streamCipher = streamCipher;
    }

    public CipherOutputStreamImpl(OutputStream outputStream, AEADBlockCipher aEADBlockCipher) {
        this.isApprovedMode = CryptoServicesRegistrar.isInApprovedOnlyMode();
        this.algorithmName = aEADBlockCipher.getAlgorithmName();
        this.out = outputStream;
        this.aeadBlockCipher = aEADBlockCipher;
    }

    public void write(int n2) throws IOException {
        Utils.approvedModeCheck(this.isApprovedMode, this.algorithmName);
        this.oneByte[0] = (byte)n2;
        if (this.streamCipher != null) {
            this.out.write(this.streamCipher.returnByte((byte)n2));
        } else {
            this.write(this.oneByte, 0, 1);
        }
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n2, int n3) throws IOException {
        Utils.approvedModeCheck(this.isApprovedMode, this.algorithmName);
        this.ensureCapacity(n3, false);
        if (this.bufferedBlockCipher != null) {
            int n4 = this.bufferedBlockCipher.processBytes(byArray, n2, n3, this.buf, 0);
            if (n4 != 0) {
                this.out.write(this.buf, 0, n4);
            }
        } else if (this.aeadBlockCipher != null) {
            int n5 = this.aeadBlockCipher.processBytes(byArray, n2, n3, this.buf, 0);
            if (n5 != 0) {
                this.out.write(this.buf, 0, n5);
            }
        } else {
            this.streamCipher.processBytes(byArray, n2, n3, this.buf, 0);
            this.out.write(this.buf, 0, n3);
        }
    }

    private void ensureCapacity(int n2, boolean bl2) {
        int n3 = n2;
        if (bl2) {
            if (this.bufferedBlockCipher != null) {
                n3 = this.bufferedBlockCipher.getOutputSize(n2);
            } else if (this.aeadBlockCipher != null) {
                n3 = this.aeadBlockCipher.getOutputSize(n2);
            }
        } else if (this.bufferedBlockCipher != null) {
            n3 = this.bufferedBlockCipher.getUpdateOutputSize(n2);
        } else if (this.aeadBlockCipher != null) {
            n3 = this.aeadBlockCipher.getUpdateOutputSize(n2);
        }
        if (this.buf == null || this.buf.length < n3) {
            this.buf = new byte[n3];
        }
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void close() throws IOException {
        IOException iOException;
        block14: {
            Utils.approvedModeCheck(this.isApprovedMode, this.algorithmName);
            this.ensureCapacity(0, true);
            iOException = null;
            try {
                int n2;
                if (this.bufferedBlockCipher != null) {
                    n2 = this.bufferedBlockCipher.doFinal(this.buf, 0);
                    if (n2 != 0) {
                        this.out.write(this.buf, 0, n2);
                    }
                } else if (this.aeadBlockCipher != null) {
                    n2 = this.aeadBlockCipher.doFinal(this.buf, 0);
                    if (n2 != 0) {
                        this.out.write(this.buf, 0, n2);
                    }
                } else if (this.streamCipher != null) {
                    this.streamCipher.reset();
                }
            }
            catch (org.bouncycastle.crypto.internal.InvalidCipherTextException invalidCipherTextException) {
                iOException = new InvalidCipherTextException("Error finalising cipher data: " + invalidCipherTextException.getMessage(), invalidCipherTextException);
            }
            catch (IllegalStateException illegalStateException) {
                iOException = new StreamException(illegalStateException.getMessage(), illegalStateException.getCause());
            }
            catch (Exception exception) {
                iOException = new StreamIOException("Error closing stream: ", exception);
            }
            try {
                this.flush();
            }
            catch (IOException iOException2) {
                if (iOException != null) break block14;
                iOException = iOException2;
            }
        }
        if (iOException != null) {
            throw iOException;
        }
    }
}

