/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.general;

import java.security.SecureRandom;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.IllegalKeyException;
import org.bouncycastle.crypto.fips.FipsUnapprovedOperationError;
import org.bouncycastle.crypto.internal.ValidatedSymmetricKey;
import org.bouncycastle.crypto.internal.params.KeyParameter;
import org.bouncycastle.crypto.internal.params.KeyParameterImpl;

class Utils {
    static final SecureRandom testRandom = new SecureRandom();

    Utils() {
    }

    static void approveModeCheck(Algorithm algorithm) {
        if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            throw new FipsUnapprovedOperationError("Attempt to use unapproved algorithm in approved only mode", algorithm);
        }
    }

    static KeyParameter getKeyParameter(ValidatedSymmetricKey validatedSymmetricKey) {
        return new KeyParameterImpl(validatedSymmetricKey.getKeyBytes());
    }

    static void checkKeyAlgorithm(ValidatedSymmetricKey validatedSymmetricKey, Algorithm algorithm, Algorithm algorithm2) {
        Algorithm algorithm3 = validatedSymmetricKey.getAlgorithm();
        if (!algorithm3.equals(algorithm) && !algorithm3.equals(algorithm2)) {
            throw new IllegalKeyException("Key not for appropriate algorithm");
        }
    }

    static int bitsToBytes(int n2) {
        return (n2 + 7) / 8;
    }

    static int getDefaultMacSize(Algorithm algorithm, int n2) {
        if (algorithm.getName().endsWith("GMAC") || algorithm.getName().endsWith("/CMAC") || algorithm.getName().endsWith("GCM") || algorithm.getName().endsWith("OCB") || algorithm.getName().endsWith("ISO979ALG3")) {
            return n2;
        }
        return n2 / 2;
    }
}

