/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.general;

import java.security.SecureRandom;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.AuthenticationParametersWithIV;
import org.bouncycastle.crypto.IllegalKeyException;
import org.bouncycastle.crypto.ParametersWithIV;
import org.bouncycastle.crypto.SymmetricKey;
import org.bouncycastle.crypto.SymmetricSecretKey;
import org.bouncycastle.crypto.general.CipherKeyGenerator;
import org.bouncycastle.crypto.general.CipherUtils;
import org.bouncycastle.crypto.general.GeneralAlgorithm;
import org.bouncycastle.crypto.general.GeneralAuthParameters;
import org.bouncycastle.crypto.general.GeneralParameters;
import org.bouncycastle.crypto.general.GeneralParametersWithIV;
import org.bouncycastle.crypto.general.GuardedAEADOperatorFactory;
import org.bouncycastle.crypto.general.GuardedKeyWrapOperatorFactory;
import org.bouncycastle.crypto.general.GuardedMACOperatorFactory;
import org.bouncycastle.crypto.general.GuardedSymmetricKeyGenerator;
import org.bouncycastle.crypto.general.GuardedSymmetricOperatorFactory;
import org.bouncycastle.crypto.general.Mode;
import org.bouncycastle.crypto.general.Padding;
import org.bouncycastle.crypto.general.PrivilegedUtils;
import org.bouncycastle.crypto.general.SelfTestExecutor;
import org.bouncycastle.crypto.general.SerpentEngine;
import org.bouncycastle.crypto.general.Utils;
import org.bouncycastle.crypto.general.VariantKatTest;
import org.bouncycastle.crypto.internal.BlockCipher;
import org.bouncycastle.crypto.internal.BufferedBlockCipher;
import org.bouncycastle.crypto.internal.KeyGenerationParameters;
import org.bouncycastle.crypto.internal.Mac;
import org.bouncycastle.crypto.internal.ValidatedSymmetricKey;
import org.bouncycastle.crypto.internal.Wrapper;
import org.bouncycastle.crypto.internal.modes.AEADBlockCipher;
import org.bouncycastle.crypto.internal.params.KeyParameterImpl;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;

public final class Serpent {
    public static final GeneralAlgorithm ALGORITHM = new GeneralAlgorithm("Serpent");
    private static final EngineProvider ENGINE_PROVIDER;
    public static final Parameters ECB;
    public static final Parameters ECBwithPKCS7;
    public static final Parameters ECBwithISO10126_2;
    public static final Parameters ECBwithX923;
    public static final Parameters ECBwithISO7816_4;
    public static final Parameters ECBwithTBC;
    public static final Parameters CBC;
    public static final Parameters CBCwithPKCS7;
    public static final Parameters CBCwithISO10126_2;
    public static final Parameters CBCwithX923;
    public static final Parameters CBCwithISO7816_4;
    public static final Parameters CBCwithTBC;
    public static final Parameters CBCwithCS1;
    public static final Parameters CBCwithCS2;
    public static final Parameters CBCwithCS3;
    public static final Parameters CFB8;
    public static final Parameters CFB128;
    public static final Parameters OFB;
    public static final Parameters CTR;
    public static final AuthParameters GCM;
    public static final AuthParameters CCM;
    public static final AuthParameters OCB;
    public static final AuthParameters EAX;
    public static final AuthParameters CMAC;
    public static final AuthParameters GMAC;
    public static final WrapParameters KW;
    public static final WrapParameters KWP;

    private Serpent() {
    }

    private static ValidatedSymmetricKey validateKey(SymmetricKey symmetricKey, Algorithm algorithm) {
        ValidatedSymmetricKey validatedSymmetricKey = PrivilegedUtils.getValidatedKey(symmetricKey);
        int n2 = validatedSymmetricKey.getKeySizeInBits();
        if (Serpent.invalidKeySize(n2)) {
            throw new IllegalKeyException("Serpent key must be a multiple of 32 bits and no more than 256 bits");
        }
        Utils.checkKeyAlgorithm(validatedSymmetricKey, ALGORITHM, algorithm);
        return validatedSymmetricKey;
    }

    private static boolean invalidKeySize(int n2) {
        return n2 < 32 || n2 % 32 != 0 || n2 > 256;
    }

    static {
        EngineProvider engineProvider = new EngineProvider();
        engineProvider.createEngine();
        ENGINE_PROVIDER = engineProvider;
        ECB = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.ECB));
        ECBwithPKCS7 = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.ECB, Padding.PKCS7));
        ECBwithISO10126_2 = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.ECB, Padding.ISO10126_2));
        ECBwithX923 = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.ECB, Padding.X923));
        ECBwithISO7816_4 = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.ECB, Padding.ISO7816_4));
        ECBwithTBC = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.ECB, Padding.TBC));
        CBC = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.CBC));
        CBCwithPKCS7 = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.CBC, Padding.PKCS7));
        CBCwithISO10126_2 = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.CBC, Padding.ISO10126_2));
        CBCwithX923 = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.CBC, Padding.X923));
        CBCwithISO7816_4 = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.CBC, Padding.ISO7816_4));
        CBCwithTBC = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.CBC, Padding.TBC));
        CBCwithCS1 = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.CBC, Padding.CS1));
        CBCwithCS2 = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.CBC, Padding.CS2));
        CBCwithCS3 = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.CBC, Padding.CS3));
        CFB8 = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.CFB8));
        CFB128 = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.CFB128));
        OFB = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.OFB128));
        CTR = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.CTR));
        GCM = new AuthParameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.GCM));
        CCM = new AuthParameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.CCM));
        OCB = new AuthParameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.OCB));
        EAX = new AuthParameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.EAX));
        CMAC = new AuthParameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.CMAC));
        GMAC = new AuthParameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.GMAC));
        KW = new WrapParameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.WRAP));
        KWP = new WrapParameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.WRAPPAD));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class AEADOperatorFactory
    extends GuardedAEADOperatorFactory<AuthParameters> {
        @Override
        protected AEADBlockCipher createAEADCipher(boolean bl2, SymmetricKey symmetricKey, AuthParameters authParameters) {
            return CipherUtils.createStandardAEADCipher(bl2, Serpent.validateKey(symmetricKey, authParameters.getAlgorithm()), (org.bouncycastle.crypto.internal.EngineProvider<BlockCipher>)ENGINE_PROVIDER, (AuthenticationParametersWithIV)authParameters);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class AuthParameters
    extends GeneralAuthParameters<AuthParameters> {
        private AuthParameters(GeneralAlgorithm generalAlgorithm, byte[] byArray, int n2) {
            super(generalAlgorithm, 16, byArray, n2);
        }

        AuthParameters(GeneralAlgorithm generalAlgorithm) {
            this(generalAlgorithm, null, Utils.getDefaultMacSize(generalAlgorithm, 128));
        }

        @Override
        protected AuthParameters create(GeneralAlgorithm generalAlgorithm, byte[] byArray, int n2) {
            return new AuthParameters(generalAlgorithm, byArray, n2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class EngineProvider
    implements org.bouncycastle.crypto.internal.EngineProvider<BlockCipher> {
        private EngineProvider() {
        }

        @Override
        public BlockCipher createEngine() {
            return (BlockCipher)SelfTestExecutor.validate((Algorithm)ALGORITHM, (Object)new SerpentEngine(), (VariantKatTest)new VariantKatTest<SerpentEngine>(){

                @Override
                public void evaluate(SerpentEngine serpentEngine) {
                    byte[] byArray = Hex.decode("3DA46FFA6F4D6F30CD258333E5A61369");
                    byte[] byArray2 = Hex.decode("00112233445566778899AABBCCDDEEFF");
                    byte[] byArray3 = new byte[byArray.length];
                    KeyParameterImpl keyParameterImpl = new KeyParameterImpl(Hex.decode("000102030405060708090A0B0C0D0E0F101112131415161718191A1B1C1D1E1F"));
                    serpentEngine.init(true, keyParameterImpl);
                    serpentEngine.processBlock(byArray, 0, byArray3, 0);
                    if (!Arrays.areEqual(byArray2, byArray3)) {
                        this.fail("Failed self test on encryption");
                    }
                    serpentEngine.init(false, keyParameterImpl);
                    serpentEngine.processBlock(byArray3, 0, byArray3, 0);
                    if (!Arrays.areEqual(byArray, byArray3)) {
                        this.fail("Failed self test on decryption");
                    }
                }
            });
        }
    }

    public static final class KeyGenerator
    extends GuardedSymmetricKeyGenerator {
        private final GeneralAlgorithm algorithm;
        private final int keySizeInBits;
        private final SecureRandom random;

        public KeyGenerator(int n2, SecureRandom secureRandom) {
            this(ALGORITHM, n2, secureRandom);
        }

        public KeyGenerator(GeneralParameters generalParameters, int n2, SecureRandom secureRandom) {
            this((GeneralAlgorithm)generalParameters.getAlgorithm(), n2, secureRandom);
        }

        private KeyGenerator(GeneralAlgorithm generalAlgorithm, int n2, SecureRandom secureRandom) {
            this.algorithm = generalAlgorithm;
            if (Serpent.invalidKeySize(n2)) {
                throw new IllegalArgumentException("Attempt to create key with invalid key size [" + n2 + "]: " + generalAlgorithm.getName());
            }
            this.keySizeInBits = n2;
            this.random = secureRandom;
        }

        public SymmetricKey doGenerateKey() {
            CipherKeyGenerator cipherKeyGenerator = new CipherKeyGenerator();
            cipherKeyGenerator.init(new KeyGenerationParameters(this.random, this.keySizeInBits));
            return new SymmetricSecretKey(this.algorithm, cipherKeyGenerator.generateKey());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class KeyWrapOperatorFactory
    extends GuardedKeyWrapOperatorFactory<WrapParameters, SymmetricKey> {
        @Override
        protected Wrapper createWrapper(boolean bl2, SymmetricKey symmetricKey, WrapParameters wrapParameters, SecureRandom secureRandom) {
            return CipherUtils.createStandardWrapper(bl2, Serpent.validateKey(symmetricKey, wrapParameters.getAlgorithm()), (org.bouncycastle.crypto.internal.EngineProvider<BlockCipher>)ENGINE_PROVIDER, (ParametersWithIV)wrapParameters, wrapParameters.useInverse, secureRandom);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class MACOperatorFactory
    extends GuardedMACOperatorFactory<AuthParameters> {
        @Override
        protected Mac createMAC(SymmetricKey symmetricKey, AuthParameters authParameters) {
            return CipherUtils.createStandardMac(Serpent.validateKey(symmetricKey, authParameters.getAlgorithm()), (org.bouncycastle.crypto.internal.EngineProvider<BlockCipher>)ENGINE_PROVIDER, (GeneralAuthParameters)authParameters);
        }

        @Override
        protected int calculateMACSize(AuthParameters authParameters) {
            return Utils.bitsToBytes(authParameters.macLenInBits);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class OperatorFactory
    extends GuardedSymmetricOperatorFactory<Parameters> {
        @Override
        protected BufferedBlockCipher createCipher(boolean bl2, SymmetricKey symmetricKey, Parameters parameters, SecureRandom secureRandom) {
            return CipherUtils.createStandardCipher(bl2, Serpent.validateKey(symmetricKey, parameters.getAlgorithm()), (org.bouncycastle.crypto.internal.EngineProvider<BlockCipher>)ENGINE_PROVIDER, (ParametersWithIV)parameters, secureRandom);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Parameters
    extends GeneralParametersWithIV<Parameters> {
        private Parameters(GeneralAlgorithm generalAlgorithm, byte[] byArray) {
            super(generalAlgorithm, 16, generalAlgorithm.checkIv(byArray, 16));
        }

        Parameters(GeneralAlgorithm generalAlgorithm) {
            this(generalAlgorithm, null);
        }

        @Override
        protected Parameters create(GeneralAlgorithm generalAlgorithm, byte[] byArray) {
            return new Parameters(generalAlgorithm, byArray);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class WrapParameters
    extends GeneralParameters<GeneralAlgorithm>
    implements ParametersWithIV {
        private final byte[] iv;
        private final boolean useInverse;

        WrapParameters(GeneralAlgorithm generalAlgorithm) {
            this(generalAlgorithm, null, false);
        }

        private WrapParameters(GeneralAlgorithm generalAlgorithm, byte[] byArray, boolean bl2) {
            super(generalAlgorithm);
            if (byArray != null) {
                ((Mode)generalAlgorithm.basicVariation()).checkIv(byArray, this.getIvLength());
            }
            this.iv = byArray;
            this.useInverse = bl2;
        }

        public WrapParameters withUsingInverseFunction(boolean bl2) {
            return new WrapParameters((GeneralAlgorithm)this.getAlgorithm(), Arrays.clone(this.iv), bl2);
        }

        public WrapParameters withIV(byte[] byArray) {
            return new WrapParameters((GeneralAlgorithm)this.getAlgorithm(), Arrays.clone(byArray), this.useInverse);
        }

        public WrapParameters withIV(SecureRandom secureRandom) {
            return new WrapParameters((GeneralAlgorithm)this.getAlgorithm(), ((GeneralAlgorithm)this.getAlgorithm()).createDefaultIvIfNecessary(this.getIvLength(), secureRandom), this.useInverse);
        }

        @Override
        public byte[] getIV() {
            return Arrays.clone(this.iv);
        }

        public boolean isUsingInverseFunction() {
            return this.useInverse;
        }

        private int getIvLength() {
            return ((GeneralAlgorithm)this.getAlgorithm()).equals(KW.getAlgorithm()) ? 8 : 4;
        }
    }
}

