/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.general;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.crypto.internal.CipherParameters;
import org.bouncycastle.crypto.internal.DSA;
import org.bouncycastle.crypto.internal.params.EcDomainParameters;
import org.bouncycastle.crypto.internal.params.EcKeyParameters;
import org.bouncycastle.crypto.internal.params.EcPrivateKeyParameters;
import org.bouncycastle.crypto.internal.params.EcPublicKeyParameters;
import org.bouncycastle.crypto.internal.params.ParametersWithRandom;
import org.bouncycastle.math.ec.ECAlgorithms;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECFieldElement;
import org.bouncycastle.math.ec.ECMultiplier;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.math.ec.FixedPointCombMultiplier;
import org.bouncycastle.util.Arrays;

class DSTU4145Signer
implements DSA {
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private EcKeyParameters key;
    private SecureRandom random;

    DSTU4145Signer() {
    }

    public void init(boolean bl2, CipherParameters cipherParameters) {
        if (bl2) {
            if (!(cipherParameters instanceof ParametersWithRandom)) {
                throw new IllegalArgumentException("No SecureRandom provided when one required");
            }
            ParametersWithRandom parametersWithRandom = (ParametersWithRandom)cipherParameters;
            this.random = parametersWithRandom.getRandom();
            cipherParameters = parametersWithRandom.getParameters();
            this.key = (EcPrivateKeyParameters)cipherParameters;
        } else {
            this.key = (EcPublicKeyParameters)cipherParameters;
        }
    }

    public BigInteger[] generateSignature(byte[] byArray) {
        BigInteger bigInteger;
        ECFieldElement eCFieldElement;
        BigInteger bigInteger2;
        BigInteger bigInteger3;
        ECFieldElement eCFieldElement2;
        EcDomainParameters ecDomainParameters = this.key.getParameters();
        ECCurve eCCurve = ecDomainParameters.getCurve();
        ECFieldElement eCFieldElement3 = DSTU4145Signer.hash2FieldElement(eCCurve, byArray);
        if (eCFieldElement3.isZero()) {
            eCFieldElement3 = eCCurve.fromBigInteger(ONE);
        }
        BigInteger bigInteger4 = ecDomainParameters.getN();
        BigInteger bigInteger5 = ((EcPrivateKeyParameters)this.key).getD();
        ECMultiplier eCMultiplier = this.createBasePointMultiplier();
        do {
            bigInteger3 = DSTU4145Signer.generateRandomInteger(bigInteger4, this.random);
        } while ((eCFieldElement2 = eCMultiplier.multiply(ecDomainParameters.getG(), bigInteger3).normalize().getAffineXCoord()).isZero() || (bigInteger2 = DSTU4145Signer.fieldElement2Integer(bigInteger4, eCFieldElement = eCFieldElement3.multiply(eCFieldElement2))).signum() == 0 || (bigInteger = bigInteger2.multiply(bigInteger5).add(bigInteger3).mod(bigInteger4)).signum() == 0);
        return new BigInteger[]{bigInteger2, bigInteger};
    }

    public boolean verifySignature(byte[] byArray, BigInteger bigInteger, BigInteger bigInteger2) {
        ECPoint eCPoint;
        if (bigInteger.signum() <= 0 || bigInteger2.signum() <= 0) {
            return false;
        }
        EcDomainParameters ecDomainParameters = this.key.getParameters();
        BigInteger bigInteger3 = ecDomainParameters.getN();
        if (bigInteger.compareTo(bigInteger3) >= 0 || bigInteger2.compareTo(bigInteger3) >= 0) {
            return false;
        }
        ECCurve eCCurve = ecDomainParameters.getCurve();
        ECFieldElement eCFieldElement = DSTU4145Signer.hash2FieldElement(eCCurve, byArray);
        if (eCFieldElement.isZero()) {
            eCFieldElement = eCCurve.fromBigInteger(ONE);
        }
        if ((eCPoint = ECAlgorithms.sumOfTwoMultiplies(ecDomainParameters.getG(), bigInteger2, ((EcPublicKeyParameters)this.key).getQ(), bigInteger).normalize()).isInfinity()) {
            return false;
        }
        ECFieldElement eCFieldElement2 = eCFieldElement.multiply(eCPoint.getAffineXCoord());
        return DSTU4145Signer.fieldElement2Integer(bigInteger3, eCFieldElement2).compareTo(bigInteger) == 0;
    }

    protected ECMultiplier createBasePointMultiplier() {
        return new FixedPointCombMultiplier();
    }

    private static BigInteger generateRandomInteger(BigInteger bigInteger, SecureRandom secureRandom) {
        return new BigInteger(bigInteger.bitLength() - 1, secureRandom);
    }

    private static ECFieldElement hash2FieldElement(ECCurve eCCurve, byte[] byArray) {
        byte[] byArray2 = Arrays.reverse(byArray);
        return eCCurve.fromBigInteger(DSTU4145Signer.truncate(new BigInteger(1, byArray2), eCCurve.getFieldSize()));
    }

    private static BigInteger fieldElement2Integer(BigInteger bigInteger, ECFieldElement eCFieldElement) {
        return DSTU4145Signer.truncate(eCFieldElement.toBigInteger(), bigInteger.bitLength() - 1);
    }

    private static BigInteger truncate(BigInteger bigInteger, int n2) {
        if (bigInteger.bitLength() > n2) {
            bigInteger = bigInteger.mod(ONE.shiftLeft(n2));
        }
        return bigInteger;
    }
}

