/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import org.bouncycastle.crypto.AsymmetricPublicKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricECPublicKey;
import org.bouncycastle.crypto.asymmetric.ECDomainParameters;
import org.bouncycastle.crypto.asymmetric.NamedECDomainParameters;
import org.bouncycastle.crypto.fips.EcDhcuBasicAgreement;
import org.bouncycastle.crypto.fips.FipsAgreement;
import org.bouncycastle.crypto.fips.FipsAgreementParameters;
import org.bouncycastle.crypto.fips.FipsEC;
import org.bouncycastle.crypto.fips.FipsKDF;
import org.bouncycastle.crypto.internal.params.EcDhuPublicParameters;
import org.bouncycastle.crypto.internal.params.EcDomainParameters;
import org.bouncycastle.crypto.internal.params.EcNamedDomainParameters;
import org.bouncycastle.crypto.internal.params.EcPublicKeyParameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EcDHUAgreement<T extends FipsAgreementParameters>
extends FipsAgreement<T> {
    private final EcDhcuBasicAgreement dh;
    private final T parameter;

    EcDHUAgreement(EcDhcuBasicAgreement ecDhcuBasicAgreement, T t2) {
        this.dh = ecDhcuBasicAgreement;
        this.parameter = t2;
    }

    @Override
    public T getParameters() {
        return this.parameter;
    }

    @Override
    public byte[] calculate(AsymmetricPublicKey asymmetricPublicKey) {
        AsymmetricECPublicKey asymmetricECPublicKey = (AsymmetricECPublicKey)asymmetricPublicKey;
        EcPublicKeyParameters ecPublicKeyParameters = new EcPublicKeyParameters(asymmetricECPublicKey.getW(), EcDHUAgreement.getDomainParams(asymmetricECPublicKey.getDomainParameters()));
        AsymmetricECPublicKey asymmetricECPublicKey2 = ((FipsEC.DHUAgreementParameters)this.parameter).getOtherPartyEphemeralKey();
        byte[] byArray = this.dh.calculateAgreement(new EcDhuPublicParameters(ecPublicKeyParameters, new EcPublicKeyParameters(asymmetricECPublicKey2.getW(), EcDHUAgreement.getDomainParams(asymmetricECPublicKey2.getDomainParameters()))));
        return FipsKDF.processZBytes(byArray, this.parameter);
    }

    private static EcDomainParameters getDomainParams(ECDomainParameters eCDomainParameters) {
        if (eCDomainParameters instanceof NamedECDomainParameters) {
            return new EcNamedDomainParameters((NamedECDomainParameters)eCDomainParameters);
        }
        return new EcDomainParameters(eCDomainParameters);
    }
}

