/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.crypto.internal.params.DhParameters;
import org.bouncycastle.util.BigIntegers;

class DhKeyGeneratorHelper {
    static final DhKeyGeneratorHelper INSTANCE = new DhKeyGeneratorHelper();
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private static final BigInteger TWO = BigInteger.valueOf(2L);

    private DhKeyGeneratorHelper() {
    }

    BigInteger calculatePrivate(DhParameters dhParameters, SecureRandom secureRandom) {
        BigInteger bigInteger;
        int n2 = dhParameters.getL();
        if (n2 != 0) {
            return new BigInteger(n2, secureRandom).setBit(n2 - 1);
        }
        BigInteger bigInteger2 = TWO;
        int n3 = dhParameters.getM();
        if (n3 != 0) {
            bigInteger2 = ONE.shiftLeft(n3 - 1);
        }
        if ((bigInteger = dhParameters.getQ()) == null) {
            bigInteger = dhParameters.getP();
        }
        BigInteger bigInteger3 = bigInteger.subtract(TWO);
        return BigIntegers.createRandomInRange(bigInteger2, bigInteger3, secureRandom);
    }

    BigInteger calculatePublic(DhParameters dhParameters, BigInteger bigInteger) {
        return dhParameters.getG().modPow(bigInteger, dhParameters.getP());
    }
}

