/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import org.bouncycastle.crypto.EntropySource;
import org.bouncycastle.crypto.fips.ContinuousTestingEntropySource;
import org.bouncycastle.crypto.fips.DRBG;
import org.bouncycastle.crypto.fips.DRBGProvider;
import org.bouncycastle.crypto.fips.FipsAlgorithm;
import org.bouncycastle.crypto.fips.SelfTestExecutor;
import org.bouncycastle.crypto.fips.VariantInternalKatTest;

class DRBGPseudoRandom
implements DRBG {
    private final FipsAlgorithm algorithm;
    private final DRBGProvider drbgProvider;
    private final EntropySource entropySource;
    private DRBG drbg;

    DRBGPseudoRandom(FipsAlgorithm fipsAlgorithm, EntropySource entropySource, DRBGProvider dRBGProvider) {
        this.algorithm = fipsAlgorithm;
        this.entropySource = new ContinuousTestingEntropySource(entropySource);
        this.drbgProvider = dRBGProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getBlockSize() {
        DRBGPseudoRandom dRBGPseudoRandom = this;
        synchronized (dRBGPseudoRandom) {
            this.lazyInitDRBG();
            return this.drbg.getBlockSize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSecurityStrength() {
        DRBGPseudoRandom dRBGPseudoRandom = this;
        synchronized (dRBGPseudoRandom) {
            this.lazyInitDRBG();
            return this.drbg.getSecurityStrength();
        }
    }

    private void lazyInitDRBG() {
        if (this.drbg == null) {
            this.drbg = this.drbgProvider.get(this.entropySource);
            SelfTestExecutor.validate((FipsAlgorithm)this.algorithm, (VariantInternalKatTest)this.drbg.createSelfTest(this.algorithm));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int generate(byte[] byArray, byte[] byArray2, boolean bl2) {
        DRBGPseudoRandom dRBGPseudoRandom = this;
        synchronized (dRBGPseudoRandom) {
            this.lazyInitDRBG();
            if (bl2) {
                SelfTestExecutor.validate((FipsAlgorithm)this.algorithm, (VariantInternalKatTest)this.drbg.createReseedSelfTest(this.algorithm));
            }
            if (this.drbg.generate(byArray, byArray2, bl2) < 0) {
                SelfTestExecutor.validate((FipsAlgorithm)this.algorithm, (VariantInternalKatTest)this.drbg.createReseedSelfTest(this.algorithm));
                this.drbg.reseed(null);
                return this.drbg.generate(byArray, byArray2, bl2);
            }
            return byArray.length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reseed(byte[] byArray) {
        DRBGPseudoRandom dRBGPseudoRandom = this;
        synchronized (dRBGPseudoRandom) {
            this.lazyInitDRBG();
            SelfTestExecutor.validate((FipsAlgorithm)this.algorithm, (VariantInternalKatTest)this.drbg.createReseedSelfTest(this.algorithm));
            this.drbg.reseed(byArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VariantInternalKatTest createSelfTest(FipsAlgorithm fipsAlgorithm) {
        DRBGPseudoRandom dRBGPseudoRandom = this;
        synchronized (dRBGPseudoRandom) {
            this.lazyInitDRBG();
            return this.drbg.createSelfTest(fipsAlgorithm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VariantInternalKatTest createReseedSelfTest(FipsAlgorithm fipsAlgorithm) {
        DRBGPseudoRandom dRBGPseudoRandom = this;
        synchronized (dRBGPseudoRandom) {
            this.lazyInitDRBG();
            return this.drbg.createReseedSelfTest(fipsAlgorithm);
        }
    }
}

