/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.bc.math.ec;

import com.aspose.html.utils.ms.core.bc.math.ec.AbstractECMultiplier;
import com.aspose.html.utils.ms.core.bc.math.ec.ECAlgorithms;
import com.aspose.html.utils.ms.core.bc.math.ec.ECCurve;
import com.aspose.html.utils.ms.core.bc.math.ec.ECPoint;
import com.aspose.html.utils.ms.core.bc.math.ec.ECPointMap;
import com.aspose.html.utils.ms.core.bc.math.ec.endo.GLVEndomorphism;
import java.math.BigInteger;

public class GLVMultiplier
extends AbstractECMultiplier {
    protected final ECCurve curve;
    protected final GLVEndomorphism glvEndomorphism;

    public GLVMultiplier(ECCurve eCCurve, GLVEndomorphism gLVEndomorphism) {
        if (eCCurve == null || eCCurve.getOrder() == null) {
            throw new IllegalArgumentException("Need curve with known group order");
        }
        this.curve = eCCurve;
        this.glvEndomorphism = gLVEndomorphism;
    }

    protected ECPoint multiplyPositive(ECPoint eCPoint, BigInteger bigInteger) {
        ECCurve eCCurve = eCPoint.getCurve();
        if (!this.curve.equals(eCCurve)) {
            throw new IllegalStateException();
        }
        BigInteger bigInteger2 = eCCurve.getOrder();
        if (bigInteger.compareTo(bigInteger2) >= 0) {
            bigInteger = bigInteger.mod(bigInteger2.multiply(eCCurve.getCofactor()));
        }
        BigInteger[] bigIntegerArray = this.glvEndomorphism.decomposeScalar(bigInteger);
        BigInteger bigInteger3 = bigIntegerArray[0];
        BigInteger bigInteger4 = bigIntegerArray[1];
        ECPointMap eCPointMap = this.glvEndomorphism.getPointMap();
        if (this.glvEndomorphism.hasEfficientPointMap()) {
            return ECAlgorithms.implShamirsTrickWNaf(eCPoint, bigInteger3, eCPointMap, bigInteger4);
        }
        return ECAlgorithms.implShamirsTrickWNaf(eCPoint, bigInteger3, eCPointMap.map(eCPoint), bigInteger4);
    }
}

