/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.bc.crypto.internal.wrappers;

import com.aspose.html.utils.ms.core.bc.crypto.internal.BlockCipher;
import com.aspose.html.utils.ms.core.bc.crypto.internal.CipherParameters;
import com.aspose.html.utils.ms.core.bc.crypto.internal.Wrapper;
import com.aspose.html.utils.ms.core.bc.crypto.internal.params.KeyParameter;
import com.aspose.html.utils.ms.core.bc.crypto.internal.params.ParametersWithIV;

abstract class SP80038FWrapper
implements Wrapper {
    protected static final byte[] ivKW = new byte[]{-90, -90, -90, -90, -90, -90, -90, -90};
    protected static final byte[] ivKWP = new byte[]{-90, 89, 89, -90};
    protected final boolean wrapCipherMode;
    protected final BlockCipher engine;
    protected final int delta;
    protected final byte[] iv;
    protected KeyParameter param;
    protected boolean forWrapping;

    protected SP80038FWrapper(BlockCipher blockCipher, byte[] byArray, boolean bl2) {
        this.engine = blockCipher;
        this.wrapCipherMode = !bl2;
        this.delta = blockCipher.getBlockSize() / 2;
        this.iv = new byte[byArray.length > this.delta ? this.delta : byArray.length];
        System.arraycopy(byArray, 0, this.iv, 0, this.iv.length);
    }

    public void init(boolean bl2, CipherParameters cipherParameters) {
        this.forWrapping = bl2;
        if (cipherParameters instanceof KeyParameter) {
            this.param = (KeyParameter)cipherParameters;
        } else if (cipherParameters instanceof ParametersWithIV) {
            byte[] byArray = ((ParametersWithIV)cipherParameters).getIV();
            if (byArray.length != this.iv.length) {
                throw new IllegalArgumentException("IV not equal to " + ivKWP.length);
            }
            this.param = (KeyParameter)((ParametersWithIV)cipherParameters).getParameters();
            System.arraycopy(byArray, 0, this.iv, 0, this.iv.length);
        }
    }

    protected byte[] W(int n2, byte[] byArray) {
        byte[] byArray2 = new byte[this.engine.getBlockSize()];
        this.engine.init(this.wrapCipherMode, this.param);
        for (int i2 = 0; i2 != 6; ++i2) {
            for (int i3 = 1; i3 <= n2; ++i3) {
                System.arraycopy(byArray, 0, byArray2, 0, this.delta);
                System.arraycopy(byArray, this.delta * i3, byArray2, this.delta, this.delta);
                this.engine.processBlock(byArray2, 0, byArray2, 0);
                int n3 = n2 * i2 + i3;
                int n4 = 1;
                while (n3 != 0) {
                    byte by2 = (byte)n3;
                    int n5 = this.delta - n4;
                    byArray2[n5] = (byte)(byArray2[n5] ^ by2);
                    n3 >>>= 8;
                    ++n4;
                }
                System.arraycopy(byArray2, 0, byArray, 0, this.delta);
                System.arraycopy(byArray2, this.delta, byArray, this.delta * i3, this.delta);
            }
        }
        return byArray;
    }

    protected void invW(int n2, byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[this.engine.getBlockSize()];
        this.engine.init(!this.wrapCipherMode, this.param);
        --n2;
        for (int i2 = 5; i2 >= 0; --i2) {
            for (int i3 = n2; i3 >= 1; --i3) {
                System.arraycopy(byArray2, 0, byArray3, 0, this.delta);
                System.arraycopy(byArray, this.delta * (i3 - 1), byArray3, this.delta, this.delta);
                int n3 = n2 * i2 + i3;
                int n4 = 1;
                while (n3 != 0) {
                    byte by2 = (byte)n3;
                    int n5 = this.delta - n4;
                    byArray3[n5] = (byte)(byArray3[n5] ^ by2);
                    n3 >>>= 8;
                    ++n4;
                }
                this.engine.processBlock(byArray3, 0, byArray3, 0);
                System.arraycopy(byArray3, 0, byArray2, 0, this.delta);
                System.arraycopy(byArray3, this.delta, byArray, this.delta * (i3 - 1), this.delta);
            }
        }
    }
}

