/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.bc.cert.path.validations;

import com.aspose.html.utils.ms.core.bc.asn1.x509.BasicConstraints;
import com.aspose.html.utils.ms.core.bc.asn1.x509.Extension;
import com.aspose.html.utils.ms.core.bc.cert.X509CertificateHolder;
import com.aspose.html.utils.ms.core.bc.cert.path.CertPathValidation;
import com.aspose.html.utils.ms.core.bc.cert.path.CertPathValidationContext;
import com.aspose.html.utils.ms.core.bc.cert.path.CertPathValidationException;
import com.aspose.html.utils.ms.core.bc.util.Integers;
import com.aspose.html.utils.ms.core.bc.util.Memoable;
import java.math.BigInteger;

public class BasicConstraintsValidation
implements CertPathValidation {
    private boolean previousCertWasCA = true;
    private Integer maxPathLength = null;
    private boolean isMandatory = true;

    public BasicConstraintsValidation() {
        this(true);
    }

    public BasicConstraintsValidation(boolean bl2) {
        this.isMandatory = bl2;
    }

    public void validate(CertPathValidationContext certPathValidationContext, X509CertificateHolder x509CertificateHolder) throws CertPathValidationException {
        BigInteger bigInteger;
        certPathValidationContext.addHandledExtension(Extension.basicConstraints);
        if (!this.previousCertWasCA) {
            throw new CertPathValidationException("Basic constraints violated: issuer is not a CA");
        }
        BasicConstraints basicConstraints = BasicConstraints.fromExtensions(x509CertificateHolder.getExtensions());
        boolean bl2 = this.previousCertWasCA = basicConstraints != null && basicConstraints.isCA() || basicConstraints == null && !this.isMandatory;
        if (this.maxPathLength != null && !x509CertificateHolder.getSubject().equals(x509CertificateHolder.getIssuer())) {
            if (this.maxPathLength < 0) {
                throw new CertPathValidationException("Basic constraints violated: path length exceeded");
            }
            this.maxPathLength = Integers.valueOf(this.maxPathLength - 1);
        }
        if (basicConstraints != null && (bigInteger = basicConstraints.getPathLenConstraint()) != null) {
            int n2 = bigInteger.intValue();
            this.maxPathLength = this.maxPathLength == null ? Integers.valueOf(n2) : Integers.valueOf(Math.min(n2, this.maxPathLength));
        }
    }

    public Memoable copy() {
        BasicConstraintsValidation basicConstraintsValidation = new BasicConstraintsValidation();
        basicConstraintsValidation.isMandatory = this.isMandatory;
        basicConstraintsValidation.previousCertWasCA = this.previousCertWasCA;
        basicConstraintsValidation.maxPathLength = this.maxPathLength;
        return basicConstraintsValidation;
    }

    public void reset(Memoable memoable) {
        BasicConstraintsValidation basicConstraintsValidation = (BasicConstraintsValidation)memoable;
        this.isMandatory = basicConstraintsValidation.isMandatory;
        this.previousCertWasCA = basicConstraintsValidation.previousCertWasCA;
        this.maxPathLength = basicConstraintsValidation.maxPathLength;
    }
}

