/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.loaders;

import com.aspose.html.utils.Stream;
import com.aspose.html.utils.collections.generic.List;
import com.aspose.html.utils.ms.System.Array;
import com.aspose.html.utils.ms.System.BitConverter;
import com.aspose.html.utils.ms.System.Enum;
import com.aspose.html.utils.ms.System.InvalidOperationException;
import com.aspose.html.utils.ms.System.NotSupportedException;
import com.aspose.html.utils.ms.System.ObjectExtensions;
import com.aspose.html.utils.ms.System.StringExtensions;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.ByteConverter;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.Image;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.LoadOptions;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.RasterImage;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.StreamContainer;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.exif.ExifData;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.exif.JpegExifData;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.TiffCodec;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.TiffDataReader;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.TiffDataType;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.TiffFrame;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.TiffImage;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.codecs.readers.TiffJpegReader;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.codecs.readers.TiffOJpegReader;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.enums.TiffCompressions;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.filemanagement.TiffStream;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.filemanagement.TiffStreamFactory;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.tifftagtypes.TiffCommonArrayType;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.tifftagtypes.TiffLongType;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.tifftagtypes.TiffShortType;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.imageoptions.TiffOptions;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.interfaces.IImageLoader;
import com.aspose.html.utils.ms.lang.Operators;

public class TiffLoader
implements IImageLoader {
    private static final List<Integer> a = new List();

    public static TiffStream readExifHeader(Stream stream) {
        TiffStream tiffStream = null;
        byte[] byArray = new byte[4];
        stream.read(byArray, 0, 4);
        short s2 = (short)BitConverter.toInt16(byArray, 0);
        int n2 = 0;
        int[] nArray = new int[]{0};
        boolean bl2 = TiffLoader.getLittleBigEndian(s2, true, nArray);
        n2 = nArray[0];
        if (bl2) {
            short s3 = n2 == 19789 ? ByteConverter.fromBigEndianToInt16(byArray, 2) : (short)BitConverter.toInt16(byArray, 2);
            if (s3 != 42) {
                throw new InvalidOperationException("ImageLoadException: The EXIF header is unknown. Probably it is not a EXIF data format.");
            }
            stream.setPosition(stream.getPosition() - 4L);
            tiffStream = TiffStreamFactory.getTiffStream(stream, n2);
        }
        return tiffStream;
    }

    public static boolean getLittleBigEndian(short s2, boolean bl2, int[] nArray) {
        boolean bl3 = true;
        if (s2 == 18761) {
            nArray[0] = 18761;
        } else if (s2 == 19789) {
            nArray[0] = 19789;
        } else {
            nArray[0] = 0;
            bl3 = false;
            if (bl2) {
                throw new InvalidOperationException("ImageLoadException: The tiff header byte order is unknown. Probably it is not a tiff file format.");
            }
        }
        return bl3;
    }

    public static TiffStream readFileHeader(Stream stream, boolean bl2) {
        TiffStream tiffStream = null;
        byte[] byArray = new byte[4];
        stream.read(byArray, 0, 4);
        short s2 = (short)BitConverter.toInt16(byArray, 0);
        int n2 = 0;
        int[] nArray = new int[]{0};
        boolean bl3 = TiffLoader.getLittleBigEndian(s2, bl2, nArray);
        n2 = nArray[0];
        if (bl3) {
            short s3 = n2 == 19789 ? ByteConverter.fromBigEndianToInt16(byArray, 2) : (short)BitConverter.toInt16(byArray, 2);
            boolean bl4 = true;
            if (s3 != 42) {
                bl4 = false;
                if (bl2) {
                    throw new InvalidOperationException("ImageLoadException: The tiff header is unknown. Probably it is not a tiff file format.");
                }
            }
            if (bl4) {
                stream.seek(0L, 0);
                tiffStream = TiffStreamFactory.getTiffStream(stream, n2);
            }
        }
        return tiffStream;
    }

    @Override
    public Image load(StreamContainer streamContainer, LoadOptions loadOptions) {
        TiffStream tiffStream = TiffLoader.readFileHeader(streamContainer.getStream(), true);
        TiffFrame[] tiffFrameArray = this.a(tiffStream, loadOptions);
        TiffImage tiffImage = new TiffImage(tiffFrameArray);
        return tiffImage;
    }

    static JpegExifData getJpegExifDataOnly(TiffStream tiffStream) {
        long l2 = 4L;
        tiffStream.seek(l2, 0);
        RasterImage rasterImage = null;
        l2 = Operators.castToInt64(tiffStream.readULong(), 10);
        if (l2 > 0L) {
            TiffDataType[] tiffDataTypeArray;
            List<TiffDataType> list = new List<TiffDataType>();
            long l3 = tiffStream.seek(l2, 0);
            TiffDataType[] tiffDataTypeArray2 = TiffLoader.readDirectoryEntry(tiffStream);
            tiffStream.seek(l3 + (long)(tiffDataTypeArray2.length * 12) + 2L, 0);
            int n2 = Operators.castToInt32(tiffStream.readULong(), 10);
            list.addRange(Array.toGenericList(tiffDataTypeArray2));
            if (n2 != 0) {
                tiffStream.seek(n2, 0);
                tiffDataTypeArray = TiffLoader.readDirectoryEntry(tiffStream);
                boolean bl2 = false;
                long l4 = 0L;
                long l5 = 0L;
                for (int i2 = 0; i2 < tiffDataTypeArray.length; ++i2) {
                    TiffCommonArrayType tiffCommonArrayType;
                    if (Operators.castToUInt16(tiffDataTypeArray[i2].getId(), 8) == 259 && Operators.castToUInt16(((TiffShortType)(tiffCommonArrayType = (TiffShortType)tiffDataTypeArray[i2])).getValues()[0], 8) == 6) {
                        bl2 = true;
                    }
                    if (Operators.castToUInt16(tiffDataTypeArray[i2].getId(), 8) == 513) {
                        tiffCommonArrayType = (TiffLongType)tiffDataTypeArray[i2];
                        l4 = ((TiffLongType)tiffCommonArrayType).getValues()[0];
                    }
                    if (Operators.castToUInt16(tiffDataTypeArray[i2].getId(), 8) != 514) continue;
                    tiffCommonArrayType = (TiffLongType)tiffDataTypeArray[i2];
                    l5 = ((TiffLongType)tiffCommonArrayType).getValues()[0];
                }
                if (bl2 && Operators.castToUInt32(l4, 10) > 0L && Operators.castToUInt32(l5, 10) > 0L) {
                    tiffStream.seek(Operators.castToInt64(l4, 10), 0);
                    byte[] byArray = new byte[(int)Operators.castToUInt32(l5, 10)];
                    tiffStream.read(byArray, 0, Operators.castToInt32(l5, 10));
                }
            }
            if ((tiffDataTypeArray = TiffLoader.loadExifTags(tiffDataTypeArray2, tiffStream)) != null) {
                list.addRange(Array.toGenericList(tiffDataTypeArray));
            }
            if (list.size() > 0) {
                JpegExifData jpegExifData = new JpegExifData();
                jpegExifData.setProperties(list.toArray(new TiffDataType[0]));
                jpegExifData.setThumbnail(rasterImage);
                return jpegExifData;
            }
        }
        return null;
    }

    static TiffDataType[] loadExifTags(TiffDataType[] tiffDataTypeArray, TiffStream tiffStream) {
        long l2;
        TiffDataType tiffDataType;
        int n2;
        List<TiffDataType> list = new List<TiffDataType>();
        for (n2 = tiffDataTypeArray.length - 1; n2 >= 0; --n2) {
            if (Operators.castToUInt16(tiffDataTypeArray[n2].getId(), 8) != 34665) continue;
            tiffDataType = tiffDataTypeArray[n2];
            if (Operators.castToUInt32(tiffDataType.getCount(), 10) != 1L && ObjectExtensions.getType(tiffDataType) != Operators.typeOf(TiffLongType.class)) break;
            l2 = tiffStream.getPosition();
            long l3 = Operators.cast(tiffDataTypeArray[n2].getValue(), long[].class)[0];
            if (l3 > tiffStream.getLength()) break;
            tiffStream.seek(l3, 0);
            TiffDataType[] tiffDataTypeArray2 = TiffLoader.readDirectoryEntry(tiffStream);
            list.addRange(Array.toGenericList(tiffDataTypeArray2));
            tiffStream.seek(l2, 0);
            break;
        }
        for (n2 = tiffDataTypeArray.length - 1; n2 >= 0; --n2) {
            if (Operators.castToUInt16(tiffDataTypeArray[n2].getId(), 8) != 34853) continue;
            tiffDataType = tiffDataTypeArray[n2];
            if (Operators.castToUInt32(tiffDataType.getCount(), 10) != 1L && ObjectExtensions.getType(tiffDataType) != Operators.typeOf(TiffLongType.class)) break;
            l2 = tiffStream.getPosition();
            int n3 = Operators.cast(tiffDataTypeArray[n2].getValue(), int[].class)[0];
            if ((long)n3 > tiffStream.getLength()) break;
            tiffStream.seek(n3, 0);
            TiffDataType[] tiffDataTypeArray3 = TiffLoader.readDirectoryEntry(tiffStream);
            list.addRange(Array.toGenericList(tiffDataTypeArray3));
            tiffStream.seek(l2, 0);
            break;
        }
        return list.size() > 0 ? list.toArray(new TiffDataType[0]) : null;
    }

    public static TiffDataType[] readDirectoryEntry(TiffStream tiffStream) {
        long l2 = Operators.castToUInt32(tiffStream.readUShort(), 8);
        long l3 = tiffStream.getPosition();
        TiffDataType[] tiffDataTypeArray = new TiffDataType[(int)Operators.castToUInt32(l2, 10)];
        int n2 = 0;
        while ((long)n2 < Operators.castToUInt32(l2, 10)) {
            tiffStream.seek(l3, 0);
            tiffDataTypeArray[n2] = TiffDataType.readTag(tiffStream);
            l3 += 12L;
            ++n2;
        }
        return tiffDataTypeArray;
    }

    private static void a(TiffDataType[] tiffDataTypeArray, byte[][] byArray) {
        for (TiffDataType tiffDataType : tiffDataTypeArray) {
            if (Operators.castToUInt16(tiffDataType.getId(), 8) != 347) continue;
            byArray[0] = Operators.cast(tiffDataType.getValue(), byte[].class);
            return;
        }
    }

    private static void a(TiffOptions tiffOptions, TiffStream tiffStream, long l2, long l3) {
        TiffDataType[] tiffDataTypeArray = tiffOptions.getTags();
        long l4 = Operators.castToUInt32(tiffDataTypeArray.length, 9);
        long[] lArray = tiffOptions.getStripByteCounts();
        long[] lArray2 = tiffOptions.getStripOffsets();
        if (lArray2 != null && lArray2.length > 0 && Operators.castToUInt32(lArray2[0], 10) != 0L && (lArray == null || lArray.length > 0 && Operators.castToUInt32(lArray[0], 10) == 0L)) {
            if (lArray == null) {
                lArray = new long[lArray2.length];
            }
            long l5 = tiffStream.readULong();
            tiffStream.seek(l3, 0);
            if (Operators.castToUInt32(l5, 10) == 0L || Operators.castToUInt32(l5, 10) > tiffStream.getLength()) {
                l5 = Operators.castToUInt32(tiffStream.getLength(), 11);
            }
            if (tiffOptions.getCompression() != 1) {
                int n2;
                long l6 = Operators.castToUInt32(Operators.castToUInt32(Operators.castToUInt32(Operators.castToUInt32(Operators.castToUInt32(l2, 11), 10) + Operators.castToUInt32(2L, 10), 10) + Operators.castToUInt32(Operators.castToUInt32(l4, 10) * Operators.castToUInt32(12, 9), 10), 10) + 4L, 10);
                for (TiffDataType tiffDataType : tiffDataTypeArray) {
                    l6 = Operators.castToUInt32(Operators.castToUInt32(l6, 10) + Operators.castToUInt32(tiffDataType.getDataSize(), 10), 10);
                }
                l6 = Operators.castToUInt32(Operators.castToUInt32(l5, 10) - Operators.castToUInt32(l6, 10), 10);
                if (tiffOptions.getPlanarConfiguration() == 2) {
                    l6 = Operators.castToUInt32(Operators.castToUInt32(l6, 10) / Operators.castToUInt32(tiffOptions.getSamplesPerPixel(), 8), 10);
                }
                for (n2 = 0; n2 < lArray.length; ++n2) {
                    lArray[n2] = l6;
                }
                if (Operators.castToUInt32(Operators.castToUInt32(lArray2[--n2], 10) + Operators.castToUInt32(lArray[n2], 10), 10) > Operators.castToUInt32(l5, 10)) {
                    lArray[n2] = Operators.castToUInt32(Operators.castToUInt32(l5, 10) - Operators.castToUInt32(lArray2[n2], 10), 10);
                }
            } else {
                long l7 = TiffLoader.a(tiffOptions);
                long l8 = Operators.castToUInt32(TiffCodec.getRowsPerStrip(tiffOptions), 9);
                for (int i2 = 0; i2 < lArray.length; ++i2) {
                    lArray[i2] = Operators.castToUInt32(Operators.castToUInt32(l7, 10) * Operators.castToUInt32(l8, 10), 10);
                }
            }
            tiffOptions.setStripByteCounts(lArray);
        }
    }

    private static long a(TiffOptions tiffOptions) {
        long l2;
        int[] nArray = tiffOptions.getBitsPerSample();
        if (nArray == null || nArray.length == 0) {
            throw new InvalidOperationException("TiffImageException: Cannot estimate scan line size for YcBcR since bits per sample is not specified.");
        }
        if (tiffOptions.getPlanarConfiguration() == 1) {
            if (tiffOptions.getPhotometric() == 6) {
                TiffDataType tiffDataType = tiffOptions.getTagByType(530);
                if (tiffDataType == null) {
                    tiffDataType = new TiffShortType(530);
                    tiffDataType.setValue(new int[]{2});
                }
                if (!Operators.is(tiffDataType.getValue(), int[].class)) {
                    throw new InvalidOperationException("TiffImageException: Cannot estimate scan line size for YcBcR since YcbcrSubSampling tag is not short type.");
                }
                int[] nArray2 = Operators.cast(tiffDataType.getValue(), int[].class);
                if (nArray2.length == 0) {
                    throw new InvalidOperationException("TiffImageException: Cannot estimate scan line size for YcBcR since YcbcrSubSampling tag contains empty array.");
                }
                int n2 = nArray2[0];
                if (Operators.castToUInt16(n2, 8) == 0) {
                    throw new InvalidOperationException("TiffImageException: Cannot estimate scan line size for YcBcR since YcbcrSubSampling tag contains invalid value.");
                }
                long l3 = (Operators.castToInt64(tiffOptions.getImageWidth(), 10) + (Operators.castToInt64(n2, 8) - 1L)) / Operators.castToInt64(n2, 8);
                if (l3 > Integer.MAX_VALUE) {
                    l3 = 0L;
                }
                long l4 = Operators.castToUInt32(Operators.castToUInt32(Operators.castToUInt32(l3, 11), 10) * Operators.castToUInt32(n2, 8), 10);
                l4 = Operators.castToUInt32(Operators.castToUInt32(Operators.castToUInt32(Operators.castToUInt32(l4, 10) * Operators.castToUInt32(nArray[0], 8), 10) + 7L, 10) / 8L, 10);
                return Operators.castToUInt32(Operators.castToUInt32(l4, 10) + Operators.castToUInt32(2L * Operators.castToUInt32(Operators.castToUInt32(l4, 10) / Operators.castToUInt32(n2, 8), 10), 10), 10);
            }
            l2 = Operators.castToUInt32(Operators.castToUInt32(tiffOptions.getImageWidth(), 10) * Operators.castToUInt32(tiffOptions.getSamplesPerPixel(), 8), 10);
        } else {
            l2 = tiffOptions.getImageWidth();
        }
        return Operators.castToUInt32(Operators.castToUInt32(Operators.castToUInt32(Operators.castToUInt32(l2, 10) * Operators.castToUInt32(nArray[0], 8), 10) + 7L, 10) / 8L, 10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TiffFrame[] a(TiffStream tiffStream, LoadOptions loadOptions) {
        TiffFrame[] tiffFrameArray;
        List<Object> list = new List<Object>();
        byte[] byArray = null;
        try {
            long l2 = 4L;
            do {
                Object object;
                int n2;
                TiffDataType[] tiffDataTypeArray;
                tiffStream.seek(l2, 0);
                l2 = Operators.castToInt64(tiffStream.readULong(), 10);
                if (l2 >= tiffStream.getLength()) break;
                if (l2 <= 0L) continue;
                tiffStream.seek(l2, 0);
                tiffStream.setThrowExceptions(false);
                try {
                    tiffDataTypeArray = TiffLoader.readDirectoryEntry(tiffStream);
                }
                finally {
                    tiffStream.setThrowExceptions(true);
                }
                TiffOptions tiffOptions = new TiffOptions(tiffDataTypeArray);
                TiffDataType[] tiffDataTypeArray2 = TiffLoader.loadExifTags(tiffDataTypeArray, tiffStream);
                long l3 = l2;
                tiffStream.seek(l2 += (long)(12 * tiffDataTypeArray.length + 2), 0);
                TiffLoader.a(tiffOptions, tiffStream, l3, l2);
                if (tiffDataTypeArray.length <= 0) break;
                int n3 = Operators.castToInt32(tiffOptions.getImageLength(), 10);
                int n4 = Operators.castToInt32(tiffOptions.getImageWidth(), 10);
                byte[][] byArrayArray = new byte[][]{byArray};
                TiffLoader.a(tiffDataTypeArray, byArrayArray);
                byArray = byArrayArray[0];
                if (tiffOptions.isTagPresent(259) && (n2 = a.binarySearch(tiffOptions.getCompression())) < 0) {
                    throw new NotSupportedException("Unsupported compression type " + Enum.getName(TiffCompressions.class, tiffOptions.getCompression()));
                }
                TiffOptions tiffOptions2 = new TiffOptions(tiffOptions);
                TiffDataReader tiffDataReader = new TiffDataReader(tiffOptions2, n4, n3, tiffStream.getStream(), loadOptions);
                TiffJpegReader tiffJpegReader = Operators.as(tiffDataReader.getCodec(), TiffJpegReader.class);
                if (tiffJpegReader != null) {
                    tiffJpegReader.setTablesData(byArray);
                }
                if (Operators.is(tiffDataReader.getCodec(), TiffOJpegReader.class)) {
                    object = Operators.as(tiffDataReader.getCodec(), TiffOJpegReader.class);
                    ((TiffOJpegReader)object).setFrameTags(tiffDataTypeArray);
                }
                object = new TiffFrame(tiffOptions, n4, n3, tiffDataReader);
                if (tiffDataTypeArray2 != null) {
                    ((TiffFrame)object).setExifData(new ExifData());
                    ((TiffFrame)object).getExifData().setProperties(tiffDataTypeArray2);
                }
                list.addItem(object);
            } while (l2 > 0L);
            tiffFrameArray = new TiffFrame[list.size()];
            list.copyToTArray(tiffFrameArray, 0);
        }
        catch (RuntimeException runtimeException) {
            throw new InvalidOperationException(StringExtensions.concat("ImageLoadException: Unable to read file. Exception: ", runtimeException.getMessage()), runtimeException);
        }
        return tiffFrameArray;
    }

    public static TiffImage read(Stream stream) {
        StreamContainer streamContainer = new StreamContainer(stream);
        Image image = new TiffLoader().load(streamContainer, null);
        image.setDataStreamContainer(streamContainer);
        return (TiffImage)image;
    }

    static {
        a.addItem(5);
        a.addItem(3);
        a.addItem(2);
        a.addItem(4);
        a.addItem(7);
        a.addItem(1);
        a.addItem(32946);
        a.addItem(8);
        a.addItem(6);
        a.addItem(32773);
        a.sort();
    }
}

