/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core;

import com.aspose.html.utils.ms.System.ArgumentException;
import com.aspose.html.utils.ms.System.ArgumentNullException;
import com.aspose.html.utils.ms.System.StringExtensions;
import com.aspose.html.utils.ms.System.msMath;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.DataStreamSupporter;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.Point;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.Rectangle;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.Size;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.interfaces.IColorPalette;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.interfaces.IObjectWithBounds;
import java.awt.Color;

public abstract class Image
extends DataStreamSupporter
implements IObjectWithBounds {
    private Image a;
    private boolean b = true;
    private IColorPalette c;

    public Image() {
    }

    protected Image(IColorPalette iColorPalette) {
        this.c = iColorPalette;
    }

    public abstract int getBitsPerPixel();

    @Override
    public Rectangle getBounds() {
        this.verifyNotDisposed();
        return new Rectangle(Point.getEmpty().Clone(), this.getSize().Clone());
    }

    public Image getContainer() {
        return this.a;
    }

    @Override
    public abstract int getHeight();

    public IColorPalette getPalette() {
        return this.c;
    }

    public void setPalette(IColorPalette iColorPalette) {
        if (this.c != iColorPalette) {
            IColorPalette iColorPalette2 = this.c;
            this.onPaletteChanging(iColorPalette2, iColorPalette);
            this.c = iColorPalette;
            this.onPaletteChanged(iColorPalette2, iColorPalette);
        }
    }

    @Override
    public Size getSize() {
        this.verifyNotDisposed();
        return new Size(this.getWidth(), this.getHeight());
    }

    @Override
    public abstract int getWidth();

    boolean isWatermarkPartlyVisible() {
        return this.b;
    }

    void isWatermarkPartlyVisible(boolean bl2) {
        this.b = bl2;
    }

    public boolean hasBackgroundColor() {
        return false;
    }

    public void setBackgroundColor(boolean bl2) {
    }

    public int getBackgroundColor() {
        return Color.WHITE.getRGB();
    }

    public void setBackgroundColor(int n2) {
    }

    public static Rectangle getFittingRectangle(Rectangle rectangle, int n2, int n3) {
        Rectangle rectangle2 = Rectangle.intersect(rectangle.Clone(), new Rectangle(new Point(), new Size(msMath.abs(n2), msMath.abs(n3)))).Clone();
        if (rectangle2.getWidth() <= 0 || rectangle2.getHeight() <= 0) {
            throw new ArgumentException("The rectangle has no common processing area. Cannot proceed.");
        }
        return rectangle2;
    }

    public static Rectangle getFittingRectangle(Rectangle rectangle, int[] nArray, int n2, int n3) {
        if (nArray == null) {
            throw new ArgumentNullException("pixels");
        }
        Rectangle rectangle2 = Image.getFittingRectangle(rectangle.Clone(), n2, n3).Clone();
        if (nArray.length < rectangle2.getWidth() * rectangle2.getHeight()) {
            String string = StringExtensions.format("The passed rectangle does not correspond to pixels array size. Expected: {0} pixels, passed: {1} pixels.", rectangle2.getWidth() * rectangle2.getHeight(), nArray.length);
            throw new ArgumentException(string);
        }
        return rectangle2;
    }

    public void resize(int n2, int n3) {
        this.resize(n2, n3, 1);
    }

    public abstract void resize(int var1, int var2, int var3);

    public abstract void rotateFlip(int var1);

    public abstract void setPalette(IColorPalette var1, boolean var2);

    public void setContainer(Image image) {
        this.a = image;
    }

    protected Rectangle getFitRectangle(Rectangle rectangle) {
        return Image.getFittingRectangle(rectangle.Clone(), this.getWidth(), this.getHeight());
    }

    protected Rectangle getFitRectangle(Rectangle rectangle, int[] nArray) {
        return Image.getFittingRectangle(rectangle.Clone(), nArray, this.getWidth(), this.getHeight());
    }

    public void onPaletteChanged(IColorPalette iColorPalette, IColorPalette iColorPalette2) {
    }

    public void onPaletteChanging(IColorPalette iColorPalette, IColorPalette iColorPalette2) {
    }

    @Override
    protected void releaseManagedResources() {
        this.a = null;
        this.c = null;
        super.releaseManagedResources();
    }
}

