/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.System.Xml;

import com.aspose.html.utils.ms.System.StringExtensions;
import com.aspose.html.utils.ms.System.Uri;
import com.aspose.html.utils.ms.System.UriFormatException;
import com.aspose.html.utils.ms.System.Xml.IHasXmlChildNode;
import com.aspose.html.utils.ms.System.Xml.XmlConvert;
import com.aspose.html.utils.ms.System.Xml.XmlDocument;
import com.aspose.html.utils.ms.System.Xml.XmlDocumentType;
import com.aspose.html.utils.ms.System.Xml.XmlEntity;
import com.aspose.html.utils.ms.System.Xml.XmlException;
import com.aspose.html.utils.ms.System.Xml.XmlLinkedNode;
import com.aspose.html.utils.ms.System.Xml.XmlNode;
import com.aspose.html.utils.ms.System.Xml.XmlResolver;
import com.aspose.html.utils.ms.System.Xml.XmlWriter;

public class XmlEntityReference
extends XmlLinkedNode
implements IHasXmlChildNode {
    private String a;
    private XmlLinkedNode b;

    protected XmlEntityReference(String string, XmlDocument xmlDocument) {
        super(xmlDocument);
        XmlConvert.verifyName(string);
        this.a = xmlDocument.getNameTable().add(string);
    }

    @Override
    public XmlLinkedNode getLastLinkedChild() {
        return this.b;
    }

    @Override
    public void setLastLinkedChild(XmlLinkedNode xmlLinkedNode) {
        this.b = xmlLinkedNode;
    }

    @Override
    public String getBaseURI() {
        return super.getBaseURI();
    }

    private XmlEntity a() {
        XmlDocumentType xmlDocumentType = this.getOwnerDocument().getDocumentType();
        if (xmlDocumentType == null) {
            return null;
        }
        if (xmlDocumentType.getEntities() == null) {
            return null;
        }
        XmlNode xmlNode = xmlDocumentType.getEntities().getNamedItem(this.getName());
        return xmlNode instanceof XmlEntity ? (XmlEntity)xmlNode : null;
    }

    @Override
    String getChildrenBaseURI() {
        XmlEntity xmlEntity = this.a();
        if (xmlEntity == null) {
            return StringExtensions.Empty;
        }
        if (xmlEntity.getSystemId() == null || xmlEntity.getSystemId().length() == 0) {
            return xmlEntity.getBaseURI();
        }
        if (xmlEntity.getBaseURI() == null || xmlEntity.getBaseURI().length() == 0) {
            return xmlEntity.getSystemId();
        }
        Uri uri = null;
        try {
            uri = new Uri(xmlEntity.getBaseURI());
        }
        catch (UriFormatException uriFormatException) {
            // empty catch block
        }
        XmlResolver xmlResolver = this.getOwnerDocument().getResolver();
        if (xmlResolver != null) {
            return xmlResolver.resolveUri(uri, xmlEntity.getSystemId()).toString();
        }
        return new Uri(uri, xmlEntity.getSystemId()).toString();
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public String getLocalName() {
        return this.a;
    }

    @Override
    public String getName() {
        return this.a;
    }

    @Override
    public int getNodeType() {
        return 5;
    }

    @Override
    public String getValue() {
        return null;
    }

    @Override
    public void setValue(String string) {
        throw new XmlException("entity reference cannot be set value.");
    }

    @Override
    int getXPathNodeType() {
        return 4;
    }

    @Override
    public XmlNode cloneNode(boolean bl2) {
        return new XmlEntityReference(this.getName(), this.getOwnerDocument());
    }

    @Override
    public void writeContentTo(XmlWriter xmlWriter) {
        for (int i2 = 0; i2 < this.getChildNodes().getCount(); ++i2) {
            this.getChildNodes().get_ItemOf(i2).writeTo(xmlWriter);
        }
    }

    @Override
    public void writeTo(XmlWriter xmlWriter) {
        xmlWriter.writeRaw("&");
        xmlWriter.writeName(this.getName());
        xmlWriter.writeRaw(";");
    }

    void setReferencedEntityContent() {
        if (this.getFirstChild() != null) {
            return;
        }
        if (this.getOwnerDocument().getDocumentType() == null) {
            return;
        }
        XmlEntity xmlEntity = this.a();
        if (xmlEntity == null) {
            this.insertBefore(this.getOwnerDocument().createTextNode(StringExtensions.Empty), null, false, true);
        } else {
            for (int i2 = 0; i2 < xmlEntity.getChildNodes().getCount(); ++i2) {
                this.insertBefore(xmlEntity.getChildNodes().get_ItemOf(i2).cloneNode(true), null, false, true);
            }
        }
    }
}

