/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.System.Xml;

import com.aspose.html.utils.abN;
import com.aspose.html.utils.ms.System.ByteExtensions;
import com.aspose.html.utils.ms.System.Collections.Hashtable;
import com.aspose.html.utils.ms.System.Convert;
import com.aspose.html.utils.ms.System.Decimal;
import com.aspose.html.utils.ms.System.Enum;
import com.aspose.html.utils.ms.System.Globalization.CultureInfo;
import com.aspose.html.utils.ms.System.Guid;
import com.aspose.html.utils.ms.System.IFormattable;
import com.aspose.html.utils.ms.System.Int32Extensions;
import com.aspose.html.utils.ms.System.InvalidOperationException;
import com.aspose.html.utils.ms.System.NullReferenceException;
import com.aspose.html.utils.ms.System.StringExtensions;
import com.aspose.html.utils.ms.System.Text.msStringBuilder;
import com.aspose.html.utils.ms.System.Xml.TypeData;
import com.aspose.html.utils.ms.System.Xml.XmlConvert;
import com.aspose.html.utils.ms.lang.Operators;
import com.aspose.html.utils.ms.lang.StringSwitchMap;

class XmlCustomFormatter {
    private static final StringSwitchMap a = new StringSwitchMap("boolean", "unsignedByte", "char", "dateTime", "date", "time", "decimal", "double", "short", "int", "long", "byte", "float", "unsignedShort", "unsignedInt", "unsignedLong", "guid", "base64", "base64Binary", "hexBinary", "duration", "NMTOKEN", "Name", "NCName", "language", "ENTITY", "ID", "IDREF", "NOTATION", "token", "normalizedString", "string", "base64:");

    XmlCustomFormatter() {
    }

    static String fromByteArrayBase64(byte[] byArray) {
        return byArray == null ? StringExtensions.Empty : Convert.toBase64String(byArray);
    }

    static String fromByteArrayHex(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        msStringBuilder msStringBuilder2 = new msStringBuilder();
        for (byte by2 : byArray) {
            msStringBuilder2.append(ByteExtensions.toString(by2, "X2", CultureInfo.getInvariantCulture()));
        }
        return msStringBuilder2.toString();
    }

    static String fromChar(char c2) {
        return Int32Extensions.toString(Operators.castToInt32(Character.valueOf(c2), 4), CultureInfo.getInvariantCulture());
    }

    static String fromDate(abN abN2) {
        return XmlConvert.toString_DateTime(abN2.anr(), "yyyy-MM-dd");
    }

    static String fromDateTime(abN abN2) {
        return XmlConvert.toString_DateTime(abN2.anr(), 3);
    }

    static String fromTime(abN abN2) {
        return XmlConvert.toString_DateTime(abN2.anr(), "HH:mm:ss.fffffffzzz");
    }

    static String fromEnum(long l2, String[] stringArray, long[] lArray) {
        return XmlCustomFormatter.fromEnum(l2, stringArray, lArray, null);
    }

    static String fromEnum(long l2, String[] stringArray, long[] lArray, String string) {
        if (lArray == null || stringArray == null) {
            throw new NullReferenceException();
        }
        msStringBuilder msStringBuilder2 = new msStringBuilder();
        int n2 = lArray.length;
        long l3 = l2;
        int n3 = -1;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (lArray[i2] == 0L) {
                n3 = i2;
                continue;
            }
            if (l3 == 0L) break;
            if ((lArray[i2] & l2) != lArray[i2]) continue;
            if (msStringBuilder2.getLength() != 0) {
                msStringBuilder2.append(' ');
            }
            msStringBuilder2.append(stringArray[i2]);
            l3 &= lArray[i2] ^ 0xFFFFFFFFFFFFFFFFL;
        }
        if (l3 != 0L) {
            if (string != null) {
                throw new InvalidOperationException(StringExtensions.format(CultureInfo.getCurrentCulture(), "'{0}' is not a valid value for {1}.", l2, string));
            }
            throw new InvalidOperationException(StringExtensions.format(CultureInfo.getCurrentCulture(), "'{0}' is not a valid value.", l2));
        }
        if (msStringBuilder2.getLength() == 0 && n3 != -1) {
            msStringBuilder2.append(stringArray[n3]);
        }
        return msStringBuilder2.toString();
    }

    static String fromXmlName(String string) {
        return XmlConvert.encodeName(string);
    }

    static String fromXmlNCName(String string) {
        return XmlConvert.encodeLocalName(string);
    }

    static String fromXmlNmToken(String string) {
        return XmlConvert.encodeNmToken(string);
    }

    static String fromXmlNmTokens(String string) {
        String[] stringArray = StringExtensions.split(string, ' ');
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            stringArray[i2] = XmlCustomFormatter.fromXmlNmToken(stringArray[i2]);
        }
        return StringExtensions.join(" ", stringArray);
    }

    static byte[] toByteArrayBase64(String string) {
        return Convert.fromBase64String(string);
    }

    static char toChar(String string) {
        return Operators.castToChar(XmlConvert.toUInt16(string), 8);
    }

    static abN toDate(String string) {
        return XmlCustomFormatter.toDateTime(string);
    }

    static abN toDateTime(String string) {
        return XmlConvert.toDateTime(string, 3);
    }

    static abN toTime(String string) {
        return XmlCustomFormatter.toDateTime(string);
    }

    static long toEnum(String string, Hashtable hashtable, String string2, boolean bl2) {
        String[] stringArray;
        if (hashtable == null) {
            throw new NullReferenceException();
        }
        long l2 = 0L;
        for (String string3 : stringArray = StringExtensions.split(string, ' ')) {
            Object object = hashtable.get_Item(string3);
            if (object != null) {
                l2 |= Operators.unboxing(object, Long.TYPE).longValue();
                continue;
            }
            if (!bl2 || string3.length() == 0) continue;
            throw new InvalidOperationException(StringExtensions.format("'{0}' is not a valid member of type {1}.", string3, string2));
        }
        return l2;
    }

    static String toXmlName(String string) {
        return XmlConvert.decodeName(string);
    }

    static String toXmlNCName(String string) {
        return XmlCustomFormatter.toXmlName(string);
    }

    static String toXmlNmToken(String string) {
        return XmlCustomFormatter.toXmlName(string);
    }

    static String toXmlNmTokens(String string) {
        return XmlCustomFormatter.toXmlName(string);
    }

    static String toXmlString(TypeData typeData, Object object) {
        if (object == null) {
            return null;
        }
        if (Operators.typeOf(object.getClass()).isEnum()) {
            return Enum.format(Operators.typeOf(object.getClass()), object, "g");
        }
        switch (a.of(typeData.getXmlType())) {
            case 0: {
                return XmlConvert.toString_Bool(Operators.unboxing(object, Boolean.TYPE));
            }
            case 1: {
                return XmlConvert.toString_Byte(Operators.unboxing(object, Byte.TYPE));
            }
            case 2: {
                return XmlConvert.toString_Int32(Operators.castToInt32((Character)object, 4));
            }
            case 3: {
                return XmlConvert.toString_DateTime(Operators.unboxing(object, abN.class).anr(), 3);
            }
            case 4: {
                return Operators.unboxing(object, abN.class).toString("yyyy-MM-dd", CultureInfo.getInvariantCulture());
            }
            case 5: {
                return Operators.unboxing(object, abN.class).toString("HH:mm:ss.FFFFFFF", CultureInfo.getInvariantCulture());
            }
            case 6: {
                return XmlConvert.toString_Decimal(Operators.unboxing(object, Decimal.class).Clone());
            }
            case 7: {
                return XmlConvert.toString_Double(Operators.unboxing(object, Double.TYPE));
            }
            case 8: {
                return XmlConvert.toString_Int16(Operators.unboxing(object, Short.TYPE));
            }
            case 9: {
                return XmlConvert.toString_Int32(Operators.unboxing(object, Integer.TYPE));
            }
            case 10: {
                return XmlConvert.toString_Int64(Operators.unboxing(object, Long.TYPE));
            }
            case 11: {
                return XmlConvert.toString_SByte(Operators.unboxing(object, Byte.TYPE));
            }
            case 12: {
                return XmlConvert.toString_Float(Operators.unboxing(object, Float.TYPE).floatValue());
            }
            case 13: {
                return XmlConvert.toString_UInt16(Operators.unboxing(object, Integer.TYPE));
            }
            case 14: {
                return XmlConvert.toString_UInt32(Operators.unboxing(object, Long.TYPE));
            }
            case 15: {
                return XmlConvert.toString_UInt64(Operators.unboxing(object, Long.TYPE));
            }
            case 16: {
                return XmlConvert.toString_Guid(Operators.unboxing(object, Guid.class).Clone());
            }
            case 17: 
            case 18: {
                return object == null ? StringExtensions.Empty : Convert.toBase64String(Operators.cast(object, byte[].class));
            }
            case 19: {
                return object == null ? StringExtensions.Empty : XmlConvert.toBinHexString(Operators.cast(object, byte[].class));
            }
            case 20: {
                return (String)object;
            }
        }
        return Operators.is(object, IFormattable.class) ? ((IFormattable)object).toString(null, CultureInfo.getInvariantCulture()) : object.toString();
    }

    static Object fromXmlString(TypeData typeData, String string) {
        if (string == null) {
            return null;
        }
        switch (a.of(typeData.getXmlType())) {
            case 0: {
                return XmlConvert.toBoolean(string);
            }
            case 1: {
                return XmlConvert.toByte(string);
            }
            case 2: {
                return Character.valueOf((char)XmlConvert.toInt32(string));
            }
            case 3: {
                return XmlConvert.toDateTime(string, 3);
            }
            case 4: {
                return abN.a(string, "yyyy-MM-dd", null);
            }
            case 5: {
                return abN.a(string, "HH:mm:ss.FFFFFFF", null);
            }
            case 6: {
                return XmlConvert.toDecimal(string);
            }
            case 7: {
                return XmlConvert.toDouble(string);
            }
            case 8: {
                return XmlConvert.toInt16(string);
            }
            case 9: {
                return XmlConvert.toInt32(string);
            }
            case 10: {
                return XmlConvert.toInt64(string);
            }
            case 11: {
                return XmlConvert.toSByte(string);
            }
            case 12: {
                return Float.valueOf(XmlConvert.toSingle(string));
            }
            case 13: {
                return XmlConvert.toUInt16(string);
            }
            case 14: {
                return XmlConvert.toUInt32(string);
            }
            case 15: {
                return XmlConvert.toUInt64(string);
            }
            case 16: {
                return XmlConvert.toGuid(string);
            }
            case 17: 
            case 18: {
                return Convert.fromBase64String(string);
            }
            case 19: {
                return XmlConvert.fromBinHexString(string);
            }
            case 20: {
                return string;
            }
        }
        if (typeData.getType() != null) {
            return Convert.changeType((Object)string, typeData.getType(), null);
        }
        return string;
    }

    static String generateToXmlString(TypeData typeData, String string) {
        if (typeData.getNullableOverride()) {
            return StringExtensions.concat("(", string, " != null ? ", XmlCustomFormatter.generateToXmlStringCore(typeData, string), " : null)");
        }
        return XmlCustomFormatter.generateToXmlStringCore(typeData, string);
    }

    static String generateToXmlStringCore(TypeData typeData, String string) {
        if (typeData.getNullableOverride()) {
            string = StringExtensions.concat(string, ".Value");
        }
        switch (a.of(typeData.getXmlType())) {
            case 0: {
                return StringExtensions.concat("(", string, "?\"true\":\"false\")");
            }
            case 1: {
                return StringExtensions.concat(string, ".ToString(CultureInfo.InvariantCulture)");
            }
            case 2: {
                return StringExtensions.concat("((int)(", string, ")).ToString(CultureInfo.InvariantCulture)");
            }
            case 3: {
                return StringExtensions.concat("XmlConvert.ToString (", string, ", XmlDateTimeSerializationMode.RoundtripKind)");
            }
            case 4: {
                return StringExtensions.concat(string, ".ToString(\"yyyy-MM-dd\", CultureInfo.InvariantCulture)");
            }
            case 5: {
                return StringExtensions.concat(string, ".ToString(\"HH:mm:ss.FFFFFFF\", CultureInfo.InvariantCulture)");
            }
            case 6: {
                return StringExtensions.concat("XmlConvert.ToString (", string, ")");
            }
            case 7: {
                return StringExtensions.concat("XmlConvert.ToString (", string, ")");
            }
            case 8: {
                return StringExtensions.concat(string, ".ToString(CultureInfo.InvariantCulture)");
            }
            case 9: {
                return StringExtensions.concat(string, ".ToString(CultureInfo.InvariantCulture)");
            }
            case 10: {
                return StringExtensions.concat(string, ".ToString(CultureInfo.InvariantCulture)");
            }
            case 11: {
                return StringExtensions.concat(string, ".ToString(CultureInfo.InvariantCulture)");
            }
            case 12: {
                return StringExtensions.concat("XmlConvert.ToString (", string, ")");
            }
            case 13: {
                return StringExtensions.concat(string, ".ToString(CultureInfo.InvariantCulture)");
            }
            case 14: {
                return StringExtensions.concat(string, ".ToString(CultureInfo.InvariantCulture)");
            }
            case 15: {
                return StringExtensions.concat(string, ".ToString(CultureInfo.InvariantCulture)");
            }
            case 16: {
                return StringExtensions.concat("XmlConvert.ToString (", string, ")");
            }
            case 17: 
            case 18: {
                return StringExtensions.concat(string, " == null ? String.Empty : Convert.ToBase64String (", string, ")");
            }
            case 19: {
                return StringExtensions.concat(string, " == null ? String.Empty : ToBinHexString (", string, ")");
            }
            case 20: {
                return string;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                return string;
            }
        }
        return StringExtensions.concat("((", string, " != null) ? (", string, ").ToString() : null)");
    }

    static String generateFromXmlString(TypeData typeData, String string) {
        if (typeData.getNullableOverride()) {
            return StringExtensions.concat("(", string, " != null ? (", typeData.getCSharpName(), "?)", XmlCustomFormatter.generateFromXmlStringCore(typeData, string), " : null)");
        }
        return XmlCustomFormatter.generateFromXmlStringCore(typeData, string);
    }

    static String generateFromXmlStringCore(TypeData typeData, String string) {
        switch (a.of(typeData.getXmlType())) {
            case 0: {
                return StringExtensions.concat("XmlConvert.ToBoolean (", string, ")");
            }
            case 1: {
                return StringExtensions.concat("byte.Parse (", string, ", CultureInfo.InvariantCulture)");
            }
            case 2: {
                return StringExtensions.concat("(char)Int32.Parse (", string, ", CultureInfo.InvariantCulture)");
            }
            case 3: {
                return StringExtensions.concat("XmlConvert.ToDateTime (", string, ", XmlDateTimeSerializationMode.RoundtripKind)");
            }
            case 4: {
                return StringExtensions.concat("DateTime.ParseExact (", string, ", \"yyyy-MM-dd\", CultureInfo.InvariantCulture)");
            }
            case 5: {
                return StringExtensions.concat("DateTime.ParseExact (", string, ", \"HH:mm:ss.FFFFFFF\", CultureInfo.InvariantCulture)");
            }
            case 6: {
                return StringExtensions.concat("Decimal.Parse (", string, ", CultureInfo.InvariantCulture)");
            }
            case 7: {
                return StringExtensions.concat("XmlConvert.ToDouble (", string, ")");
            }
            case 8: {
                return StringExtensions.concat("Int16.Parse (", string, ", CultureInfo.InvariantCulture)");
            }
            case 9: {
                return StringExtensions.concat("Int32.Parse (", string, ", CultureInfo.InvariantCulture)");
            }
            case 10: {
                return StringExtensions.concat("Int64.Parse (", string, ", CultureInfo.InvariantCulture)");
            }
            case 11: {
                return StringExtensions.concat("SByte.Parse (", string, ", CultureInfo.InvariantCulture)");
            }
            case 12: {
                return StringExtensions.concat("XmlConvert.ToSingle (", string, ")");
            }
            case 13: {
                return StringExtensions.concat("UInt16.Parse (", string, ", CultureInfo.InvariantCulture)");
            }
            case 14: {
                return StringExtensions.concat("UInt32.Parse (", string, ", CultureInfo.InvariantCulture)");
            }
            case 15: {
                return StringExtensions.concat("UInt64.Parse (", string, ", CultureInfo.InvariantCulture)");
            }
            case 16: {
                return StringExtensions.concat("XmlConvert.ToGuid (", string, ")");
            }
            case 18: 
            case 32: {
                return StringExtensions.concat("Convert.FromBase64String (", string, ")");
            }
            case 19: {
                return StringExtensions.concat("FromBinHexString (", string, ")");
            }
            case 20: {
                return string;
            }
        }
        return string;
    }
}

