/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.System.Text;

import com.aspose.html.utils.ms.System.ArgumentException;
import com.aspose.html.utils.ms.System.ArgumentNullException;
import com.aspose.html.utils.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.utils.ms.System.StringExtensions;
import com.aspose.html.utils.ms.System.Text.Decoder;
import com.aspose.html.utils.ms.System.Text.DecoderExceptionFallback;
import com.aspose.html.utils.ms.System.Text.DecoderFallback;
import com.aspose.html.utils.ms.System.Text.DecoderReplacementFallback;
import com.aspose.html.utils.ms.System.Text.Encoder;
import com.aspose.html.utils.ms.System.Text.EncoderFallback;
import com.aspose.html.utils.ms.core.mscorlib.d.fg;
import com.aspose.html.utils.ms.core.mscorlib.e.e;
import com.aspose.html.utils.ms.core.mscorlib.f.a;

public class UnicodeEncoding
extends fg {
    static final int a = 1200;
    static final int n = 1201;
    private boolean o;
    private boolean p;

    public UnicodeEncoding() {
        this(false, true);
        this.o = false;
        this.p = true;
    }

    public UnicodeEncoding(boolean bl2, boolean bl3) {
        this(bl2, bl3, false);
    }

    public UnicodeEncoding(boolean bl2, boolean bl3, boolean bl4) {
        super(bl2 ? 1201 : 1200);
        if (bl4) {
            this.setFallbackInternal(null, new DecoderExceptionFallback());
        } else {
            this.setFallbackInternal(null, new DecoderReplacementFallback("\ufffd"));
        }
        this.o = bl2;
        this.p = bl3;
        if (bl2) {
            this.body_name = "unicodeFFFE";
            this.encoding_name = "Unicode (Big-Endian)";
            this.header_name = "unicodeFFFE";
            this.is_browser_save = false;
            this.web_name = "unicodeFFFE";
        } else {
            this.body_name = "utf-16";
            this.encoding_name = "Unicode";
            this.header_name = "utf-16";
            this.is_browser_save = true;
            this.web_name = "utf-16";
        }
        this.windows_code_page = 1200;
    }

    @Override
    public int getByteCount(char[] cArray, int n2, int n3) {
        if (cArray == null) {
            throw new ArgumentNullException("chars");
        }
        if (n2 < 0 || n2 > cArray.length) {
            throw new ArgumentOutOfRangeException("index", UnicodeEncoding._("ArgRange_Array"));
        }
        if (n3 < 0 || n3 > cArray.length - n2) {
            throw new ArgumentOutOfRangeException("count", UnicodeEncoding._("ArgRange_Array"));
        }
        return this.a(n3);
    }

    @Override
    public int getByteCount(String string) {
        if (string == null) {
            throw new ArgumentNullException("s");
        }
        return this.a(string.length());
    }

    private int a(int n2) {
        return n2 * 2;
    }

    @Override
    public int getMaxByteCount(int n2) {
        if (n2 < 0) {
            throw new ArgumentOutOfRangeException("charCount", "Non-negative number required.");
        }
        return (int)((long)n2 + 1L) << 1;
    }

    @Override
    public int getBytes(char[] cArray, int n2, int n3, byte[] byArray, int n4) {
        if (cArray == null) {
            throw new ArgumentNullException("chars");
        }
        if (byArray == null) {
            throw new ArgumentNullException("bytes");
        }
        if (n2 < 0 || n2 > cArray.length) {
            throw new ArgumentOutOfRangeException("charIndex", "ArgRange_Array");
        }
        if (n3 < 0 || n3 > cArray.length - n2) {
            throw new ArgumentOutOfRangeException("charCount", "ArgRange_Array");
        }
        if (n4 < 0 || n4 > byArray.length) {
            throw new ArgumentOutOfRangeException("byteIndex", "ArgRange_Array");
        }
        int n5 = byArray.length - n4;
        if (byArray.length == 0) {
            byArray = new byte[1];
        }
        return this.a(cArray, n2, n3, byArray, n4, n5);
    }

    @Override
    public int getBytes(String string, int n2, int n3, byte[] byArray, int n4) {
        if (string == null) {
            throw new ArgumentNullException("s");
        }
        char[] cArray = StringExtensions.toCharArray(string);
        return this.getBytes(cArray, n2, n3, byArray, n4);
    }

    private int a(char[] cArray, int n2, int n3, byte[] byArray, int n4, int n5) {
        int n6 = this.a(n3);
        if (n5 < n6) {
            throw new ArgumentException(UnicodeEncoding._("Arg_InsufficientSpace"));
        }
        com.aspose.html.utils.ms.core.mscorlib.f.e e2 = new com.aspose.html.utils.ms.core.mscorlib.f.e(this.o, this.getEncoderFallback());
        e2.a(cArray, n2, n3, byArray, n4);
        return n6;
    }

    @Override
    public Encoder getEncoder() {
        return new UnicodeEncoder(this.o, this.getEncoderFallback());
    }

    @Override
    public Decoder getDecoder() {
        return new UnicodeDecoder(this.o, this.getDecoderFallback());
    }

    @Override
    public int getCharCount(byte[] byArray, int n2, int n3) {
        if (byArray == null) {
            throw new ArgumentNullException("bytes");
        }
        if (n2 < 0 || n2 > byArray.length) {
            throw new ArgumentOutOfRangeException("index", UnicodeEncoding._("ArgRange_Array"));
        }
        if (n3 < 0 || n3 > byArray.length - n2) {
            throw new ArgumentOutOfRangeException("count", UnicodeEncoding._("ArgRange_Array"));
        }
        e e2 = new e(this.o, this.getDecoderFallback());
        return e2.a(byArray, n2, n3);
    }

    @Override
    public int getMaxCharCount(int n2) {
        if (n2 < 0) {
            throw new ArgumentOutOfRangeException("byteCount", "Non-negative number required.");
        }
        return (int)((long)((n2 >> 1) + (n2 & 1)) + 1L);
    }

    @Override
    public int getChars(byte[] byArray, int n2, int n3, char[] cArray, int n4) {
        return this.a(byArray, n2, n3, cArray, n4);
    }

    @Override
    public String getString(byte[] byArray, int n2, int n3) {
        if (n3 == 0) {
            return StringExtensions.Empty;
        }
        int n4 = this.getCharCount(byArray, n2, n3);
        char[] cArray = new char[n4];
        this.a(byArray, n2, n3, cArray, 0);
        return StringExtensions.newString(cArray);
    }

    private int a(byte[] byArray, int n2, int n3, char[] cArray, int n4) {
        e e2 = new e(this.o, this.getDecoderFallback());
        return e2.a(byArray, n2, n3, cArray, n4);
    }

    @Override
    public byte[] getPreamble() {
        if (this.p) {
            if (this.o) {
                return new byte[]{-2, -1};
            }
            return new byte[]{-1, -2};
        }
        return new byte[0];
    }

    static final class UnicodeDecoder
    extends com.aspose.html.utils.ms.core.mscorlib.e.a {
        public UnicodeDecoder(boolean bl2, DecoderFallback decoderFallback) {
            super(new e(bl2, decoderFallback));
        }
    }

    static class UnicodeEncoder
    extends a {
        private UnicodeEncoder(boolean bl2, EncoderFallback encoderFallback) {
            super(new com.aspose.html.utils.ms.core.mscorlib.f.e(bl2, encoderFallback));
        }
    }
}

