/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.System.Security.Cryptography.Pkcs;

import com.aspose.html.utils.ms.System.ArgumentNullException;
import com.aspose.html.utils.ms.System.Security.Cryptography.AsnEncodedData;
import com.aspose.html.utils.ms.System.Security.Cryptography.Oid;
import com.aspose.html.utils.ms.System.Security.Cryptography.Pkcs.Pkcs9AttributeObject;
import com.aspose.html.utils.ms.System.StringExtensions;
import com.aspose.html.utils.ms.System.Text.Encoding;
import com.aspose.html.utils.ms.core.System.Security.Cryptography.ASN1;
import com.aspose.html.utils.ms.lang.Operators;

public final class Pkcs9DocumentName
extends Pkcs9AttributeObject {
    public static final String oid = "1.3.6.1.4.1.311.88.2.1";
    public static final String friendlyName = null;
    private String a;

    public Pkcs9DocumentName() {
        Operators.as(this, AsnEncodedData.class).setOid(new Oid(oid, friendlyName));
    }

    public Pkcs9DocumentName(String string) {
        if (string == null) {
            throw new ArgumentNullException("documentName");
        }
        Operators.as(this, AsnEncodedData.class).setOid(new Oid(oid, friendlyName));
        this.a = string;
        this.setRawData(this.encode());
    }

    public Pkcs9DocumentName(byte[] byArray) {
        if (byArray == null) {
            throw new ArgumentNullException("encodedDocumentName");
        }
        Operators.as(this, AsnEncodedData.class).setOid(new Oid(oid, friendlyName));
        this.setRawData(byArray);
        this.decode(byArray);
    }

    public String getDocumentName() {
        return this.a;
    }

    @Override
    public void copyFrom(AsnEncodedData asnEncodedData) {
        super.copyFrom(asnEncodedData);
        this.decode(this.getRawData());
    }

    public void decode(byte[] byArray) {
        int n2;
        if (Operators.castToInt32(byArray[0], 6) != 4) {
            return;
        }
        ASN1 aSN1 = new ASN1(byArray);
        byte[] byArray2 = aSN1.getValue();
        if (Operators.castToInt32(byArray2[(n2 = byArray2.length) - 2], 6) == 0) {
            n2 -= 2;
        }
        this.a = Encoding.getUnicode().getString(byArray2, 0, n2);
    }

    public byte[] encode() {
        ASN1 aSN1 = new ASN1(4, Encoding.getUnicode().getBytes(StringExtensions.concat(this.a, Operators.boxing(Character.valueOf('\u0000')))));
        return aSN1.getBytes();
    }
}

