/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.System.Security.Cryptography;

import com.aspose.html.utils.ms.System.ArgumentNullException;
import com.aspose.html.utils.ms.System.Security.Cryptography.AsymmetricAlgorithm;
import com.aspose.html.utils.ms.System.Security.Cryptography.AsymmetricSignatureDeformatter;
import com.aspose.html.utils.ms.System.Security.Cryptography.CryptographicUnexpectedOperationException;
import com.aspose.html.utils.ms.System.Security.Cryptography.DSA;
import com.aspose.html.utils.ms.System.Security.Cryptography.SHA1;
import com.aspose.html.utils.ms.core.System.Security.Cryptography.n;

public class DSASignatureDeformatter
extends AsymmetricSignatureDeformatter {
    private DSA a;

    public DSASignatureDeformatter() {
    }

    public DSASignatureDeformatter(AsymmetricAlgorithm asymmetricAlgorithm) {
        this.setKey(asymmetricAlgorithm);
    }

    @Override
    public void setHashAlgorithm(String string) {
        if (string == null) {
            throw new ArgumentNullException("strName");
        }
        try {
            SHA1.create(string);
        }
        catch (ClassCastException classCastException) {
            throw new CryptographicUnexpectedOperationException(n.a("DSA requires SHA1"));
        }
    }

    @Override
    public void setKey(AsymmetricAlgorithm asymmetricAlgorithm) {
        if (asymmetricAlgorithm == null) {
            throw new ArgumentNullException("key");
        }
        this.a = (DSA)asymmetricAlgorithm;
    }

    @Override
    public boolean verifySignature(byte[] byArray, byte[] byArray2) {
        if (this.a == null) {
            throw new CryptographicUnexpectedOperationException(n.a("missing key"));
        }
        return this.a.verifySignature(byArray, byArray2);
    }
}

