/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.System.Collections.Specialized;

import com.aspose.html.utils.ms.System.ArgumentException;
import com.aspose.html.utils.ms.System.Convert;
import com.aspose.html.utils.ms.System.Int32Extensions;
import com.aspose.html.utils.ms.System.InvalidOperationException;
import com.aspose.html.utils.ms.System.Text.msStringBuilder;
import com.aspose.html.utils.ms.lang.Operators;
import com.aspose.html.utils.ms.lang.Struct;

public class BitVector32
extends Struct<BitVector32> {
    private int a;

    public BitVector32() {
    }

    public BitVector32(BitVector32 bitVector32) {
        this.a = bitVector32.a;
    }

    public BitVector32(int n2) {
        this.a = n2;
    }

    public int getData() {
        return this.a;
    }

    public int get_Item(Section section) {
        return this.a >> section.getOffset() & section.getMask();
    }

    public void set_Item(Section section, int n2) {
        if (n2 < 0) {
            throw new ArgumentException("Section can't hold negative values");
        }
        if (n2 > section.getMask()) {
            throw new ArgumentException("Value too large to fit in section");
        }
        this.a &= ~(section.getMask() << section.getOffset());
        this.a |= n2 << section.getOffset();
    }

    public boolean get_Item(int n2) {
        return (this.a & n2) == n2;
    }

    public void set_Item(int n2, boolean bl2) {
        this.a = bl2 ? (this.a |= n2) : (this.a &= ~n2);
    }

    public static int createMask() {
        return 1;
    }

    public static int createMask(int n2) {
        if (n2 == 0) {
            return 1;
        }
        if (n2 == Integer.MIN_VALUE) {
            throw new InvalidOperationException("all bits set");
        }
        return n2 << 1;
    }

    public static Section createSection(short s2) {
        return BitVector32.createSection(s2, new Section(0, 0));
    }

    public static Section createSection(short s2, Section section) {
        if (s2 < 1) {
            throw new ArgumentException("maxValue");
        }
        int n2 = BitVector32.a(s2);
        int n3 = (1 << n2) - 1;
        int n4 = section.getOffset() + BitVector32.a(section.getMask());
        if (n4 + n2 > 32) {
            throw new ArgumentException("Sections cannot exceed 32 bits in total");
        }
        return new Section(Operators.castToInt16(n3, 9), Operators.castToInt16(n4, 9));
    }

    public boolean equals(Object object) {
        return Operators.is(object, BitVector32.class) && this.a == Operators.unboxing((Object)object, BitVector32.class).a;
    }

    public int hashCode() {
        return Int32Extensions.getHashCode(this.a);
    }

    public String toString() {
        return BitVector32.toString(this.Clone());
    }

    public static String toString(BitVector32 bitVector32) {
        msStringBuilder msStringBuilder2 = new msStringBuilder();
        msStringBuilder2.append("BitVector32{");
        for (long i2 = Operators.castToInt64(0x80000000L, 10); i2 > 0L; i2 >>= 1) {
            msStringBuilder2.append(((long)bitVector32.a & i2) == 0L ? (char)'0' : '1');
        }
        msStringBuilder2.append('}');
        return msStringBuilder2.toString();
    }

    private static int a(int n2) {
        int n3 = 0;
        while (n2 >> n3 != 0) {
            ++n3;
        }
        return n3;
    }

    @Override
    public void CloneTo(BitVector32 bitVector32) {
        bitVector32.a = this.a;
    }

    @Override
    public BitVector32 Clone() {
        BitVector32 bitVector32 = new BitVector32();
        this.CloneTo(bitVector32);
        return bitVector32;
    }

    public Object clone() {
        return this.Clone();
    }

    public static boolean equals(BitVector32 bitVector32, BitVector32 bitVector322) {
        return bitVector32.equals(bitVector322);
    }

    public static class Section
    extends Struct<Section> {
        private short a;
        private short b;

        public Section() {
        }

        Section(short s2, short s3) {
            this.a = s2;
            this.b = s3;
        }

        public short getMask() {
            return this.a;
        }

        public short getOffset() {
            return this.b;
        }

        public static boolean op_Equality(Section section, Section section2) {
            return section.a == section2.a && section.b == section2.b;
        }

        public static boolean op_Inequality(Section section, Section section2) {
            return section.a != section2.a || section.b != section2.b;
        }

        public boolean equals(Section section) {
            return this.a == section.a && this.b == section.b;
        }

        public boolean equals(Object object) {
            if (!Operators.is(object, Section.class)) {
                return false;
            }
            Section section = Operators.unboxing(object, Section.class).Clone();
            return this.a == section.a && this.b == section.b;
        }

        public int hashCode() {
            return this.a << this.b;
        }

        public String toString() {
            return Section.toString(this.Clone());
        }

        public static String toString(Section section) {
            msStringBuilder msStringBuilder2 = new msStringBuilder();
            msStringBuilder2.append("Section{0x");
            msStringBuilder2.append(Convert.toString(section.getMask(), 16));
            msStringBuilder2.append(", 0x");
            msStringBuilder2.append(Convert.toString(section.getOffset(), 16));
            msStringBuilder2.append("}");
            return msStringBuilder2.toString();
        }

        @Override
        public void CloneTo(Section section) {
            section.a = this.a;
            section.b = this.b;
        }

        @Override
        public Section Clone() {
            Section section = new Section();
            this.CloneTo(section);
            return section;
        }

        public Object clone() {
            return this.Clone();
        }

        public static boolean equals(Section section, Section section2) {
            return section.equals(section2);
        }
    }
}

