/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html;

import com.aspose.html.Configuration;
import com.aspose.html.HTMLElement;
import com.aspose.html.IDisposable;
import com.aspose.html.Url;
import com.aspose.html.collections.HTMLCollection;
import com.aspose.html.dom.Document;
import com.aspose.html.dom.Element;
import com.aspose.html.dom.IDocumentInit;
import com.aspose.html.dom.css.ICSSStyleDeclaration;
import com.aspose.html.dom.css.IDocumentCSS;
import com.aspose.html.dom.css.IViewCSS;
import com.aspose.html.dom.events.Event;
import com.aspose.html.io.IOutputStorage;
import com.aspose.html.net.RequestMessage;
import com.aspose.html.rendering.IDevice;
import com.aspose.html.saving.HTMLSaveOptions;
import com.aspose.html.saving.MHTMLSaveOptions;
import com.aspose.html.saving.MarkdownSaveOptions;
import com.aspose.html.saving.TextSaveOptions;
import com.aspose.html.serialization.manager.resources.handlers.MHTMLHandlerFactory;
import com.aspose.html.serialization.manager.resources.handlers.SingleDocumentHandlerFactory;
import com.aspose.html.utils.Cp;
import com.aspose.html.utils.Cq;
import com.aspose.html.utils.Di;
import com.aspose.html.utils.Er;
import com.aspose.html.utils.IJ;
import com.aspose.html.utils.K;
import com.aspose.html.utils.KeyValuePair;
import com.aspose.html.utils.O;
import com.aspose.html.utils.Stream;
import com.aspose.html.utils.Tk;
import com.aspose.html.utils.UI;
import com.aspose.html.utils.UJ;
import com.aspose.html.utils.UM;
import com.aspose.html.utils.UU;
import com.aspose.html.utils.WL;
import com.aspose.html.utils.ag;
import com.aspose.html.utils.asI;
import com.aspose.html.utils.bN;
import com.aspose.html.utils.collections.generic.List;
import com.aspose.html.utils.fV;
import com.aspose.html.utils.iB;
import com.aspose.html.utils.iR;
import com.aspose.html.utils.kM;
import com.aspose.html.utils.ms.System.Collections.Generic.Dictionary;
import com.aspose.html.utils.ms.System.IO.Directory;
import com.aspose.html.utils.ms.System.IO.Path;
import com.aspose.html.utils.ms.System.StringExtensions;
import com.aspose.html.utils.uy;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;

public class HTMLDocument
extends Document
implements IDocumentCSS {
    private String Hf;
    private IViewCSS Hg;

    public HTMLDocument() {
        this("about:blank");
    }

    public HTMLDocument(InputStream inputStream, String string) {
        this(Stream.fromJava(inputStream), string, new Configuration());
    }

    public HTMLDocument(K k2) {
        super(HTMLDocument.b(k2));
    }

    public HTMLDocument(Configuration configuration) {
        this("about:blank", configuration);
    }

    public HTMLDocument(RequestMessage requestMessage) {
        this(requestMessage, new Configuration());
    }

    public HTMLDocument(RequestMessage requestMessage, Configuration configuration) {
        this(requestMessage, configuration, 1);
    }

    private HTMLDocument(final RequestMessage requestMessage, Configuration configuration, final byte by2) {
        super(HTMLDocument.a(new K(configuration), new Document.c(){
            {
                this.a(uy.dtz);
                this.a(requestMessage);
                this.setFlags(by2);
            }
        }));
    }

    public HTMLDocument(Stream stream, Url url) {
        this(stream, url, new Configuration());
    }

    public HTMLDocument(Stream stream, Url url, Configuration configuration) {
        this(IJ.a(stream, url), configuration, 3);
    }

    public HTMLDocument(Stream stream, String string) {
        this(stream, string, new Configuration());
    }

    public HTMLDocument(Stream stream, String string, Configuration configuration) {
        this(IJ.f(stream, string), configuration, 3);
    }

    public HTMLDocument(Url url) {
        this(url, new Configuration());
    }

    public HTMLDocument(Url url, Configuration configuration) {
        this(IJ.i(url), configuration, 3);
    }

    public HTMLDocument(String string) {
        this(new O(string, StringExtensions.concat(Directory.getCurrentDirectory(), Character.valueOf(Path.DirectorySeparatorChar))));
    }

    public HTMLDocument(String string, Configuration configuration) {
        this(new O(string, StringExtensions.concat(Directory.getCurrentDirectory(), Character.valueOf(Path.DirectorySeparatorChar))), configuration);
    }

    public HTMLDocument(String string, Url url) {
        this(string, url, new Configuration());
    }

    public HTMLDocument(String string, Url url, Configuration configuration) {
        this(IJ.a(string, url), configuration, 3);
    }

    public HTMLDocument(String string, String string2) {
        this(string, string2, new Configuration());
    }

    public HTMLDocument(String string, String string2, Configuration configuration) {
        this(IJ.ae(string, string2), configuration, 3);
    }

    private static IDocumentInit b(K k2) {
        return HTMLDocument.a(k2, null);
    }

    private static IDocumentInit a(K k2, Document.c c2) {
        iR iR2 = k2.aa().i(k2);
        iR2.cu(1);
        iR2.b(new asI<Document, Event>(){

            public void a(Document document, Event event) {
                HTMLDocument hTMLDocument = (HTMLDocument)document;
                if (hTMLDocument.getBody() != null) {
                    hTMLDocument.getBody().dispatchEvent(event);
                } else {
                    hTMLDocument.dispatchEvent(event);
                }
            }

            @Override
            public /* synthetic */ void invoke(Object object, Object object2) {
                this.a((Document)object, (Event)object2);
            }
        });
        iR2.a(c2);
        return iR2;
    }

    public final HTMLCollection getAnchors() {
        return new bN(this, new Cq("A"));
    }

    public final HTMLCollection getApplets() {
        Dictionary dictionary = new Dictionary(2);
        dictionary.addItem("APPLET", null);
        List<KeyValuePair<String, String>> list = new List<KeyValuePair<String, String>>(2);
        list.addItem(new KeyValuePair<String, String>("classid", "clsid:CAFEEFAC-00"));
        list.addItem(new KeyValuePair<String, String>("classid", "clsid:8AD9C840-044E-11D1-B3E9-00805F499D93"));
        dictionary.addItem("OBJECT", list);
        List<KeyValuePair<String, String>> list2 = new List<KeyValuePair<String, String>>(3);
        list2.addItem(new KeyValuePair<String, String>("type", "application/x-java-applet"));
        list2.addItem(new KeyValuePair<String, String>("type", "application/x-java-bean"));
        list2.addItem(new KeyValuePair<String, String>("type", "application/x-java-vm"));
        dictionary.addItem("EMBED", list2);
        return new bN(this, new Cq("APPLET", "OBJECT", "EMBED"));
    }

    public final HTMLElement getBody() {
        bN bN2 = new bN(this, new Cq("BODY", "FRAMESET"));
        return (HTMLElement)Di.c(bN2);
    }

    public final void setBody(HTMLElement hTMLElement) {
        fV.d(hTMLElement, "value");
        HTMLElement hTMLElement2 = this.getBody();
        if (hTMLElement2 != null) {
            this.getDocumentElement().replaceChild(hTMLElement2, hTMLElement);
        } else {
            this.getDocumentElement().appendChild(hTMLElement);
        }
    }

    public final String bI() {
        return this.Hf;
    }

    final void P(String string) {
        this.Hf = string;
    }

    public final String getDomain() {
        return this.getLocation().getHost();
    }

    public final HTMLCollection getForms() {
        return new bN(this, new Cp("FORM"));
    }

    public final HTMLCollection getImages() {
        return this.getElementsByTagName("IMG");
    }

    public final HTMLCollection getLinks() {
        return new bN(this, new Cq("A", "AREA"));
    }

    public final String getReferrer() {
        return StringExtensions.Empty;
    }

    public final String getTitle() {
        Element element = Di.c(this.getElementsByTagName(iB.i.bPl.da()));
        if (element != null) {
            return element.getTextContent();
        }
        return StringExtensions.Empty;
    }

    public final void setTitle(String string) {
        if (this.getDocumentElement() != null && StringExtensions.equals(this.getDocumentElement().getNamespaceURI(), iB.g.bLr)) {
            Element element = Di.c(this.getElementsByTagName(ag.a(iB.i.bPl)));
            if (element != null) {
                element.setTextContent(string);
                return;
            }
            Element element2 = Di.c(this.getElementsByTagName(ag.a(iB.i.bNw)));
            if (element2 == null) {
                return;
            }
            element = this.createElement(iB.i.bPl.da());
            element.setTextContent(string);
            element2.appendChild(element);
        }
    }

    @Override
    public final ICSSStyleDeclaration getOverrideStyle(Element element, String string) {
        K k2 = (K)this.getContext();
        return ((kM)k2.Y()).getOverrideStyle(element, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renderTo(IDevice iDevice) {
        WL wL2 = this.getContext().getService(WL.class);
        IDisposable iDisposable = wL2.agp();
        try {
            wL2.a(iDisposable, iDevice, this);
        }
        finally {
            if (iDisposable != null) {
                iDisposable.dispose();
            }
        }
    }

    public final void save(IOutputStorage iOutputStorage) {
        this.save(iOutputStorage, 0);
    }

    public final void save(IOutputStorage iOutputStorage, int n2) {
        switch (n2) {
            case 0: {
                this.save(iOutputStorage, new HTMLSaveOptions());
                break;
            }
            case 1: {
                this.save(iOutputStorage, MarkdownSaveOptions.getDefault());
                break;
            }
            case 10: {
                this.save(iOutputStorage, TextSaveOptions.getDefault());
                break;
            }
            case 2: {
                this.save(iOutputStorage, new MHTMLSaveOptions());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void save(IOutputStorage iOutputStorage, HTMLSaveOptions hTMLSaveOptions) {
        UJ uJ2 = new UJ((K)this.getContext());
        IDisposable iDisposable = uJ2.a((Url)this.getLocation(), hTMLSaveOptions);
        try {
            UI uI2 = uJ2.aiT();
            uI2.a(iOutputStorage);
            uI2.c(this.getLocation(), ".htm");
            uJ2.y(this);
        }
        finally {
            if (iDisposable != null) {
                iDisposable.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void save(IOutputStorage iOutputStorage, MHTMLSaveOptions mHTMLSaveOptions) {
        UJ uJ2 = new UJ((K)this.getContext());
        IDisposable iDisposable = uJ2.a((Url)this.getLocation(), mHTMLSaveOptions);
        try {
            UI uI2 = uJ2.aiT();
            uI2.cl(false);
            uI2.a(new MHTMLHandlerFactory());
            uI2.a(new UM());
            uI2.a(new Er(iOutputStorage, uI2.getBoundary()));
            uI2.c(this.getLocation(), ".mht");
            uJ2.y(this);
        }
        finally {
            if (iDisposable != null) {
                iDisposable.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void save(IOutputStorage iOutputStorage, MarkdownSaveOptions markdownSaveOptions) {
        UJ uJ2 = new UJ((K)this.getContext());
        IDisposable iDisposable = uJ2.a((Url)this.getLocation(), markdownSaveOptions);
        try {
            UI uI2 = uJ2.aiT();
            uI2.a(new UU(markdownSaveOptions));
            uI2.a(new SingleDocumentHandlerFactory());
            uI2.a(iOutputStorage);
            uI2.c(this.getLocation(), ".md");
            uJ2.h(this.getBody(), this.getLocation().getHref());
        }
        finally {
            if (iDisposable != null) {
                iDisposable.dispose();
            }
        }
    }

    public final void save(Url url) {
        this.save(url, 0);
    }

    public final void save(Url url, int n2) {
        switch (n2) {
            case 0: {
                this.save(url, new HTMLSaveOptions());
                break;
            }
            case 1: {
                this.save(url, MarkdownSaveOptions.getDefault());
                break;
            }
            case 10: {
                this.save(url, new MHTMLSaveOptions());
                break;
            }
            case 2: {
                this.save(url, new MHTMLSaveOptions());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void save(Url url, HTMLSaveOptions hTMLSaveOptions) {
        UJ uJ2 = new UJ((K)this.getContext());
        IDisposable iDisposable = uJ2.a((Url)this.getLocation(), hTMLSaveOptions);
        try {
            UI uI2 = uJ2.aiT();
            uI2.m(url);
            uJ2.y(this);
        }
        finally {
            if (iDisposable != null) {
                iDisposable.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void save(Url url, MHTMLSaveOptions mHTMLSaveOptions) {
        UJ uJ2 = new UJ((K)this.getContext());
        IDisposable iDisposable = uJ2.a((Url)this.getLocation(), mHTMLSaveOptions);
        try {
            UI uI2 = uJ2.aiT();
            uI2.cl(false);
            uI2.a(new MHTMLHandlerFactory());
            uI2.a(new UM());
            uI2.a(new Er(uI2.aiH(), uI2.getBoundary()));
            uI2.k(url);
            uI2.m(url);
            uJ2.y(this);
        }
        finally {
            if (iDisposable != null) {
                iDisposable.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void save(Url url, MarkdownSaveOptions markdownSaveOptions) {
        UJ uJ2 = new UJ((K)this.getContext());
        IDisposable iDisposable = uJ2.a((Url)this.getLocation(), markdownSaveOptions);
        try {
            UI uI2 = uJ2.aiT();
            uI2.a(new UU(markdownSaveOptions));
            uI2.a(new SingleDocumentHandlerFactory());
            uI2.m(url);
            uJ2.h(this.getBody(), this.getLocation().getHref());
        }
        finally {
            if (iDisposable != null) {
                iDisposable.dispose();
            }
        }
    }

    public final void save(String string) {
        this.save(new Url(string, StringExtensions.concat(Directory.getCurrentDirectory(), Character.valueOf(Path.DirectorySeparatorChar))));
    }

    public final void save(String string, int n2) {
        this.save(new Url(string, StringExtensions.concat(Directory.getCurrentDirectory(), Character.valueOf(Path.DirectorySeparatorChar))), n2);
    }

    public final void save(String string, HTMLSaveOptions hTMLSaveOptions) {
        this.save(new Url(string, StringExtensions.concat(Directory.getCurrentDirectory(), Character.valueOf(Path.DirectorySeparatorChar))), hTMLSaveOptions);
    }

    public final void save(String string, MHTMLSaveOptions mHTMLSaveOptions) {
        this.save(new Url(string, StringExtensions.concat(Directory.getCurrentDirectory(), Character.valueOf(Path.DirectorySeparatorChar))), mHTMLSaveOptions);
    }

    public final void save(String string, MarkdownSaveOptions markdownSaveOptions) {
        this.save(new Url(string, StringExtensions.concat(Directory.getCurrentDirectory(), Character.valueOf(Path.DirectorySeparatorChar))), markdownSaveOptions);
    }

    public final void save(String string, TextSaveOptions textSaveOptions) {
        this.save(new Url(string, StringExtensions.concat(Directory.getCurrentDirectory(), Character.valueOf(Path.DirectorySeparatorChar))), textSaveOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(Url url, TextSaveOptions textSaveOptions) {
        UJ uJ2 = new UJ((K)this.getContext());
        IDisposable iDisposable = uJ2.a((Url)this.getLocation(), textSaveOptions);
        try {
            UI uI2 = uJ2.aiT();
            uI2.a(new SingleDocumentHandlerFactory());
            uI2.m(url);
            String string = Tk.f(this);
            try (BufferedWriter bufferedWriter = Files.newBufferedWriter(Paths.get(uI2.aiG(), new String[0]), new OpenOption[0]);){
                string = string.replace("\u00a0", " ");
                bufferedWriter.append(string);
                bufferedWriter.newLine();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        finally {
            if (iDisposable != null) {
                iDisposable.dispose();
            }
        }
    }

    public void save(IOutputStorage iOutputStorage, TextSaveOptions textSaveOptions) {
        this.a(iOutputStorage, textSaveOptions);
    }

    private void a(Url url, TextSaveOptions textSaveOptions) {
        String string = Tk.f(this);
        Tk.save(url.toString(), string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(IOutputStorage iOutputStorage, TextSaveOptions textSaveOptions) {
        UJ uJ2 = new UJ((K)this.getContext());
        IDisposable iDisposable = uJ2.a((Url)this.getLocation(), textSaveOptions);
        try {
            UI uI2 = uJ2.aiT();
            uI2.a(new SingleDocumentHandlerFactory());
            uI2.a(iOutputStorage);
            uI2.c(this.getLocation(), ".txt");
            String string = Tk.f(this);
            try (BufferedWriter bufferedWriter = Files.newBufferedWriter(Paths.get(URI.create(iOutputStorage.toString())), new OpenOption[0]);){
                string = string.replace("\u00a0", " ");
                bufferedWriter.append(string);
                bufferedWriter.newLine();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        finally {
            if (iDisposable != null) {
                iDisposable.dispose();
            }
        }
    }
}

