/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.rendering.image;

import com.aspose.html.dom.Document;
import com.aspose.html.dom.Element;
import com.aspose.html.drawing.IBrush;
import com.aspose.html.internal.ms.System.Char;
import com.aspose.html.internal.ms.System.Collections.Generic.IGenericList;
import com.aspose.html.internal.ms.System.Collections.Generic.Stack;
import com.aspose.html.internal.ms.System.Drawing.Bitmap;
import com.aspose.html.internal.ms.System.Drawing.Brush;
import com.aspose.html.internal.ms.System.Drawing.Drawing2D.GraphicsState;
import com.aspose.html.internal.ms.System.Drawing.Drawing2D.Matrix;
import com.aspose.html.internal.ms.System.Drawing.Font;
import com.aspose.html.internal.ms.System.Drawing.Graphics;
import com.aspose.html.internal.ms.System.Drawing.Image;
import com.aspose.html.internal.ms.System.Drawing.Imaging.ImageAttributes;
import com.aspose.html.internal.ms.System.Drawing.Pen;
import com.aspose.html.internal.ms.System.Drawing.PointF;
import com.aspose.html.internal.ms.System.Drawing.RectangleF;
import com.aspose.html.internal.ms.System.Drawing.Region;
import com.aspose.html.internal.ms.System.Drawing.SizeF;
import com.aspose.html.internal.ms.System.Drawing.StringFormat;
import com.aspose.html.internal.ms.System.EnumExtensions;
import com.aspose.html.internal.ms.System.IO.MemoryStream;
import com.aspose.html.internal.ms.System.IO.Stream;
import com.aspose.html.internal.ms.System.NotSupportedException;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.lang.Ref;
import com.aspose.html.internal.p15.z5;
import com.aspose.html.internal.p157.z3;
import com.aspose.html.internal.p17.z10;
import com.aspose.html.internal.p17.z9;
import com.aspose.html.internal.p283.z16;
import com.aspose.html.io.ICreateStreamProvider;
import com.aspose.html.rendering.CharacterInfo;
import com.aspose.html.rendering.Device;
import com.aspose.html.rendering.DeviceConfiguration;
import com.aspose.html.rendering.GraphicContext;
import com.aspose.html.rendering.image.ImageFormat;
import com.aspose.html.rendering.image.ImageRenderingOptions;
import com.aspose.html.rendering.z11;
import com.aspose.html.rendering.z4;
import com.aspose.html.rendering.z6;
import com.aspose.html.rendering.z7;
import com.aspose.html.rendering.z8;

public class ImageDevice
extends Device<z2, ImageRenderingOptions> {
    private z16<IBrush, Brush> convertBrush;
    private z5 drawingFactory;
    private com.aspose.html.internal.p17.z8 fontFactory;
    private final z11 pathBuilder = new z11();
    private z9 privateFontCache;
    private final Stack<GraphicsState> states = new Stack();
    private StringFormat stringFormat;
    private com.aspose.html.internal.p157.z1 auto_RenderingStrategy;

    @Override
    protected z2 createContext() {
        return new z2();
    }

    @Override
    protected DeviceConfiguration getConfiguration() {
        return this.getRenderingStrategy().getConfiguration();
    }

    public Graphics getGraphics() {
        return this.getRenderingStrategy().getGraphics();
    }

    public final Stream getInternalOutputStream() {
        return this.getOutputStream();
    }

    public final com.aspose.html.internal.p157.z1 getRenderingStrategy() {
        return this.auto_RenderingStrategy;
    }

    private void setRenderingStrategy(com.aspose.html.internal.p157.z1 z1100) {
        this.auto_RenderingStrategy = z1100;
    }

    public ImageDevice(ICreateStreamProvider iCreateStreamProvider) {
        this(new ImageRenderingOptions(), iCreateStreamProvider);
    }

    public ImageDevice(ImageRenderingOptions imageRenderingOptions, ICreateStreamProvider iCreateStreamProvider) {
        super(imageRenderingOptions, iCreateStreamProvider);
        this.initializeDevice();
    }

    public ImageDevice(ImageRenderingOptions imageRenderingOptions, Stream stream) {
        super(imageRenderingOptions, stream);
        this.initializeDevice();
    }

    public ImageDevice(ImageRenderingOptions imageRenderingOptions, String string) {
        super(imageRenderingOptions, string);
        this.initializeDevice();
    }

    public ImageDevice(Stream stream) {
        this(new ImageRenderingOptions(), stream);
    }

    public ImageDevice(String string) {
        this(new ImageRenderingOptions(), string);
    }

    @Override
    public void addRect(RectangleF rectangleF) {
        this.pathBuilder.addRect(rectangleF.Clone());
    }

    @Override
    public void beginDocument(Document document) {
        if (!Device.z1.m2(this)) {
            this.drawingFactory = document.getContext().getService(z5.class);
            this.fontFactory = document.getContext().getService(com.aspose.html.internal.p17.z8.class);
        }
        super.beginDocument(document);
        this.pathBuilder.clear();
        this.privateFontCache = this.fontFactory.m227();
    }

    @Override
    public boolean beginElement(Element element, RectangleF rectangleF) {
        return true;
    }

    @Override
    public void beginPage(SizeF sizeF) {
        super.beginPage(sizeF.Clone());
        this.getRenderingStrategy().beginPage(sizeF.Clone());
        z4.m1(this.drawingFactory, this, sizeF.Clone());
    }

    @Override
    public void clip(int n2) {
        this.pathBuilder.m1422().setFillMode(n2);
        this.getGraphics().setClip(new Region(this.pathBuilder.m1422()), 1);
        this.pathBuilder.clear();
    }

    @Override
    public void closePath() {
        this.pathBuilder.closePath();
    }

    private Pen createPen() {
        Pen pen = new Pen(this.convertBrush.invoke(((z2)this.getGraphicContext()).getStrokeBrush()));
        pen.setWidth(((z2)this.getGraphicContext()).getLineWidth());
        pen.setStartCap(((z2)this.getGraphicContext()).getLineCap());
        pen.setEndCap(((z2)this.getGraphicContext()).getLineCap());
        pen.setLineJoin(((z2)this.getGraphicContext()).getLineJoin());
        pen.setMiterLimit(((z2)this.getGraphicContext()).getMiterLimit());
        pen.setDashOffset(((z2)this.getGraphicContext()).getLineDashOffset() / pen.getWidth());
        pen.setDashStyle(((z2)this.getGraphicContext()).getLineDashStyle());
        pen.setDashCap(GraphicContext.z1.m1(this.getGraphicContext()));
        if (pen.getDashStyle() == 5) {
            int n2 = ((z2)this.getGraphicContext()).getLineDashPattern().length;
            float[] fArray = new float[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                fArray[i2] = ((z2)this.getGraphicContext()).getLineDashPattern()[i2] / ((z2)this.getGraphicContext()).getLineWidth();
            }
            pen.setDashPattern(fArray);
        }
        return pen;
    }

    private com.aspose.html.internal.p157.z1 createRenderingStrategy() {
        switch (((ImageRenderingOptions)this.getOptions()).getFormat()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return new com.aspose.html.internal.p157.z2(this);
            }
            case 5: {
                return new z3(this);
            }
        }
        throw new NotSupportedException();
    }

    @Override
    public void cubicBezierTo(PointF pointF, PointF pointF2, PointF pointF3) {
        this.pathBuilder.cubicBezierTo(pointF.Clone(), pointF2.Clone(), pointF3.Clone());
    }

    @Override
    protected void dispose(boolean bl2) {
        if (this.getRenderingStrategy() != null && bl2) {
            this.getRenderingStrategy().dispose();
            this.setRenderingStrategy(null);
        }
        super.dispose(bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drawImage(byte[] byArray, int n2, RectangleF rectangleF) {
        Image image = Image.fromStream(new MemoryStream(byArray));
        try {
            Integer n3 = 2;
            Integer[] integerArray = new Integer[]{n3};
            RectangleF rectangleF2 = image.getBounds(new Ref<Integer>(n3)).Clone();
            n3 = integerArray[0];
            PointF[] pointFArray = new PointF[]{rectangleF.getLocation(), new PointF(rectangleF.getX() + rectangleF.getWidth(), rectangleF.getY()), new PointF(rectangleF.getX(), rectangleF.getY() + rectangleF.getHeight())};
            ImageAttributes imageAttributes = null;
            this.getGraphics().drawImage(image, pointFArray, rectangleF2.Clone(), (int)n3, imageAttributes);
        }
        finally {
            if (image != null) {
                image.dispose();
            }
        }
    }

    @Override
    public void endDocument() {
        if (Device.z1.m2(this)) {
            this.privateFontCache.dispose();
            this.privateFontCache = null;
        }
        super.endDocument();
    }

    @Override
    public void endElement(Element element) {
    }

    @Override
    public void endPage() {
        this.getRenderingStrategy().endPage();
        super.endPage();
    }

    @Override
    public void fill(int n2) {
        this.fillPath(n2);
        this.pathBuilder.clear();
    }

    private void fillPath(int n2) {
        Brush brush = this.convertBrush.invoke(((z2)this.getGraphicContext()).getFillBrush());
        try {
            this.pathBuilder.m1422().setFillMode(n2);
            this.getGraphics().fillPath(brush, this.pathBuilder.m1422());
        }
        finally {
            if (brush != null) {
                brush.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fillText(String string, PointF pointF) {
        if (((z2)this.getGraphicContext()).getFontSize() < 0.1f) {
            return;
        }
        pointF.setY(pointF.getY() - ((z2)this.getGraphicContext()).getFont().getAscent(((z2)this.getGraphicContext()).getFontSize()));
        Brush brush = this.convertBrush.invoke(((z2)this.getGraphicContext()).getFillBrush());
        try {
            Font font = this.fontFactory.m1(Font.class, (z10)((com.aspose.html.internal.p11.z1)((Object)((z2)this.getGraphicContext()).getFont())).m140(), ((z2)this.getGraphicContext()).getFontSize(), ((z2)this.getGraphicContext()).getFontStyle(), this.privateFontCache);
            try {
                IGenericList<CharacterInfo> iGenericList = ((z2)this.getGraphicContext()).getTextInfo().getCharacterInfos();
                for (int i2 = 0; i2 < iGenericList.size(); ++i2) {
                    this.getGraphics().drawString(Char.toString(string.charAt(i2)), font, brush, pointF.Clone(), this.stringFormat);
                    pointF.setX(pointF.getX() + (iGenericList.get_Item(i2).getWidth() + iGenericList.get_Item(i2).getOffset()));
                }
            }
            finally {
                if (font != null) {
                    font.dispose();
                }
            }
        }
        finally {
            if (brush != null) {
                brush.dispose();
            }
        }
    }

    @Override
    public void flush() {
        this.getRenderingStrategy().flush();
        this.states.clear();
        super.flush();
    }

    @Override
    protected String getExtension() {
        return StringExtensions.concat(".", StringExtensions.toLowerInvariant(EnumExtensions.toString(ImageFormat.class, ((ImageRenderingOptions)this.getOptions()).getFormat())));
    }

    @Override
    protected void initialize() {
        super.initialize();
        ((z2)this.getGraphicContext()).m3(this);
    }

    private void initializeDevice() {
        this.convertBrush = new z16<IBrush, Brush>(){

            public Brush m2(IBrush iBrush) {
                return ImageDevice.this.toNativeBrush(iBrush);
            }

            @Override
            public /* synthetic */ Object invoke(Object object) {
                return this.m2((IBrush)object);
            }
        };
        this.stringFormat = new StringFormat(StringFormat.getGenericTypographic());
        this.stringFormat.setFormatFlags(this.stringFormat.getFormatFlags() | 0x800);
        this.setRenderingStrategy(this.createRenderingStrategy());
    }

    @Override
    public void lineTo(PointF pointF) {
        this.pathBuilder.lineTo(pointF.Clone());
    }

    @Override
    public void moveTo(PointF pointF) {
        this.pathBuilder.moveTo(pointF.Clone());
    }

    @Override
    public void restoreGraphicContext() {
        this.getGraphics().restore(this.states.pop());
        super.restoreGraphicContext();
    }

    @Override
    public void saveGraphicContext() {
        this.states.push(this.getGraphics().save());
        super.saveGraphicContext();
    }

    @Override
    public void stroke() {
        this.strokePath();
        this.pathBuilder.clear();
    }

    @Override
    public void strokeAndFill(int n2) {
        this.fillPath(n2);
        this.strokePath();
        this.pathBuilder.clear();
    }

    private void strokePath() {
        Pen pen = this.createPen();
        try {
            this.getGraphics().drawPath(pen, this.pathBuilder.m1422());
        }
        finally {
            if (pen != null) {
                pen.dispose();
            }
        }
    }

    @Override
    public void strokeText(String string, PointF pointF) {
    }

    private Brush toNativeBrush(IBrush iBrush) {
        switch (iBrush.getType()) {
            case 1: {
                return this.drawingFactory.m1(Brush.class, (com.aspose.html.internal.p16.z1)((z8)iBrush).m140());
            }
            case 2: {
                return this.drawingFactory.m1(Brush.class, (com.aspose.html.internal.p16.z1)((z6)iBrush).m140());
            }
            case 0: {
                return this.drawingFactory.m1(Brush.class, (com.aspose.html.internal.p16.z1)((z7)iBrush).m140());
            }
        }
        return null;
    }

    public static class z2
    extends GraphicContext {
        private Matrix m2598;
        private ImageDevice m7544;

        public final ImageDevice m1505() {
            return this.m7544;
        }

        public final void m3(ImageDevice imageDevice) {
            this.m7544 = imageDevice;
        }

        @Override
        public Matrix getTransformationMatrix() {
            return this.m2598;
        }

        @Override
        public void setTransformationMatrix(Matrix matrix) {
            this.m2598 = matrix;
            if (this.m1505().getGraphics() != null) {
                this.m1505().getGraphics().setTransform(matrix);
            }
        }

        @Override
        public GraphicContext deepClone() {
            z2 z2100 = (z2)super.deepClone();
            if (this.m2598 != null) {
                z2100.m2598 = this.m2598.deepClone();
            }
            return z2100;
        }

        @Override
        public void transform(Matrix matrix) {
            if (this.getTransformationMatrix() != null) {
                this.getTransformationMatrix().multiply(matrix);
                if (this.m1505().getGraphics() != null) {
                    this.m1505().getGraphics().setTransform(this.m2598);
                }
            } else {
                this.setTransformationMatrix(matrix.deepClone());
            }
        }
    }

    public static class z1 {
        public static z16<IBrush, Brush> m1(ImageDevice imageDevice) {
            return imageDevice.convertBrush;
        }

        public static Bitmap m2(ImageDevice imageDevice) {
            return imageDevice.getRenderingStrategy().m1503();
        }

        public static void m1(ImageDevice imageDevice, z16<IBrush, Brush> z1610) {
            imageDevice.convertBrush = z1610;
        }
    }
}

