/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.rendering;

import com.aspose.html.Configuration;
import com.aspose.html.HTMLDocument;
import com.aspose.html.HTMLTemplateElement;
import com.aspose.html.dom.Document;
import com.aspose.html.dom.Element;
import com.aspose.html.dom.EventTarget;
import com.aspose.html.dom.svg.SVGDocument;
import com.aspose.html.dom.z1;
import com.aspose.html.internal.ms.System.Collections.Generic.IGenericEnumerator;
import com.aspose.html.internal.ms.System.Collections.Generic.IGenericList;
import com.aspose.html.internal.ms.System.Collections.Generic.List;
import com.aspose.html.internal.ms.System.Globalization.CultureInfo;
import com.aspose.html.internal.ms.System.IDisposable;
import com.aspose.html.internal.ms.System.IO.Stream;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.lang.Operators;
import com.aspose.html.internal.ms.lang.StringSwitchMap;
import com.aspose.html.internal.p119.z5;
import com.aspose.html.internal.p120.z3;
import com.aspose.html.internal.p145.z2;
import com.aspose.html.internal.p145.z6;
import com.aspose.html.internal.p176.z3;
import com.aspose.html.internal.p18.z4;
import com.aspose.html.internal.p283.z37;
import com.aspose.html.net.MessageHandler;
import com.aspose.html.net.RequestMessage;
import com.aspose.html.net.ResponseMessage;
import com.aspose.html.rendering.IDevice;
import com.aspose.html.rendering.Renderer;
import com.aspose.html.rendering.RendererBase;
import com.aspose.html.rendering.z10;
import com.aspose.html.services.INetworkService;
import com.aspose.html.z1;
import com.aspose.time.TimeSpan;
import java.io.InputStream;

public class EpubRenderer
extends Renderer<Stream> {
    private static final StringSwitchMap gStringSwitchMap = new StringSwitchMap("application/xhtml+xml", "image/svg+xml");

    @Override
    public void render(IDevice iDevice, InputStream inputStream) {
        this.render(iDevice, new com.aspose.html.internal.p213.z1(inputStream));
    }

    public EpubRenderer() {
        super(null);
    }

    public EpubRenderer(Class<Stream> clazz) {
        super(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDocumentSources(z1 z1100, com.aspose.html.internal.p119.z4 z4100, List<z2> list, MessageHandler messageHandler, TimeSpan timeSpan) {
        List<z2> list2 = new List<z2>();
        IGenericEnumerator iGenericEnumerator = z4100.m1199().iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                z5.z1[] z1Array;
                z5 z5100 = (z5)iGenericEnumerator.next();
                block8: for (z5.z1 z1101 : z1Array = z5100.m1201()) {
                    String string = StringExtensions.toLower(z1101.getMediaType(), CultureInfo.getInvariantCulture());
                    switch (gStringSwitchMap.of(string)) {
                        case 0: {
                            list2.addItem(this.convertXHTML(z1101, z1100, timeSpan.Clone()));
                            continue block8;
                        }
                        case 1: {
                            list2.addItem(this.convertSVG(z1101, z1100));
                        }
                    }
                }
            }
        }
        finally {
            if (Operators.is(iGenericEnumerator, IDisposable.class)) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
        if (list2.size() != 0) {
            list2.set_Item(0, new com.aspose.html.internal.p145.z1((z2)list2.get_Item(0), messageHandler));
            list2.set_Item(list2.size() - 1, new com.aspose.html.internal.p145.z5((z2)list2.get_Item(list2.size() - 1), messageHandler));
        }
        list.addRange(list2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private z2 convertSVG(z5.z1 z1100, z1 z1101) {
        ResponseMessage responseMessage = z1101.getNetwork().send(new RequestMessage(z1100.m1204()));
        SVGDocument sVGDocument = (SVGDocument)z1101.m17().m1(responseMessage);
        IDisposable iDisposable = z3.z3.m1(this, new z37<Object, z1>(sVGDocument, z1101));
        try {
            z6 z610 = new z6((RendererBase)this, sVGDocument);
            return z610;
        }
        finally {
            if (iDisposable != null) {
                iDisposable.dispose();
            }
        }
    }

    private z2 convertXHTML(z5.z1 z1100, z1 z1101, TimeSpan timeSpan) {
        ResponseMessage responseMessage = z1101.getNetwork().send(new RequestMessage(z1100.m1204()));
        HTMLDocument hTMLDocument = (HTMLDocument)z1101.m17().m1(responseMessage);
        return new com.aspose.html.internal.p145.z4(this, hTMLDocument, timeSpan.Clone());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private z5.z1 getNavElement(com.aspose.html.internal.p119.z4 z4100) {
        IGenericEnumerator iGenericEnumerator = z4100.m1199().iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                z5 z5100 = (z5)iGenericEnumerator.next();
                z5.z1 z1100 = z5100.m1202();
                if (z1100 == null) continue;
                z5.z1 z1101 = z1100;
                return z1101;
            }
        }
        finally {
            if (Operators.is(iGenericEnumerator, IDisposable.class)) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void render(IDevice iDevice, Configuration configuration, TimeSpan timeSpan, Stream ... streamArray) {
        IDisposable iDisposable2;
        IDisposable iDisposable;
        if (streamArray.length == 0) {
            return;
        }
        z3.m4(iDevice.getOptions().getPageSetup());
        List<z2> list = new List<z2>();
        Document[] documentArray = new Document[streamArray.length];
        try {
            for (int i2 = 0; i2 < streamArray.length; ++i2) {
                documentArray[i2] = new HTMLDocument(StringExtensions.Empty, StringExtensions.Empty, configuration);
                iDisposable = (z1)documentArray[i2].getContext();
                Stream stream = streamArray[i2];
                com.aspose.html.internal.p119.z4 z4100 = new com.aspose.html.internal.p119.z4(((z1)iDisposable).getService(z4.class));
                z10 object = new z10(z4100);
                ((z1)iDisposable).getService(INetworkService.class).getMessageHandlers().addItem(object);
                z4100.m1(stream, (z1)iDisposable);
                this.addDocumentSources((z1)iDisposable, z4100, list, object, timeSpan.Clone());
                z5.z1 z1100 = this.getNavElement(z4100);
                if (z1100 != null) {
                    ResponseMessage responseMessage = ((z1)iDisposable).getNetwork().send(new RequestMessage(z1100.m1204()));
                    try {
                        Document document = ((z1)iDisposable).m17().m1(responseMessage);
                        try {
                            if (document.getDocumentElement() != null) {
                                Document document2 = list.get_Item(list.size() - 1).getDocument();
                                Element element = document2.querySelector("head");
                                if (element == null) {
                                    element = document2.createElementNS(z1.z4.m2073, "head");
                                    document2.getDocumentElement().appendChild(element);
                                }
                                HTMLTemplateElement hTMLTemplateElement = (HTMLTemplateElement)document2.createElementNS(z1.z4.m2073, "template");
                                hTMLTemplateElement.getContent().appendChild(document.getDocumentElement());
                                hTMLTemplateElement.setAttribute("BaseUrl", document.getBaseURI());
                                element.appendChild(hTMLTemplateElement);
                            }
                        }
                        finally {
                            if (document != null) {
                                document.dispose();
                            }
                        }
                    }
                    finally {
                        if (responseMessage != null) {
                            responseMessage.dispose();
                        }
                    }
                }
                ((z1)iDisposable).getService(INetworkService.class).getMessageHandlers().removeItem(object);
            }
            iDisposable2 = configuration.getService(com.aspose.html.services.z1.class);
            iDisposable2.m1(this, list.toArray(new z2[0]), iDevice, timeSpan.Clone());
            iDevice.flush();
            iDisposable2 = list.iterator();
        }
        catch (Throwable throwable) {
            Document[] documentArray2;
            iDevice.flush();
            IGenericEnumerator iGenericEnumerator = list.iterator();
            try {
                while (iGenericEnumerator.hasNext()) {
                    documentArray2 = (Document[])iGenericEnumerator.next();
                    documentArray2.dispose();
                }
            }
            finally {
                if (Operators.is(iGenericEnumerator, IDisposable.class)) {
                    ((IDisposable)iGenericEnumerator).dispose();
                }
            }
            documentArray2 = documentArray;
            int n2 = documentArray2.length;
            int n3 = 0;
            while (true) {
                if (n3 >= n2) {
                    throw throwable;
                }
                Document document = documentArray2[n3];
                if (document != null) {
                    document.dispose();
                }
                ++n3;
            }
        }
        try {
            while (iDisposable2.hasNext()) {
                iDisposable = (z2)iDisposable2.next();
                ((z2)iDisposable).dispose();
            }
        }
        finally {
            if (Operators.is(iDisposable2, IDisposable.class)) {
                iDisposable2.dispose();
            }
        }
        iDisposable = documentArray;
        int n4 = ((IDisposable)iDisposable).length;
        int n5 = 0;
        while (n5 < n4) {
            IDisposable iDisposable3 = iDisposable[n5];
            if (iDisposable3 != null) {
                ((EventTarget)iDisposable3).dispose();
            }
            ++n5;
        }
        return;
    }

    public final void render(IDevice iDevice, IGenericList<Stream> iGenericList, Configuration configuration) {
        this.render(iDevice, iGenericList, configuration, TimeSpan.Zero.Clone());
    }

    public final void render(IDevice iDevice, IGenericList<Stream> iGenericList, Configuration configuration, TimeSpan timeSpan) {
        Stream[] streamArray = new Stream[iGenericList.size()];
        iGenericList.copyToTArray((Stream[])streamArray, 0);
        this.render(iDevice, configuration, timeSpan.Clone(), streamArray);
    }

    public final void render(IDevice iDevice, Stream stream, Configuration configuration) {
        this.render(iDevice, stream, configuration, TimeSpan.Zero.Clone());
    }

    public final void render(IDevice iDevice, Stream stream, Configuration configuration, TimeSpan timeSpan) {
        this.render(iDevice, configuration, timeSpan.Clone(), stream);
    }

    public void render(IDevice iDevice, TimeSpan timeSpan, Stream ... streamArray) {
        this.render(iDevice, new Configuration(), timeSpan.Clone(), streamArray);
    }
}

