/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.rendering;

import com.aspose.html.Url;
import com.aspose.html.dom.Document;
import com.aspose.html.dom.Element;
import com.aspose.html.internal.ms.System.Collections.Generic.List;
import com.aspose.html.internal.ms.System.Collections.Generic.Stack;
import com.aspose.html.internal.ms.System.Drawing.PointF;
import com.aspose.html.internal.ms.System.Drawing.RectangleF;
import com.aspose.html.internal.ms.System.Drawing.SizeF;
import com.aspose.html.internal.ms.System.GC;
import com.aspose.html.internal.ms.System.IDisposable;
import com.aspose.html.internal.ms.System.IO.Path;
import com.aspose.html.internal.ms.System.IO.Stream;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.lang.Operators;
import com.aspose.html.internal.p159.z8;
import com.aspose.html.internal.p159.z9;
import com.aspose.html.io.ICreateStreamProvider;
import com.aspose.html.rendering.DeviceConfiguration;
import com.aspose.html.rendering.GraphicContext;
import com.aspose.html.rendering.IDevice;
import com.aspose.html.rendering.RenderingOptions;

public abstract class Device<TGraphicContext extends GraphicContext, TRenderingOptions extends RenderingOptions>
implements IDevice {
    private Stack<TGraphicContext> _contextStack;
    private Stream _outputStream;
    private final List<Document> documents = new List();
    private boolean isRenderingStarted;
    private Document auto_CurrentDocument;
    private TRenderingOptions auto_Options;
    private int auto_PageIndex;
    private ICreateStreamProvider auto_StreamProvider;

    protected DeviceConfiguration getConfiguration() {
        DeviceConfiguration deviceConfiguration = new DeviceConfiguration();
        deviceConfiguration.setPageWritingStrategy(0);
        return deviceConfiguration;
    }

    public final Document getCurrentDocument() {
        return this.auto_CurrentDocument;
    }

    public final void setCurrentDocument(Document document) {
        this.auto_CurrentDocument = document;
    }

    public final TGraphicContext getGraphicContext() {
        return (TGraphicContext)((GraphicContext)this._contextStack.peek());
    }

    public final TRenderingOptions getOptions() {
        return this.auto_Options;
    }

    private void setOptions(TRenderingOptions TRenderingOptions) {
        this.auto_Options = TRenderingOptions;
    }

    public final Stream getOriginalOutputStream() {
        z8 z810 = Operators.as(this._outputStream, z8.class);
        if (z810 != null) {
            return z810.m1513();
        }
        return this._outputStream;
    }

    protected final Stream getOutputStream() {
        return this._outputStream;
    }

    private void setOutputStream(Stream stream) {
        this._outputStream = stream == null ? null : new z8(stream);
    }

    public final int getPageIndex() {
        return this.auto_PageIndex;
    }

    public final void setPageIndex(int n2) {
        this.auto_PageIndex = n2;
    }

    protected final ICreateStreamProvider getStreamProvider() {
        return this.auto_StreamProvider;
    }

    private void setStreamProvider(ICreateStreamProvider iCreateStreamProvider) {
        this.auto_StreamProvider = iCreateStreamProvider;
    }

    protected Device(TRenderingOptions TRenderingOptions, ICreateStreamProvider iCreateStreamProvider) {
        this._contextStack = new Stack();
        this.setOptions(RenderingOptions.z1.m1(TRenderingOptions));
        this.setStreamProvider(iCreateStreamProvider);
    }

    protected Device(TRenderingOptions TRenderingOptions, Stream stream) {
        this(TRenderingOptions, new z2(stream));
    }

    protected Device(TRenderingOptions TRenderingOptions, String string) {
        this(TRenderingOptions, new com.aspose.html.internal.p205.z2(string));
    }

    protected abstract TGraphicContext createContext();

    @Override
    public abstract void addRect(RectangleF var1);

    @Override
    public void beginDocument(Document document) {
        this.initialize();
        this.setCurrentDocument(document);
        this.documents.addItem(this.getCurrentDocument());
        if (this.getConfiguration().getPageWritingStrategy() == 0 && !this.isRenderingStarted) {
            this.setOutputStream(this.getStreamProvider().getStream(this.createOutputFileName(), this.getExtension()));
        }
        if (!this.isRenderingStarted) {
            this.setPageIndex(0);
            this.isRenderingStarted = true;
        }
    }

    @Override
    public abstract boolean beginElement(Element var1, RectangleF var2);

    @Override
    public void beginPage(SizeF sizeF) {
        this.setPageIndex(this.getPageIndex() + 1);
        if (this.getConfiguration().getPageWritingStrategy() == 1) {
            this.setOutputStream(this.getStreamProvider().getStream(this.createOutputFileName(), this.getExtension(), this.getPageIndex()));
        }
    }

    @Override
    public abstract void clip(int var1);

    @Override
    public abstract void closePath();

    private String createOutputFileName() {
        if ("about:".equals(this.getCurrentDocument().getLocation().getProtocol())) {
            return "document";
        }
        String string = Path.getFileNameWithoutExtension(Url.z1.m1(this.getCurrentDocument().getLocation()));
        return StringExtensions.isNullOrEmpty(string) ? "document" : string;
    }

    @Override
    public abstract void cubicBezierTo(PointF var1, PointF var2, PointF var3);

    @Override
    public final void dispose() {
        this.dispose(true);
        GC.suppressFinalize(this);
    }

    protected void dispose(boolean bl2) {
    }

    @Override
    public abstract void drawImage(byte[] var1, int var2, RectangleF var3);

    @Override
    public void endDocument() {
        this.setCurrentDocument(null);
    }

    @Override
    public abstract void endElement(Element var1);

    @Override
    public void endPage() {
        if (this.getConfiguration().getPageWritingStrategy() == 1) {
            IDisposable iDisposable = z9.z2.m3(this.getCurrentDocument(), (Stream)Operators.as(this.getOutputStream(), z8.class), (IDevice)this);
            if (iDisposable != null) {
                iDisposable.dispose();
            }
            this.getStreamProvider().releaseStream(this.getOriginalOutputStream());
            this.setOutputStream(null);
        }
    }

    @Override
    public abstract void fill(int var1);

    @Override
    public abstract void fillText(String var1, PointF var2);

    @Override
    public void flush() {
        this.isRenderingStarted = false;
        if (this.getConfiguration().getPageWritingStrategy() == 0) {
            IDisposable iDisposable = z9.z2.m3(this.documents, (Stream)Operators.as(this.getOutputStream(), z8.class), (IDevice)this);
            if (iDisposable != null) {
                iDisposable.dispose();
            }
            this.getStreamProvider().releaseStream(this.getOriginalOutputStream());
            this.setOutputStream(null);
        } else if (this.getOutputStream() != null && this.getConfiguration().getPageWritingStrategy() == 1) {
            IDisposable iDisposable = z9.z2.m3(this.documents.get_Item(this.documents.size() - 1), (Stream)Operators.as(this.getOutputStream(), z8.class), (IDevice)this);
            if (iDisposable != null) {
                iDisposable.dispose();
            }
            this.getStreamProvider().releaseStream(this.getOriginalOutputStream());
            this.setOutputStream(null);
        }
        this.documents.clear();
    }

    protected abstract String getExtension();

    protected void initialize() {
        this._contextStack.clear();
        this._contextStack.push(this.createContext());
    }

    @Override
    public abstract void lineTo(PointF var1);

    @Override
    public abstract void moveTo(PointF var1);

    @Override
    public void restoreGraphicContext() {
        if (this._contextStack.size() > 1) {
            this._contextStack.pop();
        }
    }

    @Override
    public void saveGraphicContext() {
        this._contextStack.push(((GraphicContext)this._contextStack.peek()).deepClone());
    }

    @Override
    public abstract void stroke();

    @Override
    public abstract void strokeAndFill(int var1);

    @Override
    public abstract void strokeText(String var1, PointF var2);

    public static class z2
    implements ICreateStreamProvider {
        private Stream stream;

        public z2(Stream stream) {
            this.stream = stream;
        }

        @Override
        public final void dispose() {
            this.stream = null;
        }

        @Override
        public final Stream getStream(String string, String string2) {
            return this.stream;
        }

        @Override
        public final Stream getStream(String string, String string2, int n2) {
            return this.stream;
        }

        @Override
        public final void releaseStream(Stream stream) {
        }
    }

    public static class z1 {
        public static <TGraphicContext, TRenderingOptions> Document m1(Device device) {
            return device.getCurrentDocument();
        }

        public static <TGraphicContext, TRenderingOptions> boolean m2(Device device) {
            return device.isRenderingStarted;
        }

        public static <TGraphicContext, TRenderingOptions> int m3(Device device) {
            return device.getPageIndex();
        }
    }
}

