/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.net.headers;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.Collections.Generic.IGenericCollection;
import com.aspose.html.internal.ms.System.Collections.Generic.IGenericEnumerator;
import com.aspose.html.internal.ms.System.Collections.Generic.List;
import com.aspose.html.internal.ms.System.Convert;
import com.aspose.html.internal.ms.System.DateTimeOffset;
import com.aspose.html.internal.ms.System.FormatException;
import com.aspose.html.internal.ms.System.ICloneable;
import com.aspose.html.internal.ms.System.IDisposable;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.Text.Encoding;
import com.aspose.html.internal.ms.System.Text.msStringBuilder;
import com.aspose.html.internal.ms.System.Uri;
import com.aspose.html.internal.ms.lang.Operators;
import com.aspose.html.internal.p136.z1;
import com.aspose.html.internal.p283.z27;
import com.aspose.html.net.headers.NameValueHeaderValue;
import com.aspose.html.z21;

public class ContentDispositionHeaderValue {
    private String _dispositionType;
    private List<NameValueHeaderValue> _parameters;
    private static final String creationDate = "creation-date";
    private static final String fileName = "filename";
    private static final String fileNameStar = "filename*";
    private static final String modificationDate = "modification-date";
    private static final String name = "name";
    private static final String readDate = "read-date";

    private z27<DateTimeOffset> getCreationDate() {
        return this.getDate(creationDate);
    }

    private void setCreationDate(z27<DateTimeOffset> z2710) {
        this.setDate(creationDate, z2710.m2869());
    }

    public final String getDispositionType() {
        return this._dispositionType;
    }

    public final void setDispositionType(String string) {
        ContentDispositionHeaderValue.checkDispositionTypeFormat(string, "value");
        this._dispositionType = string;
    }

    public final String getFileName() {
        return this.getName(fileName);
    }

    public final void setFileName(String string) {
        this.setName(fileName, string);
    }

    private String getFileNameStar() {
        return this.getName(fileNameStar);
    }

    private void setFileNameStar(String string) {
        this.setName(fileNameStar, string);
    }

    private z27<DateTimeOffset> getModificationDate() {
        return this.getDate(modificationDate);
    }

    private void setModificationDate(z27<DateTimeOffset> z2710) {
        this.setDate(modificationDate, z2710.m2869());
    }

    public final String getName() {
        return this.getName(name);
    }

    public final void setName(String string) {
        this.setName(name, string);
    }

    public final IGenericCollection<NameValueHeaderValue> getParameters() {
        if (this._parameters == null) {
            this._parameters = new List();
        }
        return this._parameters;
    }

    private z27<DateTimeOffset> getReadDate() {
        return this.getDate(readDate);
    }

    private void setReadDate(z27<DateTimeOffset> z2710) {
        this.setDate(readDate, z2710.m2869());
    }

    ContentDispositionHeaderValue() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ContentDispositionHeaderValue(ContentDispositionHeaderValue contentDispositionHeaderValue) {
        this._dispositionType = contentDispositionHeaderValue._dispositionType;
        if (contentDispositionHeaderValue._parameters != null) {
            IGenericEnumerator iGenericEnumerator = contentDispositionHeaderValue._parameters.iterator();
            try {
                while (iGenericEnumerator.hasNext()) {
                    NameValueHeaderValue nameValueHeaderValue = (NameValueHeaderValue)iGenericEnumerator.next();
                    this.getParameters().addItem((NameValueHeaderValue)((ICloneable)((Object)nameValueHeaderValue)).deepClone());
                }
            }
            finally {
                if (Operators.is(iGenericEnumerator, IDisposable.class)) {
                    ((IDisposable)iGenericEnumerator).dispose();
                }
            }
        }
    }

    public ContentDispositionHeaderValue(String string) {
        ContentDispositionHeaderValue.checkDispositionTypeFormat(string, "dispositionType");
        this._dispositionType = string;
    }

    private static void checkDispositionTypeFormat(String string, String string2) {
        if (StringExtensions.isNullOrEmpty(string)) {
            throw new ArgumentException(StringExtensions.format("DispositionType is null or empty {0}", string2));
        }
        String string3 = null;
        String[] stringArray = new String[]{string3};
        int n2 = ContentDispositionHeaderValue.getDispositionTypeExpressionLength(string, 0, stringArray);
        string3 = stringArray[0];
        if (n2 == 0 || string3.length() != string.length()) {
            throw new FormatException(StringExtensions.format("Invalid header {0}", string));
        }
    }

    private String encodeAndQuoteMime(String string) {
        String string2 = string;
        boolean bl2 = false;
        if (this.isQuoted(string2)) {
            string2 = StringExtensions.substring(string2, 1, string2.length() - 2);
            bl2 = true;
        }
        if (StringExtensions.indexOf(string2, "\"", 0, (short)4) >= 0) {
            throw new ArgumentException(StringExtensions.format("Http header invalid value {0}", string));
        }
        if (this.requiresEncoding(string2)) {
            bl2 = true;
            string2 = this.encodeMime(string2);
        } else if (!bl2 && z1.m10(string2, 0) != string2.length()) {
            bl2 = true;
        }
        if (bl2) {
            string2 = StringExtensions.concat("\"", string2, "\"");
        }
        return string2;
    }

    private String encodeMime(String string) {
        byte[] byArray = Encoding.getUTF8().getBytes(string);
        String string2 = Convert.toBase64String(byArray);
        return StringExtensions.concat("=?utf-8?B?", string2, "?=");
    }

    public boolean equals(Object object) {
        ContentDispositionHeaderValue contentDispositionHeaderValue = Operators.as(object, ContentDispositionHeaderValue.class);
        if (contentDispositionHeaderValue == null) {
            return false;
        }
        return StringExtensions.equals(this._dispositionType, contentDispositionHeaderValue._dispositionType, (short)5) && this._parameters.equals(contentDispositionHeaderValue._parameters);
    }

    private z27<DateTimeOffset> getDate(String string) {
        NameValueHeaderValue nameValueHeaderValue = NameValueHeaderValue.find(this._parameters, string);
        DateTimeOffset dateTimeOffset = new DateTimeOffset();
        if (nameValueHeaderValue != null) {
            String string2 = nameValueHeaderValue.getValue();
            if (this.isQuoted(string2)) {
                string2 = StringExtensions.substring(string2, 1, string2.length() - 2);
            }
            DateTimeOffset[] dateTimeOffsetArray = new DateTimeOffset[]{dateTimeOffset};
            boolean bl2 = z1.m1(string2, dateTimeOffsetArray);
            dateTimeOffsetArray[0].CloneTo(dateTimeOffset);
            if (bl2) {
                return new z27<DateTimeOffset>(DateTimeOffset.class, dateTimeOffset.Clone());
            }
        }
        return new z27<DateTimeOffset>(DateTimeOffset.class);
    }

    private static int getDispositionTypeExpressionLength(String string, int n2, String[] stringArray) {
        stringArray[0] = null;
        int n3 = z1.m10(string, n2);
        if (n3 == 0) {
            return 0;
        }
        stringArray[0] = StringExtensions.substring(string, n2, n3);
        return n3;
    }

    private String getName(String string) {
        NameValueHeaderValue nameValueHeaderValue = NameValueHeaderValue.find(this._parameters, string);
        if (nameValueHeaderValue != null) {
            String string2 = null;
            if (StringExtensions.endsWith(string, "*", (short)4)) {
                String[] stringArray = new String[]{string2};
                boolean bl2 = this.tryDecode5987(nameValueHeaderValue.getValue(), stringArray);
                string2 = stringArray[0];
                if (bl2) {
                    return string2;
                }
                return null;
            }
            String[] stringArray = new String[]{string2};
            boolean bl3 = this.tryDecodeMime(nameValueHeaderValue.getValue(), stringArray);
            string2 = stringArray[0];
            if (bl3) {
                return string2;
            }
            return nameValueHeaderValue.getValue();
        }
        return null;
    }

    private boolean isQuoted(String string) {
        return string.length() > 1 && StringExtensions.startsWith(string, "\"", (short)4) && StringExtensions.endsWith(string, "\"", (short)4);
    }

    private boolean requiresEncoding(String string) {
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 <= '\u007f') continue;
            return true;
        }
        return false;
    }

    private void setDate(String string, z27<DateTimeOffset> z2710) {
        NameValueHeaderValue nameValueHeaderValue = NameValueHeaderValue.find(this._parameters, string);
        if (!z2710.m2868().booleanValue()) {
            if (nameValueHeaderValue != null) {
                this._parameters.removeItem(nameValueHeaderValue);
            }
        } else {
            String string2 = StringExtensions.concat("\"", z1.m1(z2710.getValue().Clone()), "\"");
            if (nameValueHeaderValue != null) {
                nameValueHeaderValue.setValue(string2);
            } else {
                this.getParameters().addItem(new NameValueHeaderValue(string, string2));
            }
        }
    }

    private void setName(String string, String string2) {
        NameValueHeaderValue nameValueHeaderValue = NameValueHeaderValue.find(this._parameters, string);
        if (StringExtensions.isNullOrEmpty(string2)) {
            if (nameValueHeaderValue != null) {
                this._parameters.removeItem(nameValueHeaderValue);
            }
        } else {
            String string3 = StringExtensions.Empty;
            string3 = StringExtensions.endsWith(string, "*", (short)4) ? z21.m8(string2) : this.encodeAndQuoteMime(string2);
            if (nameValueHeaderValue != null) {
                nameValueHeaderValue.setValue(string3);
            } else {
                this.getParameters().addItem(new NameValueHeaderValue(string, string3));
            }
        }
    }

    public String toString() {
        msStringBuilder msStringBuilder2 = new msStringBuilder();
        msStringBuilder2.append(this._dispositionType);
        NameValueHeaderValue.toString(this._parameters, ';', true, msStringBuilder2);
        return msStringBuilder2.toString();
    }

    private boolean tryDecode5987(String string, String[] stringArray) {
        stringArray[0] = null;
        int n2 = StringExtensions.indexOf(string, '\'');
        if (n2 == -1) {
            return false;
        }
        int n3 = StringExtensions.lastIndexOf(string, '\'');
        if (n2 == n3 || StringExtensions.indexOf(string, '\'', n2 + 1) != n3) {
            return false;
        }
        String string2 = StringExtensions.substring(string, 0, n2);
        String string3 = StringExtensions.substring(string, n3 + 1, string.length() - (n3 + 1));
        msStringBuilder msStringBuilder2 = new msStringBuilder();
        try {
            Encoding encoding = Encoding.getEncoding(string2);
            byte[] byArray = new byte[string3.length()];
            int n4 = 0;
            for (int i2 = 0; i2 < string3.length(); ++i2) {
                if (Uri.isHexEncoding(string3, i2)) {
                    int[] nArray = new int[]{i2};
                    byArray[n4++] = (byte)Uri.hexUnescape(string3, nArray);
                    i2 = nArray[0];
                    --i2;
                    continue;
                }
                if (n4 > 0) {
                    msStringBuilder2.append(encoding.getString(byArray, 0, n4));
                    n4 = 0;
                }
                msStringBuilder2.append(string3.charAt(i2));
            }
            if (n4 > 0) {
                msStringBuilder2.append(encoding.getString(byArray, 0, n4));
            }
        }
        catch (ArgumentException argumentException) {
            return false;
        }
        stringArray[0] = msStringBuilder2.toString();
        return true;
    }

    private boolean tryDecodeMime(String string, String[] stringArray) {
        stringArray[0] = null;
        String string2 = string;
        if (!this.isQuoted(string2) || string2.length() < 10) {
            return false;
        }
        String[] stringArray2 = StringExtensions.split(string2, '?');
        if (!(stringArray2.length == 5 && "\"=".equals(stringArray2[0]) && "=\"".equals(stringArray2[4]) && "b".equals(StringExtensions.toLowerInvariant(stringArray2[2])))) {
            return false;
        }
        try {
            Encoding encoding = Encoding.getEncoding(stringArray2[1]);
            byte[] byArray = Convert.fromBase64String(stringArray2[3]);
            stringArray[0] = encoding.getString(byArray, 0, byArray.length);
            return true;
        }
        catch (ArgumentException argumentException) {
        }
        catch (FormatException formatException) {
            // empty catch block
        }
        return false;
    }
}

