/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.net;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.internal.ms.System.Collections.Generic.IGenericEnumerable;
import com.aspose.html.internal.ms.System.Collections.Generic.IGenericEnumerator;
import com.aspose.html.internal.ms.System.Collections.Generic.List;
import com.aspose.html.internal.ms.System.Collections.IEnumerator;
import com.aspose.html.internal.ms.System.Globalization.CultureInfo;
import com.aspose.html.internal.ms.System.Guid;
import com.aspose.html.internal.ms.System.IDisposable;
import com.aspose.html.internal.ms.System.IO.Stream;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.Text.msStringBuilder;
import com.aspose.html.internal.ms.lang.Operators;
import com.aspose.html.net.Content;
import com.aspose.html.net.headers.NameValueHeaderValue;

public class MultipartContent
extends Content
implements IGenericEnumerable<Content> {
    private static final String CrLf = "\r\n";
    private final String _boundary;
    private final List<Content> _nestedContent;

    public MultipartContent() {
        this("mixed", MultipartContent.getDefaultBoundary());
    }

    public MultipartContent(String string) {
        this(string, MultipartContent.getDefaultBoundary());
    }

    public MultipartContent(String string, String string2) {
        if (StringExtensions.isNullOrEmpty(string)) {
            throw new ArgumentException("The argument cannot be null or empty string.", string);
        }
        MultipartContent.validateBoundary(string2);
        this._boundary = string2;
        String string3 = string2;
        if (!StringExtensions.startsWith(string3, "\"", (short)4)) {
            string3 = StringExtensions.concat("\"", string3, "\"");
        }
        this.getHeaders().setByHttpRequestHeader(12, StringExtensions.concat("multipart/", string));
        this.getHeaders().setByHttpRequestHeader(12, StringExtensions.concat(this.getHeaders().get_Item(12), ";") + new NameValueHeaderValue("boundary", string3));
        this._nestedContent = new List();
    }

    public void add(Content content) {
        if (content == null) {
            throw new ArgumentNullException("content");
        }
        this._nestedContent.addItem(content);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dispose(boolean bl2) {
        if (bl2) {
            IGenericEnumerator iGenericEnumerator = this._nestedContent.iterator();
            try {
                while (iGenericEnumerator.hasNext()) {
                    Content content = (Content)iGenericEnumerator.next();
                    content.dispose();
                }
            }
            finally {
                if (Operators.is(iGenericEnumerator, IDisposable.class)) {
                    ((IDisposable)iGenericEnumerator).dispose();
                }
            }
            this._nestedContent.clear();
        }
        super.dispose(bl2);
    }

    private static void encodeStringToStream(Stream stream, String string) {
        byte[] byArray = DefaultHttpEncoding.getBytes(string);
        stream.write(byArray, 0, byArray.length);
    }

    private static String getDefaultBoundary() {
        return Guid.newGuid().toString();
    }

    @Override
    public final IGenericEnumerator<Content> iterator() {
        return this._nestedContent.iterator();
    }

    public final IEnumerator iterator_Rename_Namesake() {
        return this._nestedContent.iterator();
    }

    private String serializeHeadersToString(msStringBuilder msStringBuilder2, int n2, Content content) {
        if (n2 != 0) {
            msStringBuilder2.append(StringExtensions.concat(CrLf, "--"));
            msStringBuilder2.append(this._boundary);
            msStringBuilder2.append(CrLf);
        }
        for (String string : content.getHeaders()) {
            msStringBuilder2.append(string);
            msStringBuilder2.append(": ");
            msStringBuilder2.append(content.getHeaders().get_Item(string));
            msStringBuilder2.append(CrLf);
        }
        msStringBuilder2.append(CrLf);
        return msStringBuilder2.toString();
    }

    @Override
    protected void serializeToStream(Stream stream) {
        MultipartContent.encodeStringToStream(stream, StringExtensions.concat("--", this._boundary, CrLf));
        for (int i2 = 0; i2 < this._nestedContent.size(); ++i2) {
            msStringBuilder msStringBuilder2 = new msStringBuilder();
            Content content = this._nestedContent.get_Item(i2);
            MultipartContent.encodeStringToStream(stream, this.serializeHeadersToString(msStringBuilder2, i2, content));
            byte[] byArray = content.readAsByteArray();
            stream.write(byArray, 0, byArray.length);
        }
        MultipartContent.encodeStringToStream(stream, StringExtensions.concat(CrLf, "--", this._boundary, "--", CrLf));
    }

    private static void validateBoundary(String string) {
        if (StringExtensions.isNullOrEmpty(string)) {
            throw new ArgumentException("The argument cannot be null or empty string.", "boundary");
        }
        if (string.length() > 70) {
            throw new ArgumentOutOfRangeException("boundary", (Object)string, "Http content field too long");
        }
        if (StringExtensions.endsWith(string, " ", (short)4)) {
            throw new ArgumentException(StringExtensions.format("Invalid value for {0}.", string), "boundary");
        }
        String string2 = "'()+_,-./:=? ";
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if ('0' <= c2 && c2 <= '9' || 'a' <= c2 && c2 <= 'z' || 'A' <= c2 && c2 <= 'Z' || StringExtensions.indexOf("'()+_,-./:=? ", c2) >= 0) continue;
            throw new ArgumentException(StringExtensions.format(CultureInfo.getInvariantCulture(), "Invalid value for {0}", string), "boundary");
        }
    }
}

