/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.util;

import com.aspose.html.internal.ms.core.JavaLangSystem;
import com.aspose.html.internal.ms.core.bc.crypto.OutputMACCalculator;
import com.aspose.html.internal.ms.core.bc.crypto.SymmetricKey;
import com.aspose.html.internal.ms.core.bc.crypto.SymmetricSecretKey;
import com.aspose.html.internal.ms.core.bc.crypto.UpdateOutputStream;
import com.aspose.html.internal.ms.core.bc.crypto.fips.FipsSHS;
import com.aspose.html.internal.ms.core.bc.crypto.fips.FipsStatus;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.BouncyCastleFipsProvider;
import com.aspose.html.internal.ms.core.bc.util.Pack;
import com.aspose.html.internal.ms.core.bc.util.Strings;
import com.aspose.html.internal.ms.core.bc.util.encoders.Hex;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.TreeMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public class DumpInfo {
    public static void main(String[] stringArray) {
        if (stringArray.length > 0) {
            if (stringArray[0].equals("-c")) {
                JavaLangSystem.out.println(Strings.fromByteArray(Hex.encode(FipsStatus.getModuleHMAC())));
                JavaLangSystem.err.println("Generated new HMAC");
            } else if (stringArray[0].equals("-a") && stringArray.length > 1) {
                try {
                    JarFile jarFile = new JarFile(stringArray[1]);
                    JavaLangSystem.out.println(Strings.fromByteArray(Hex.encode(DumpInfo.calculateModuleHMAC(jarFile))));
                    JavaLangSystem.err.println("Generated new HMAC for Jar file " + stringArray[1]);
                }
                catch (IOException iOException) {
                    JavaLangSystem.err.println("Unable to open Jar file " + stringArray[1]);
                }
            } else {
                JavaLangSystem.err.println("Invalid command line arguments.");
            }
        } else {
            JavaLangSystem.out.println("Version Info: " + new BouncyCastleFipsProvider().getInfo());
            JavaLangSystem.out.println("FIPS Ready Status: " + FipsStatus.getStatusMessage());
            JavaLangSystem.out.println("Module SHA-256 HMAC: " + Strings.fromByteArray(Hex.encode(FipsStatus.getModuleHMAC())));
        }
    }

    private static byte[] calculateModuleHMAC(JarFile jarFile) {
        try {
            Object object;
            OutputMACCalculator outputMACCalculator = new FipsSHS.MACOperatorFactory().createOutputMACCalculator((SymmetricKey)new SymmetricSecretKey(FipsSHS.Algorithm.SHA256_HMAC, Strings.toByteArray("Legion of the Bouncy Castle Inc.")), FipsSHS.SHA256_HMAC);
            UpdateOutputStream updateOutputStream = outputMACCalculator.getMACStream();
            TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
            Object object2 = jarFile.entries();
            while (object2.hasMoreElements()) {
                object = object2.nextElement();
                if (((ZipEntry)object).isDirectory() || ((ZipEntry)object).getName().startsWith("META-INF")) continue;
                treeMap.put(((ZipEntry)object).getName(), object);
            }
            object2 = new byte[8192];
            for (Map.Entry entry : treeMap.entrySet()) {
                int n2;
                JarEntry jarEntry = (JarEntry)entry.getValue();
                InputStream inputStream = jarFile.getInputStream(jarEntry);
                byte[] byArray = Strings.toUTF8ByteArray(jarEntry.getName());
                updateOutputStream.update((byte)91);
                updateOutputStream.update(byArray, 0, byArray.length);
                updateOutputStream.update(Pack.longToBigEndian(jarEntry.getSize()), 0, 8);
                updateOutputStream.update((byte)93);
                while ((n2 = inputStream.read((byte[])object2, 0, ((Object)object2).length)) != -1) {
                    updateOutputStream.update((byte[])object2, 0, n2);
                }
                inputStream.close();
            }
            updateOutputStream.update((byte)91);
            object = Strings.toUTF8ByteArray("END");
            updateOutputStream.update((byte[])object, 0, ((Object)object).length);
            updateOutputStream.update((byte)93);
            updateOutputStream.close();
            return outputMACCalculator.getMAC();
        }
        catch (Exception exception) {
            return new byte[32];
        }
    }
}

