/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.security;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.ByteExtensions;
import com.aspose.html.internal.ms.System.NotImplementedException;
import com.aspose.html.internal.ms.System.Security.Cryptography.AsnEncodedData;
import com.aspose.html.internal.ms.System.Security.Cryptography.AsnEncodedDataCollection;
import com.aspose.html.internal.ms.System.Security.Cryptography.AsymmetricAlgorithm;
import com.aspose.html.internal.ms.System.Security.Cryptography.CryptographicAttributeObject;
import com.aspose.html.internal.ms.System.Security.Cryptography.CryptographicAttributeObjectCollection;
import com.aspose.html.internal.ms.System.Security.Cryptography.CryptographicException;
import com.aspose.html.internal.ms.System.Security.Cryptography.DSA;
import com.aspose.html.internal.ms.System.Security.Cryptography.DSAParameters;
import com.aspose.html.internal.ms.System.Security.Cryptography.Oid;
import com.aspose.html.internal.ms.System.Security.Cryptography.Pkcs.SubjectIdentifier;
import com.aspose.html.internal.ms.System.Security.Cryptography.RSA;
import com.aspose.html.internal.ms.System.Security.Cryptography.RSAParameters;
import com.aspose.html.internal.ms.System.Security.Cryptography.X509Certificates.X509Certificate;
import com.aspose.html.internal.ms.System.Security.Cryptography.Xml.X509IssuerSerial;
import com.aspose.html.internal.ms.System.Text.msStringBuilder;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1Encodable;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1EncodableVector;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1InputStream;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1ObjectIdentifier;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1Primitive;
import com.aspose.html.internal.ms.core.bc.asn1.DERSet;
import com.aspose.html.internal.ms.core.bc.asn1.cms.Attribute;
import com.aspose.html.internal.ms.core.bc.asn1.cms.AttributeTable;
import com.aspose.html.internal.ms.core.bc.asn1.x509.Certificate;
import com.aspose.html.internal.ms.core.bc.cert.X509CertificateHolder;
import com.aspose.html.internal.ms.core.bc.cms.DefaultSignedAttributeTableGenerator;
import com.aspose.html.internal.ms.core.bc.cms.SignerId;
import com.aspose.html.internal.ms.lang.Operators;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;

public final class a {
    private a() {
    }

    public static X509CertificateHolder a(X509Certificate x509Certificate) {
        try {
            return new X509CertificateHolder(Certificate.getInstance(new ASN1InputStream(x509Certificate.getRawCertData()).readObject()));
        }
        catch (IOException iOException) {
            throw new CryptographicException(iOException.getMessage());
        }
    }

    public static KeyPair a(DSA dSA) {
        return a.a(dSA.exportParameters(true).Clone());
    }

    public static KeyPair a(DSAParameters dSAParameters) {
        KeyFactory keyFactory = null;
        try {
            keyFactory = KeyFactory.getInstance("DSA");
            PublicKey publicKey = keyFactory.generatePublic(new DSAPublicKeySpec(new BigInteger(1, dSAParameters.Y), new BigInteger(1, dSAParameters.P), new BigInteger(1, dSAParameters.Q), new BigInteger(1, dSAParameters.G)));
            PrivateKey privateKey = keyFactory.generatePrivate(new DSAPrivateKeySpec(new BigInteger(1, dSAParameters.X), new BigInteger(1, dSAParameters.P), new BigInteger(1, dSAParameters.Q), new BigInteger(1, dSAParameters.G)));
            return new KeyPair(publicKey, privateKey);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CryptographicException(noSuchAlgorithmException.getMessage());
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new CryptographicException(invalidKeySpecException.getMessage());
        }
    }

    public static KeyPair a(RSA rSA) {
        return a.a(rSA.exportParameters(true).Clone());
    }

    public static KeyPair a(RSAParameters rSAParameters) {
        KeyFactory keyFactory = null;
        try {
            keyFactory = KeyFactory.getInstance("RSA");
            BigInteger bigInteger = new BigInteger(1, rSAParameters.Modulus);
            BigInteger bigInteger2 = new BigInteger(1, rSAParameters.Exponent);
            PublicKey publicKey = keyFactory.generatePublic(new RSAPublicKeySpec(bigInteger, bigInteger2));
            PrivateKey privateKey = keyFactory.generatePrivate(new RSAPrivateCrtKeySpec(bigInteger, bigInteger2, new BigInteger(1, rSAParameters.D), new BigInteger(1, rSAParameters.P), new BigInteger(1, rSAParameters.Q), new BigInteger(1, rSAParameters.DP), new BigInteger(1, rSAParameters.DQ), new BigInteger(1, rSAParameters.InverseQ)));
            return new KeyPair(publicKey, privateKey);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CryptographicException(noSuchAlgorithmException.getMessage());
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new CryptographicException(invalidKeySpecException.getMessage());
        }
    }

    public static KeyPair a(AsymmetricAlgorithm asymmetricAlgorithm) {
        if (Operators.is(asymmetricAlgorithm, DSA.class)) {
            return a.a((DSA)asymmetricAlgorithm);
        }
        if (Operators.is(asymmetricAlgorithm, RSA.class)) {
            return a.a((RSA)asymmetricAlgorithm);
        }
        throw new ArgumentException("Unsupported algorithm specified", "privateKey");
    }

    public static DefaultSignedAttributeTableGenerator a(CryptographicAttributeObjectCollection cryptographicAttributeObjectCollection) {
        if (cryptographicAttributeObjectCollection == null || cryptographicAttributeObjectCollection.size() == 0) {
            return null;
        }
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        for (CryptographicAttributeObject cryptographicAttributeObject : cryptographicAttributeObjectCollection) {
            AsnEncodedDataCollection asnEncodedDataCollection = cryptographicAttributeObject.getValues();
            ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector();
            for (AsnEncodedData asnEncodedData : asnEncodedDataCollection) {
                try {
                    aSN1EncodableVector2.add(ASN1Primitive.fromByteArray(asnEncodedData.getRawData()));
                }
                catch (IOException iOException) {
                    throw new CryptographicException(iOException.getMessage());
                }
            }
            aSN1EncodableVector.add(new Attribute(new ASN1ObjectIdentifier(cryptographicAttributeObject.getOid().getValue()), new DERSet(aSN1EncodableVector2)));
        }
        return new DefaultSignedAttributeTableGenerator(new AttributeTable(aSN1EncodableVector));
    }

    public static CryptographicAttributeObjectCollection a(AttributeTable attributeTable) throws IOException, IOException {
        if (attributeTable == null) {
            return new CryptographicAttributeObjectCollection();
        }
        CryptographicAttributeObjectCollection cryptographicAttributeObjectCollection = new CryptographicAttributeObjectCollection();
        Hashtable hashtable = attributeTable.toHashtable();
        Set set = hashtable.entrySet();
        for (Map.Entry entry : set) {
            ASN1ObjectIdentifier aSN1ObjectIdentifier = (ASN1ObjectIdentifier)entry.getKey();
            Oid oid = new Oid(aSN1ObjectIdentifier.getId());
            AsnEncodedDataCollection asnEncodedDataCollection = new AsnEncodedDataCollection();
            Attribute attribute = (Attribute)entry.getValue();
            for (ASN1Encodable aSN1Encodable : attribute.getAttrValues().toArray()) {
                asnEncodedDataCollection.add(new AsnEncodedData(aSN1Encodable.toASN1Primitive().getEncoded()));
            }
            CryptographicAttributeObject object = new CryptographicAttributeObject(oid, asnEncodedDataCollection);
            cryptographicAttributeObjectCollection.add(object);
        }
        return cryptographicAttributeObjectCollection;
    }

    public static SubjectIdentifier a(SignerId signerId) {
        int n2 = 0;
        if (signerId.getSubjectKeyIdentifier() != null) {
            n2 = 2;
            msStringBuilder msStringBuilder2 = new msStringBuilder();
            for (int i2 = 0; i2 < signerId.getSubjectKeyIdentifier().length; ++i2) {
                msStringBuilder2.append(ByteExtensions.toString(signerId.getSubjectKeyIdentifier()[i2], "X2"));
            }
            return new SubjectIdentifier(n2, msStringBuilder2.toString());
        }
        if (signerId.getIssuer() != null && signerId.getSerialNumber() != null) {
            n2 = 1;
            msStringBuilder msStringBuilder3 = new msStringBuilder();
            for (int i3 = 0; i3 < signerId.getSerialNumber().toByteArray().length; ++i3) {
                msStringBuilder3.append(ByteExtensions.toString(signerId.getSerialNumber().toByteArray()[i3], "X2"));
            }
            return new SubjectIdentifier(n2, Operators.boxing(new X509IssuerSerial(signerId.getIssuer().toString(), msStringBuilder3.toString())));
        }
        throw new NotImplementedException();
    }
}

