/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.pkix;

import com.aspose.html.internal.ms.core.bc.asn1.ASN1Integer;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1ObjectIdentifier;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1Sequence;
import com.aspose.html.internal.ms.core.bc.asn1.pkcs.PKCSObjectIdentifiers;
import com.aspose.html.internal.ms.core.bc.asn1.pkcs.RSAPublicKey;
import com.aspose.html.internal.ms.core.bc.asn1.x509.SubjectPublicKeyInfo;
import com.aspose.html.internal.ms.core.bc.asn1.x509.X509ObjectIdentifiers;
import com.aspose.html.internal.ms.core.bc.asn1.x9.X962Parameters;
import com.aspose.html.internal.ms.core.bc.asn1.x9.X9FieldID;
import com.aspose.html.internal.ms.core.bc.asn1.x9.X9ObjectIdentifiers;
import com.aspose.html.internal.ms.core.bc.crypto.CryptoServicesRegistrar;
import com.aspose.html.internal.ms.core.bc.pkix.Primes;
import java.io.IOException;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Security;
import java.util.Map;
import java.util.WeakHashMap;

public class SubjectPublicKeyInfoChecker {
    private static final Cache validatedQs = new Cache();

    public static void checkInfo(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        ASN1ObjectIdentifier aSN1ObjectIdentifier = subjectPublicKeyInfo.getAlgorithm().getAlgorithm();
        if (X9ObjectIdentifiers.id_ecPublicKey.equals(aSN1ObjectIdentifier)) {
            X962Parameters x962Parameters = X962Parameters.getInstance(subjectPublicKeyInfo.getAlgorithm().getParameters());
            if (x962Parameters.isImplicitlyCA() || x962Parameters.isNamedCurve()) {
                return;
            }
            ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance(x962Parameters.getParameters());
            X9FieldID x9FieldID = X9FieldID.getInstance(aSN1Sequence.getObjectAt(1));
            if (x9FieldID.getIdentifier().equals(X9FieldID.prime_field)) {
                BigInteger bigInteger = ASN1Integer.getInstance(x9FieldID.getParameters()).getValue();
                if (validatedQs.contains(bigInteger)) {
                    return;
                }
                int n2 = SubjectPublicKeyInfoChecker.asInteger("com.aspose.html.internal.ms.core.bc.ec.fp_max_size", 1042);
                int n3 = SubjectPublicKeyInfoChecker.asInteger("com.aspose.html.internal.ms.core.bc.ec.fp_certainty", 100);
                int n4 = bigInteger.bitLength();
                if (n2 < n4) {
                    throw new IllegalArgumentException("Fp q value out of range");
                }
                if (Primes.hasAnySmallFactors(bigInteger) || !Primes.isMRProbablePrime(bigInteger, CryptoServicesRegistrar.getSecureRandom(), SubjectPublicKeyInfoChecker.getNumberOfIterations(n4, n3))) {
                    throw new IllegalArgumentException("Fp q value not prime");
                }
                validatedQs.add(bigInteger);
            }
        } else if (PKCSObjectIdentifiers.rsaEncryption.equals(aSN1ObjectIdentifier) || X509ObjectIdentifiers.id_ea_rsa.equals(aSN1ObjectIdentifier) || PKCSObjectIdentifiers.id_RSAES_OAEP.equals(aSN1ObjectIdentifier) || PKCSObjectIdentifiers.id_RSASSA_PSS.equals(aSN1ObjectIdentifier)) {
            RSAPublicKey rSAPublicKey;
            try {
                rSAPublicKey = RSAPublicKey.getInstance(subjectPublicKeyInfo.parsePublicKey());
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("unable to parse RSA key");
            }
            if ((rSAPublicKey.getPublicExponent().intValue() & 1) == 0) {
                throw new IllegalArgumentException("RSA publicExponent is even");
            }
            SubjectPublicKeyInfoChecker.validate(rSAPublicKey.getModulus());
        }
    }

    private static void validate(BigInteger bigInteger) {
        int n2;
        if ((bigInteger.intValue() & 1) == 0) {
            throw new IllegalArgumentException("RSA modulus is even");
        }
        int n3 = SubjectPublicKeyInfoChecker.asInteger("com.aspose.html.internal.ms.core.bc.rsa.max_size", 15360);
        if (n3 < (n2 = bigInteger.bitLength())) {
            throw new IllegalArgumentException("modulus value out of range");
        }
    }

    private static int getNumberOfIterations(int n2, int n3) {
        if (n2 >= 1536) {
            return n3 <= 100 ? 3 : (n3 <= 128 ? 4 : 4 + (n3 - 128 + 1) / 2);
        }
        if (n2 >= 1024) {
            return n3 <= 100 ? 4 : (n3 <= 112 ? 5 : 5 + (n3 - 112 + 1) / 2);
        }
        if (n2 >= 512) {
            return n3 <= 80 ? 5 : (n3 <= 100 ? 7 : 7 + (n3 - 100 + 1) / 2);
        }
        return n3 <= 80 ? 40 : 40 + (n3 - 80 + 1) / 2;
    }

    static int asInteger(String string, int n2) {
        String string2 = SubjectPublicKeyInfoChecker.getPropertyValue(string);
        if (string2 != null) {
            return Integer.parseInt(string2);
        }
        return n2;
    }

    static String getPropertyValue(final String string) {
        String string2 = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Security.getProperty(string);
            }
        });
        if (string2 != null) {
            return string2;
        }
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(string);
            }
        });
    }

    private static class Cache {
        private final Map<BigInteger, Boolean> values = new WeakHashMap<BigInteger, Boolean>();
        private final BigInteger[] preserve = new BigInteger[8];
        private int preserveCounter = 0;

        private Cache() {
        }

        public synchronized void add(BigInteger bigInteger) {
            this.values.put(bigInteger, Boolean.TRUE);
            this.preserve[this.preserveCounter] = bigInteger;
            this.preserveCounter = (this.preserveCounter + 1) % this.preserve.length;
        }

        public synchronized boolean contains(BigInteger bigInteger) {
            return this.values.containsKey(bigInteger);
        }

        public synchronized int size() {
            return this.values.size();
        }

        public synchronized void clear() {
            this.values.clear();
            for (int i2 = 0; i2 != this.preserve.length; ++i2) {
                this.preserve[i2] = null;
            }
        }
    }
}

