/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.jcajce.provider;

import com.aspose.html.internal.ms.core.bc.crypto.asymmetric.AsymmetricXDHPublicKey;
import com.aspose.html.internal.ms.core.bc.jcajce.interfaces.XDHKey;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.KeyUtil;
import com.aspose.html.internal.ms.core.bc.util.Arrays;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.PublicKey;

class ProvXDHPublicKey
implements XDHKey,
PublicKey {
    static final long serialVersionUID = 1L;
    private transient AsymmetricXDHPublicKey baseKey;

    ProvXDHPublicKey(AsymmetricXDHPublicKey asymmetricXDHPublicKey) {
        this.baseKey = asymmetricXDHPublicKey;
    }

    ProvXDHPublicKey(byte[] byArray) {
        this.baseKey = new AsymmetricXDHPublicKey(byArray);
    }

    public String getAlgorithm() {
        return this.baseKey.getAlgorithm().getName();
    }

    public String getFormat() {
        return "X.509";
    }

    public byte[] getPublicData() {
        return this.baseKey.getPublicData();
    }

    public byte[] getEncoded() {
        return this.baseKey.getEncoded();
    }

    public AsymmetricXDHPublicKey getBaseKey() {
        return this.baseKey;
    }

    public String toString() {
        return KeyUtil.keyToString("Public Key", this.getAlgorithm(), this.baseKey);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ProvXDHPublicKey)) {
            return false;
        }
        ProvXDHPublicKey provXDHPublicKey = (ProvXDHPublicKey)object;
        return Arrays.areEqual(provXDHPublicKey.getEncoded(), this.getEncoded());
    }

    public int hashCode() {
        return this.baseKey.hashCode();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        byte[] byArray = (byte[])objectInputStream.readObject();
        this.baseKey = new AsymmetricXDHPublicKey(byArray);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.getEncoded());
    }
}

