/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.jcajce.provider;

import com.aspose.html.internal.ms.core.bc.crypto.Algorithm;
import com.aspose.html.internal.ms.core.bc.crypto.asymmetric.AsymmetricRSAPrivateKey;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.KeyUtil;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.ProvKey;
import com.aspose.html.internal.ms.core.bc.util.Strings;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.RSAPrivateCrtKeySpec;
import javax.security.auth.Destroyable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ProvRSAPrivateCrtKey
implements ProvKey<AsymmetricRSAPrivateKey>,
RSAPrivateCrtKey,
RSAPrivateKey,
Destroyable {
    static final long serialVersionUID = 7834723820638524718L;
    private transient AsymmetricRSAPrivateKey baseKey;

    ProvRSAPrivateCrtKey(Algorithm algorithm, RSAPrivateCrtKey rSAPrivateCrtKey) {
        this.baseKey = new AsymmetricRSAPrivateKey(algorithm, rSAPrivateCrtKey.getModulus(), rSAPrivateCrtKey.getPublicExponent(), rSAPrivateCrtKey.getPrivateExponent(), rSAPrivateCrtKey.getPrimeP(), rSAPrivateCrtKey.getPrimeQ(), rSAPrivateCrtKey.getPrimeExponentP(), rSAPrivateCrtKey.getPrimeExponentQ(), rSAPrivateCrtKey.getCrtCoefficient());
    }

    ProvRSAPrivateCrtKey(Algorithm algorithm, RSAPrivateCrtKeySpec rSAPrivateCrtKeySpec) {
        this.baseKey = new AsymmetricRSAPrivateKey(algorithm, rSAPrivateCrtKeySpec.getModulus(), rSAPrivateCrtKeySpec.getPublicExponent(), rSAPrivateCrtKeySpec.getPrivateExponent(), rSAPrivateCrtKeySpec.getPrimeP(), rSAPrivateCrtKeySpec.getPrimeQ(), rSAPrivateCrtKeySpec.getPrimeExponentP(), rSAPrivateCrtKeySpec.getPrimeExponentQ(), rSAPrivateCrtKeySpec.getCrtCoefficient());
    }

    ProvRSAPrivateCrtKey(AsymmetricRSAPrivateKey asymmetricRSAPrivateKey) {
        this.baseKey = asymmetricRSAPrivateKey;
    }

    @Override
    public AsymmetricRSAPrivateKey getBaseKey() {
        KeyUtil.checkDestroyed(this.baseKey);
        return this.baseKey;
    }

    @Override
    public String getFormat() {
        KeyUtil.checkDestroyed(this.baseKey);
        return "PKCS#8";
    }

    @Override
    public String getAlgorithm() {
        KeyUtil.checkDestroyed(this.baseKey);
        return "RSA";
    }

    @Override
    public byte[] getEncoded() {
        return this.baseKey.getEncoded();
    }

    @Override
    public BigInteger getPrivateExponent() {
        return this.baseKey.getPrivateExponent();
    }

    @Override
    public BigInteger getModulus() {
        return this.baseKey.getModulus();
    }

    @Override
    public BigInteger getPublicExponent() {
        return this.baseKey.getPublicExponent();
    }

    @Override
    public BigInteger getPrimeP() {
        return this.baseKey.getP();
    }

    @Override
    public BigInteger getPrimeQ() {
        return this.baseKey.getQ();
    }

    @Override
    public BigInteger getPrimeExponentP() {
        return this.baseKey.getDP();
    }

    @Override
    public BigInteger getPrimeExponentQ() {
        return this.baseKey.getDQ();
    }

    @Override
    public BigInteger getCrtCoefficient() {
        return this.baseKey.getQInv();
    }

    @Override
    public void destroy() {
        this.baseKey.destroy();
    }

    @Override
    public boolean isDestroyed() {
        return this.baseKey.isDestroyed();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ProvRSAPrivateCrtKey)) {
            return false;
        }
        ProvRSAPrivateCrtKey provRSAPrivateCrtKey = (ProvRSAPrivateCrtKey)object;
        return this.baseKey.equals(provRSAPrivateCrtKey.baseKey);
    }

    public int hashCode() {
        return this.baseKey.hashCode();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Algorithm algorithm = (Algorithm)objectInputStream.readObject();
        byte[] byArray = (byte[])objectInputStream.readObject();
        this.baseKey = new AsymmetricRSAPrivateKey(algorithm, byArray);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.isDestroyed()) {
            throw new IOException("key has been destroyed");
        }
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.baseKey.getAlgorithm());
        objectOutputStream.writeObject(this.getEncoded());
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = Strings.lineSeparator();
        if (this.isDestroyed()) {
            stringBuilder.append("RSA Private CRT Key [DESTROYED]").append(string);
        } else {
            stringBuilder.append("RSA Private CRT Key [").append(KeyUtil.generateFingerPrint(this.getModulus())).append("]").append(",[").append(KeyUtil.generateExponentFingerprint(this.getPublicExponent())).append("]").append(string);
            stringBuilder.append("             modulus: ").append(this.getModulus().toString(16)).append(string);
            stringBuilder.append("     public exponent: ").append(this.getPublicExponent().toString(16)).append(string);
        }
        return stringBuilder.toString();
    }
}

