/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.jcajce.provider;

import com.aspose.html.internal.ms.core.bc.asn1.ASN1ObjectIdentifier;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1Primitive;
import com.aspose.html.internal.ms.core.bc.asn1.cryptopro.CryptoProObjectIdentifiers;
import com.aspose.html.internal.ms.core.bc.asn1.pkcs.PBKDF2Params;
import com.aspose.html.internal.ms.core.bc.asn1.pkcs.PKCSObjectIdentifiers;
import com.aspose.html.internal.ms.core.bc.crypto.Algorithm;
import com.aspose.html.internal.ms.core.bc.crypto.CryptoServicesRegistrar;
import com.aspose.html.internal.ms.core.bc.crypto.DigestAlgorithm;
import com.aspose.html.internal.ms.core.bc.crypto.Parameters;
import com.aspose.html.internal.ms.core.bc.crypto.PasswordBasedDeriver;
import com.aspose.html.internal.ms.core.bc.crypto.PasswordConverter;
import com.aspose.html.internal.ms.core.bc.crypto.fips.FipsAlgorithm;
import com.aspose.html.internal.ms.core.bc.crypto.fips.FipsDigestAlgorithm;
import com.aspose.html.internal.ms.core.bc.crypto.fips.FipsPBKD;
import com.aspose.html.internal.ms.core.bc.crypto.fips.FipsSHS;
import com.aspose.html.internal.ms.core.bc.crypto.general.PBKD;
import com.aspose.html.internal.ms.core.bc.crypto.general.SecureHash;
import com.aspose.html.internal.ms.core.bc.jcajce.PBKDF2Key;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.AlgorithmProvider;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.BaseAlgorithmParameters;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.BaseKDFSecretKeyFactory;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.BouncyCastleFipsProvider;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.EngineCreator;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.GuardedEngineCreator;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.PBKDFPBEKey;
import com.aspose.html.internal.ms.core.bc.jcajce.spec.PBKDF2KeySpec;
import com.aspose.html.internal.ms.core.bc.jcajce.spec.PBKDF2ParameterSpec;
import java.io.IOException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.KeySpec;
import javax.crypto.SecretKey;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;

class ProvPBEPBKDF2
extends AlgorithmProvider {
    private static final String PREFIX = ProvPBEPBKDF2.class.getName();

    ProvPBEPBKDF2() {
    }

    public void configure(BouncyCastleFipsProvider bouncyCastleFipsProvider) {
        bouncyCastleFipsProvider.addAlgorithmImplementation("AlgorithmParameters.PBKDF2", PREFIX + "$AlgParams", new EngineCreator(){

            public Object createInstance(Object object) {
                return new AlgParams();
            }
        });
        bouncyCastleFipsProvider.addAlias("AlgorithmParameters", "PBKDF2", "PBKDF2WITHUTF8", "PBKDF2WITHASCII", "PBKDF2WITH8BIT");
        bouncyCastleFipsProvider.addAlias("AlgorithmParameters", "PBKDF2", PKCSObjectIdentifiers.id_PBKDF2);
        bouncyCastleFipsProvider.addAlgorithmImplementation("SecretKeyFactory.PBKDF2", PREFIX + "$PBKDF2withUTF8", new EngineCreator(){

            public Object createInstance(Object object) {
                return new BasePBKDF2("PBKDF2withHmacSHA1andUTF8", PasswordConverter.UTF8);
            }
        });
        bouncyCastleFipsProvider.addAlias("SecretKeyFactory", "PBKDF2", "PBKDF2WITHUTF8");
        bouncyCastleFipsProvider.addAlias("SecretKeyFactory", "PBKDF2", PKCSObjectIdentifiers.id_PBKDF2);
        bouncyCastleFipsProvider.addAlgorithmImplementation("SecretKeyFactory.PBKDF2WITHHMACSHA1", PREFIX + "$PBKDF2withHMACSHA1andUTF8", new EngineCreator(){

            public Object createInstance(Object object) {
                return new BasePBKDF2("PBKDF2withHmacSHA1andUTF8", PasswordConverter.UTF8, FipsSHS.Algorithm.SHA1_HMAC);
            }
        });
        bouncyCastleFipsProvider.addAlgorithmImplementation("SecretKeyFactory.PBKDF2WITHHMACSHA224", PREFIX + "$PBKDF2withHMACSHA224andUTF8", new EngineCreator(){

            public Object createInstance(Object object) {
                return new BasePBKDF2("PBKDF2withHmacSHA224andUTF8", PasswordConverter.UTF8, FipsSHS.Algorithm.SHA224_HMAC);
            }
        });
        bouncyCastleFipsProvider.addAlgorithmImplementation("SecretKeyFactory.PBKDF2WITHHMACSHA256", PREFIX + "$PBKDF2withHMACSHA256andUTF8", new EngineCreator(){

            public Object createInstance(Object object) {
                return new BasePBKDF2("PBKDF2withHmacSHA256andUTF8", PasswordConverter.UTF8, FipsSHS.Algorithm.SHA256_HMAC);
            }
        });
        bouncyCastleFipsProvider.addAlgorithmImplementation("SecretKeyFactory.PBKDF2WITHHMACSHA384", PREFIX + "$PBKDF2withHMACSHA384andUTF8", new EngineCreator(){

            public Object createInstance(Object object) {
                return new BasePBKDF2("PBKDF2withHmacSHA384andUTF8", PasswordConverter.UTF8, FipsSHS.Algorithm.SHA384_HMAC);
            }
        });
        bouncyCastleFipsProvider.addAlgorithmImplementation("SecretKeyFactory.PBKDF2WITHHMACSHA512", PREFIX + "$PBKDF2withHMACSHA512andUTF8", new EngineCreator(){

            public Object createInstance(Object object) {
                return new BasePBKDF2("PBKDF2withHmacSHA512andUTF8", PasswordConverter.UTF8, FipsSHS.Algorithm.SHA512_HMAC);
            }
        });
        if (!CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            bouncyCastleFipsProvider.addAlgorithmImplementation("SecretKeyFactory.PBKDF2WITHHMACGOST3411", PREFIX + "$PBKDF2withHMACGOST3411andUTF8", new GuardedEngineCreator(new EngineCreator(){

                public Object createInstance(Object object) {
                    return new BasePBKDF2("PBKDF2withHmacGOST3411andUTF8", PasswordConverter.UTF8, SecureHash.Algorithm.GOST3411_HMAC);
                }
            }));
        }
        bouncyCastleFipsProvider.addAlgorithmImplementation("SecretKeyFactory.PBKDF2WITHASCII", PREFIX + "$PBKDF2withASCII", new EngineCreator(){

            public Object createInstance(Object object) {
                return new BasePBKDF2("PBKDF2withHmacSHA1and8BIT", PasswordConverter.ASCII);
            }
        });
        bouncyCastleFipsProvider.addAlias("SecretKeyFactory", "PBKDF2WITHASCII", "PBKDF2WITH8BIT");
    }

    private static String convertToJCA(Algorithm algorithm) {
        String string = algorithm.getName();
        int n2 = string.indexOf(47);
        int n3 = string.indexOf(45);
        if (n3 > 0) {
            return string.substring(0, n3) + string.substring(n3 + 1, n2);
        }
        return string.substring(0, n2);
    }

    private static DigestAlgorithm getPrfAlgorithm(ASN1ObjectIdentifier aSN1ObjectIdentifier) throws InvalidKeySpecException {
        if (aSN1ObjectIdentifier.equals(CryptoProObjectIdentifiers.gostR3411Hmac)) {
            return SecureHash.Algorithm.GOST3411_HMAC;
        }
        if (aSN1ObjectIdentifier.equals(PKCSObjectIdentifiers.id_hmacWithSHA1)) {
            return FipsSHS.Algorithm.SHA1_HMAC;
        }
        if (aSN1ObjectIdentifier.equals(PKCSObjectIdentifiers.id_hmacWithSHA224)) {
            return FipsSHS.Algorithm.SHA224_HMAC;
        }
        if (aSN1ObjectIdentifier.equals(PKCSObjectIdentifiers.id_hmacWithSHA256)) {
            return FipsSHS.Algorithm.SHA256_HMAC;
        }
        if (aSN1ObjectIdentifier.equals(PKCSObjectIdentifiers.id_hmacWithSHA384)) {
            return FipsSHS.Algorithm.SHA384_HMAC;
        }
        if (aSN1ObjectIdentifier.equals(PKCSObjectIdentifiers.id_hmacWithSHA512)) {
            return FipsSHS.Algorithm.SHA512_HMAC;
        }
        throw new InvalidKeySpecException("Invalid KeySpec: unknown PRF algorithm " + aSN1ObjectIdentifier);
    }

    static byte[] getSecretKey(SecretKey secretKey, PBEParameterSpec pBEParameterSpec, PasswordBasedDeriver.KeyType keyType, int n2) {
        PasswordBasedDeriver<FipsPBKD.Parameters> passwordBasedDeriver = new FipsPBKD.DeriverFactory().createDeriver(FipsPBKD.PBKDF2.using(FipsSHS.Algorithm.SHA1_HMAC, secretKey.getEncoded()).withIterationCount(pBEParameterSpec.getIterationCount()).withSalt(pBEParameterSpec.getSalt()));
        return passwordBasedDeriver.deriveKey(keyType, (n2 + 7) / 8);
    }

    public static class AlgParams
    extends BaseAlgorithmParameters {
        PBKDF2Params params;

        protected byte[] localGetEncoded() throws IOException {
            return this.params.getEncoded("DER");
        }

        protected AlgorithmParameterSpec localEngineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
            if (clazz == PBEParameterSpec.class) {
                return new PBEParameterSpec(this.params.getSalt(), this.params.getIterationCount().intValue());
            }
            if (clazz == PBKDF2ParameterSpec.class || clazz == AlgorithmParameterSpec.class) {
                int n2;
                int n3 = n2 = this.params.getKeyLength() != null ? this.params.getKeyLength().intValue() * 8 : 0;
                if (this.params.isDefaultPrf()) {
                    return new PBKDF2ParameterSpec(this.params.getSalt(), this.params.getIterationCount().intValue(), n2);
                }
                return new PBKDF2ParameterSpec(this.params.getSalt(), this.params.getIterationCount().intValue(), n2, this.params.getPrf());
            }
            throw new InvalidParameterSpecException("AlgorithmParameterSpec not recognized: " + clazz.getName());
        }

        protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
            if (!(algorithmParameterSpec instanceof PBEParameterSpec)) {
                throw new InvalidParameterSpecException("PBEParameterSpec required to initialise a PBKDF2 PBE parameters algorithm parameters object");
            }
            if (algorithmParameterSpec instanceof PBKDF2ParameterSpec) {
                PBKDF2ParameterSpec pBKDF2ParameterSpec = (PBKDF2ParameterSpec)algorithmParameterSpec;
                this.params = new PBKDF2Params(pBKDF2ParameterSpec.getSalt(), pBKDF2ParameterSpec.getIterationCount(), pBKDF2ParameterSpec.getKeySize() / 8, pBKDF2ParameterSpec.getPrf());
            } else {
                PBEParameterSpec pBEParameterSpec = (PBEParameterSpec)algorithmParameterSpec;
                this.params = new PBKDF2Params(pBEParameterSpec.getSalt(), pBEParameterSpec.getIterationCount());
            }
        }

        protected void localInit(byte[] byArray) throws IOException {
            this.params = PBKDF2Params.getInstance(ASN1Primitive.fromByteArray(byArray));
        }

        protected String engineToString() {
            return "PBKDF2 Parameters";
        }
    }

    public static class BasePBKDF2
    extends BaseKDFSecretKeyFactory {
        private final String algName;
        private final PasswordConverter passwordConverter;
        private final DigestAlgorithm defaultPrf;

        public BasePBKDF2(String string, PasswordConverter passwordConverter) {
            this(string, passwordConverter, FipsSHS.Algorithm.SHA1_HMAC);
        }

        public BasePBKDF2(String string, PasswordConverter passwordConverter, DigestAlgorithm digestAlgorithm) {
            this.algName = string;
            this.passwordConverter = passwordConverter;
            this.defaultPrf = digestAlgorithm;
        }

        public SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
            if (keySpec instanceof PBEKeySpec) {
                PasswordBasedDeriver<Parameters> passwordBasedDeriver;
                PBEKeySpec pBEKeySpec = (PBEKeySpec)keySpec;
                if (pBEKeySpec.getSalt() == null) {
                    return new PBKDF2Key(((PBEKeySpec)keySpec).getPassword(), this.passwordConverter);
                }
                if (pBEKeySpec.getKeyLength() <= 0) {
                    throw new InvalidKeySpecException("Positive key length required: " + pBEKeySpec.getKeyLength());
                }
                DigestAlgorithm digestAlgorithm = this.defaultPrf;
                String string = this.algName;
                if (pBEKeySpec instanceof PBKDF2KeySpec && !((PBKDF2KeySpec)pBEKeySpec).isDefaultPrf()) {
                    passwordBasedDeriver = (PBKDF2KeySpec)pBEKeySpec;
                    digestAlgorithm = ProvPBEPBKDF2.getPrfAlgorithm(((PBKDF2KeySpec)((Object)passwordBasedDeriver)).getPrf().getAlgorithm());
                    string = this.passwordConverter == PasswordConverter.UTF8 ? "PBKDF2withHmac" + ProvPBEPBKDF2.convertToJCA(digestAlgorithm) + "andUTF8" : "PBKDF2withHmac" + ProvPBEPBKDF2.convertToJCA(digestAlgorithm) + "and8BIT";
                }
                passwordBasedDeriver = digestAlgorithm instanceof FipsAlgorithm ? new FipsPBKD.DeriverFactory().createDeriver(FipsPBKD.PBKDF2.using((FipsDigestAlgorithm)digestAlgorithm, this.passwordConverter, pBEKeySpec.getPassword()).withSalt(pBEKeySpec.getSalt()).withIterationCount(pBEKeySpec.getIterationCount())) : new PBKD.DeriverFactory().createDeriver(PBKD.PBKDF2.using(digestAlgorithm, this.passwordConverter, pBEKeySpec.getPassword()).withSalt(pBEKeySpec.getSalt()).withIterationCount(pBEKeySpec.getIterationCount()));
                return new PBKDFPBEKey(passwordBasedDeriver.deriveKey(PasswordBasedDeriver.KeyType.CIPHER, (pBEKeySpec.getKeyLength() + 7) / 8), string, pBEKeySpec);
            }
            throw new InvalidKeySpecException("Invalid KeySpec: " + keySpec.getClass().getName());
        }
    }
}

