/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.jcajce.provider;

import com.aspose.html.internal.ms.core.bc.asn1.ASN1ObjectIdentifier;
import com.aspose.html.internal.ms.core.bc.asn1.cryptopro.CryptoProObjectIdentifiers;
import com.aspose.html.internal.ms.core.bc.asn1.cryptopro.ECGOST3410NamedCurves;
import com.aspose.html.internal.ms.core.bc.asn1.pkcs.PrivateKeyInfo;
import com.aspose.html.internal.ms.core.bc.asn1.x509.SubjectPublicKeyInfo;
import com.aspose.html.internal.ms.core.bc.crypto.Algorithm;
import com.aspose.html.internal.ms.core.bc.crypto.AsymmetricKeyPairGenerator;
import com.aspose.html.internal.ms.core.bc.crypto.asymmetric.AsymmetricECGOST3410PrivateKey;
import com.aspose.html.internal.ms.core.bc.crypto.asymmetric.AsymmetricECGOST3410PublicKey;
import com.aspose.html.internal.ms.core.bc.crypto.asymmetric.AsymmetricKeyPair;
import com.aspose.html.internal.ms.core.bc.crypto.asymmetric.ECDomainParameters;
import com.aspose.html.internal.ms.core.bc.crypto.asymmetric.GOST3410Parameters;
import com.aspose.html.internal.ms.core.bc.crypto.general.ECGOST3410;
import com.aspose.html.internal.ms.core.bc.jcajce.interfaces.ECGOST3410PrivateKey;
import com.aspose.html.internal.ms.core.bc.jcajce.interfaces.ECGOST3410PublicKey;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.AsymmetricAlgorithmProvider;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.BaseKeyFactory;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.BaseSignature;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.BouncyCastleFipsProvider;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.EngineCreator;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.GOST3410Util;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.GuardedEngineCreator;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.PrivateKeyConverter;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.ProvECGOST3410PrivateKey;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.ProvECGOST3410PublicKey;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.PublicKeyConverter;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.Utils;
import com.aspose.html.internal.ms.core.bc.jcajce.spec.ECDomainParameterSpec;
import com.aspose.html.internal.ms.core.bc.jcajce.spec.ECGOST3410PrivateKeySpec;
import com.aspose.html.internal.ms.core.bc.jcajce.spec.ECGOST3410PublicKeySpec;
import com.aspose.html.internal.ms.core.bc.jcajce.spec.GOST3410ParameterSpec;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;

class ProvECGOST3410
extends AsymmetricAlgorithmProvider {
    private static final String PREFIX = "com.aspose.html.internal.ms.core.bc.jcajce.provider.asymmetric.ecgost.";
    private static final PublicKeyConverter<AsymmetricECGOST3410PublicKey> publicKeyConverter = new PublicKeyConverter<AsymmetricECGOST3410PublicKey>(){

        @Override
        public AsymmetricECGOST3410PublicKey convertKey(Algorithm algorithm, PublicKey publicKey) throws InvalidKeyException {
            if (publicKey instanceof ECGOST3410PublicKey) {
                if (publicKey instanceof ProvECGOST3410PublicKey) {
                    return ((ProvECGOST3410PublicKey)publicKey).getBaseKey();
                }
                return new ProvECGOST3410PublicKey(algorithm, (ECGOST3410PublicKey)publicKey).getBaseKey();
            }
            try {
                return new AsymmetricECGOST3410PublicKey(algorithm, SubjectPublicKeyInfo.getInstance(Utils.getKeyEncoding(publicKey)));
            }
            catch (Exception exception) {
                throw new InvalidKeyException("Cannot identify ECGOST3410 public key: " + exception.getMessage(), exception);
            }
        }
    };
    private static final PrivateKeyConverter<AsymmetricECGOST3410PrivateKey> privateKeyConverter = new PrivateKeyConverter<AsymmetricECGOST3410PrivateKey>(){

        @Override
        public AsymmetricECGOST3410PrivateKey convertKey(Algorithm algorithm, PrivateKey privateKey) throws InvalidKeyException {
            if (privateKey instanceof ECGOST3410PrivateKey) {
                if (privateKey instanceof ProvECGOST3410PrivateKey) {
                    return ((ProvECGOST3410PrivateKey)privateKey).getBaseKey();
                }
                return new ProvECGOST3410PrivateKey(algorithm, (ECGOST3410PrivateKey)privateKey).getBaseKey();
            }
            try {
                return new AsymmetricECGOST3410PrivateKey(algorithm, PrivateKeyInfo.getInstance(Utils.getKeyEncoding(privateKey)));
            }
            catch (Exception exception) {
                throw new InvalidKeyException("Cannot identify ECGOST3410 private key: " + exception.getMessage(), exception);
            }
        }
    };

    ProvECGOST3410() {
    }

    public void configure(final BouncyCastleFipsProvider bouncyCastleFipsProvider) {
        bouncyCastleFipsProvider.addAlgorithmImplementation("KeyFactory.ECGOST3410", "com.aspose.html.internal.ms.core.bc.jcajce.provider.asymmetric.ecgost.KeyFactorySpi", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new KeyFactorySpi();
            }
        }));
        bouncyCastleFipsProvider.addAlias("Alg.Alias.KeyFactory.GOST-3410-2001", "ECGOST3410");
        bouncyCastleFipsProvider.addAlias("Alg.Alias.KeyFactory.ECGOST-3410", "ECGOST3410");
        bouncyCastleFipsProvider.addAlgorithmImplementation("KeyPairGenerator.ECGOST3410", "com.aspose.html.internal.ms.core.bc.jcajce.provider.asymmetric.ecgost.KeyPairGeneratorSpi", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new KeyPairGenerator(bouncyCastleFipsProvider);
            }
        }));
        bouncyCastleFipsProvider.addAlias("Alg.Alias.KeyPairGenerator.ECGOST-3410", "ECGOST3410");
        bouncyCastleFipsProvider.addAlias("Alg.Alias.KeyPairGenerator.GOST-3410-2001", "ECGOST3410");
        this.registerOid(bouncyCastleFipsProvider, CryptoProObjectIdentifiers.gostR3410_2001, "ECGOST3410", new KeyFactorySpi());
        this.addSignatureAlgorithm(bouncyCastleFipsProvider, "GOST3411", "ECGOST3410", "com.aspose.html.internal.ms.core.bc.jcajce.provider.asymmetric.ecgost.ECSignatureSpi", CryptoProObjectIdentifiers.gostR3411_94_with_gostR3410_2001, new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseSignature(bouncyCastleFipsProvider, new ECGOST3410.SignatureOperatorFactory(), publicKeyConverter, privateKeyConverter, ECGOST3410.GOST3410);
            }
        }));
        bouncyCastleFipsProvider.addAlias("Alg.Alias.Signature.ECGOST3410", "GOST3411WITHECGOST3410");
        bouncyCastleFipsProvider.addAlias("Alg.Alias.Signature.ECGOST-3410", "GOST3411WITHECGOST3410");
        bouncyCastleFipsProvider.addAlias("Alg.Alias.Signature.GOST-3410-2001", "GOST3411WITHECGOST3410");
    }

    static class KeyFactorySpi
    extends BaseKeyFactory {
        protected KeySpec engineGetKeySpec(Key key, Class clazz) throws InvalidKeySpecException {
            ECGOST3410PrivateKey eCGOST3410PrivateKey;
            if (clazz == null) {
                throw new InvalidKeySpecException("null spec is invalid");
            }
            if (clazz.isAssignableFrom(ECGOST3410PublicKeySpec.class) && key instanceof ECGOST3410PublicKey) {
                ECGOST3410PublicKey eCGOST3410PublicKey = (ECGOST3410PublicKey)key;
                if (eCGOST3410PublicKey.getParams() != null) {
                    return new ECGOST3410PublicKeySpec(eCGOST3410PublicKey.getW(), eCGOST3410PublicKey.getParams());
                }
            } else if (clazz.isAssignableFrom(ECGOST3410PrivateKeySpec.class) && key instanceof ECGOST3410PrivateKey && (eCGOST3410PrivateKey = (ECGOST3410PrivateKey)key).getParams() != null) {
                return new ECGOST3410PrivateKeySpec(eCGOST3410PrivateKey.getS(), eCGOST3410PrivateKey.getParams());
            }
            return super.engineGetKeySpec(key, clazz);
        }

        protected Key engineTranslateKey(Key key) throws InvalidKeyException {
            if (key instanceof PublicKey) {
                return new ProvECGOST3410PublicKey((AsymmetricECGOST3410PublicKey)publicKeyConverter.convertKey(ECGOST3410.ALGORITHM, (PublicKey)key));
            }
            if (key instanceof PrivateKey) {
                return new ProvECGOST3410PrivateKey((AsymmetricECGOST3410PrivateKey)privateKeyConverter.convertKey(ECGOST3410.ALGORITHM, (PrivateKey)key));
            }
            if (key != null) {
                throw new InvalidKeyException("Key type unrecognized: " + key.getClass().getName());
            }
            throw new InvalidKeyException("Key is null");
        }

        protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
            if (keySpec instanceof ECGOST3410PrivateKeySpec) {
                return new ProvECGOST3410PrivateKey((Algorithm)ECGOST3410.ALGORITHM, (ECGOST3410PrivateKeySpec)keySpec);
            }
            return super.engineGeneratePrivate(keySpec);
        }

        protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
            if (keySpec instanceof ECGOST3410PublicKeySpec) {
                return new ProvECGOST3410PublicKey((Algorithm)ECGOST3410.ALGORITHM, (ECGOST3410PublicKeySpec)keySpec);
            }
            return super.engineGeneratePublic(keySpec);
        }

        public PrivateKey generatePrivate(PrivateKeyInfo privateKeyInfo) throws IOException {
            return new ProvECGOST3410PrivateKey(new AsymmetricECGOST3410PrivateKey((Algorithm)ECGOST3410.ALGORITHM, privateKeyInfo));
        }

        public PublicKey generatePublic(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
            return new ProvECGOST3410PublicKey(new AsymmetricECGOST3410PublicKey((Algorithm)ECGOST3410.ALGORITHM, subjectPublicKeyInfo));
        }
    }

    static class KeyPairGenerator
    extends java.security.KeyPairGenerator {
        private final BouncyCastleFipsProvider fipsProvider;
        private GOST3410Parameters<ECDomainParameters> params;
        private AsymmetricKeyPairGenerator engine;
        private SecureRandom random;
        private boolean initialised = false;

        public KeyPairGenerator(BouncyCastleFipsProvider bouncyCastleFipsProvider) {
            super("GOST3410");
            this.fipsProvider = bouncyCastleFipsProvider;
            this.random = bouncyCastleFipsProvider.getDefaultSecureRandom();
        }

        public void initialize(int n2) {
            this.initialize(n2, this.fipsProvider.getDefaultSecureRandom());
        }

        public void initialize(int n2, SecureRandom secureRandom) {
            throw new InvalidParameterException("ECGOST3410 KeyPairGenerator needs to be initialized with a GOST3410ParameterSpec");
        }

        private void init(GOST3410ParameterSpec gOST3410ParameterSpec, SecureRandom secureRandom) {
            if (!(gOST3410ParameterSpec.getDomainParametersSpec() instanceof ECDomainParameterSpec)) {
                throw new InvalidParameterException("GOST3410 KeyPairGenerator needs to be initialized with a GOST3410ParameterSpec<ECDomainParameterSpec>");
            }
            this.params = GOST3410Util.convertToECParams(gOST3410ParameterSpec);
            this.engine = new ECGOST3410.KeyPairGenerator(new ECGOST3410.KeyGenParameters(this.params), secureRandom);
            this.initialised = true;
        }

        public void initialize(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
            this.initialize(algorithmParameterSpec, this.fipsProvider.getDefaultSecureRandom());
        }

        public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
            GOST3410ParameterSpec gOST3410ParameterSpec;
            if (!(algorithmParameterSpec instanceof GOST3410ParameterSpec) && !(algorithmParameterSpec instanceof ECGenParameterSpec)) {
                throw new InvalidAlgorithmParameterException("AlgorithmParameterSpec not recognized: " + algorithmParameterSpec.getClass().getName());
            }
            if (algorithmParameterSpec instanceof ECGenParameterSpec) {
                ASN1ObjectIdentifier aSN1ObjectIdentifier = ECGOST3410NamedCurves.getOID(((ECGenParameterSpec)algorithmParameterSpec).getName());
                gOST3410ParameterSpec = new GOST3410ParameterSpec(new GOST3410Parameters(aSN1ObjectIdentifier));
            } else {
                gOST3410ParameterSpec = (GOST3410ParameterSpec)algorithmParameterSpec;
            }
            this.init(gOST3410ParameterSpec, secureRandom);
        }

        public KeyPair generateKeyPair() {
            if (!this.initialised) {
                this.init(new GOST3410ParameterSpec(new GOST3410Parameters(CryptoProObjectIdentifiers.gostR3410_2001_CryptoPro_A, CryptoProObjectIdentifiers.gostR3411)), this.random);
            }
            AsymmetricKeyPair asymmetricKeyPair = this.engine.generateKeyPair();
            AsymmetricECGOST3410PublicKey asymmetricECGOST3410PublicKey = (AsymmetricECGOST3410PublicKey)asymmetricKeyPair.getPublicKey();
            AsymmetricECGOST3410PrivateKey asymmetricECGOST3410PrivateKey = (AsymmetricECGOST3410PrivateKey)asymmetricKeyPair.getPrivateKey();
            return new KeyPair(new ProvECGOST3410PublicKey(asymmetricECGOST3410PublicKey), new ProvECGOST3410PrivateKey(asymmetricECGOST3410PrivateKey));
        }
    }
}

