/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.jcajce.provider;

import com.aspose.html.internal.ms.core.bc.asn1.oiw.OIWObjectIdentifiers;
import com.aspose.html.internal.ms.core.bc.asn1.pkcs.PKCSObjectIdentifiers;
import com.aspose.html.internal.ms.core.bc.crypto.AuthenticationParameters;
import com.aspose.html.internal.ms.core.bc.crypto.AuthenticationParametersWithIV;
import com.aspose.html.internal.ms.core.bc.crypto.CryptoServicesRegistrar;
import com.aspose.html.internal.ms.core.bc.crypto.MACOperatorFactory;
import com.aspose.html.internal.ms.core.bc.crypto.Parameters;
import com.aspose.html.internal.ms.core.bc.crypto.ParametersWithIV;
import com.aspose.html.internal.ms.core.bc.crypto.PasswordBasedDeriver;
import com.aspose.html.internal.ms.core.bc.crypto.SymmetricKeyGenerator;
import com.aspose.html.internal.ms.core.bc.crypto.fips.FipsParameters;
import com.aspose.html.internal.ms.core.bc.crypto.fips.FipsTripleDES;
import com.aspose.html.internal.ms.core.bc.crypto.general.TripleDES;
import com.aspose.html.internal.ms.core.bc.crypto.internal.ValidatedSymmetricKey;
import com.aspose.html.internal.ms.core.bc.crypto.internal.params.DesParameters;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.AlgorithmProvider;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.AuthParametersCreator;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.BaseCipher;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.BaseKeyGenerator;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.BaseMac;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.BaseSecretKeyFactory;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.BaseWrapCipher;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.BouncyCastleFipsProvider;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.EngineCreator;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.GuardedEngineCreator;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.IVAlgorithmParameterGenerator;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.IvAlgorithmParameters;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.IvParametersCreator;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.KeyGeneratorCreator;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.MacParametersCreator;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.PBEScheme;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.ParametersCreator;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.ParametersCreatorProvider;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.ProvPKCS12;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.ProvSecretKeySpec;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.Utils;
import com.aspose.html.internal.ms.core.bc.jcajce.spec.WrapParameterSpec;
import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.SecretKey;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEParameterSpec;

final class ProvDESede
extends AlgorithmProvider {
    private static final Map<String, String> generalDesEdeAttributes = new HashMap<String, String>();
    private FipsTripleDES.OperatorFactory fipsOperatorFactory;
    private FipsTripleDES.KeyWrapOperatorFactory fipsKeyWrapOperatorFactory;
    private static final String PREFIX;
    private Class[] availableSpecs = new Class[]{IvParameterSpec.class};
    private ParametersCreatorProvider<FipsParameters> fipsParametersCreatorProvider = new ParametersCreatorProvider<FipsParameters>(){

        @Override
        public ParametersCreator get(final FipsParameters fipsParameters) {
            if (Utils.isAuthMode(fipsParameters.getAlgorithm())) {
                return new AuthParametersCreator((AuthenticationParametersWithIV)((Object)fipsParameters));
            }
            if (fipsParameters.getAlgorithm().equals(FipsTripleDES.TKW.getAlgorithm())) {
                return new ParametersCreator(){

                    public Parameters createParameters(boolean bl2, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
                        if (algorithmParameterSpec instanceof WrapParameterSpec) {
                            return ((FipsTripleDES.WrapParameters)fipsParameters).withUsingInverseFunction(((WrapParameterSpec)algorithmParameterSpec).useInverseFunction());
                        }
                        return fipsParameters;
                    }
                };
            }
            return new IvParametersCreator((ParametersWithIV)((Object)fipsParameters));
        }
    };
    private ParametersCreatorProvider<Parameters> generalParametersCreatorProvider = new ParametersCreatorProvider<Parameters>(){

        @Override
        public ParametersCreator get(Parameters parameters) {
            if (Utils.isAuthMode(parameters.getAlgorithm())) {
                return new AuthParametersCreator((AuthenticationParametersWithIV)parameters);
            }
            return new IvParametersCreator((ParametersWithIV)parameters);
        }
    };

    ProvDESede() {
        this.fipsOperatorFactory = new FipsTripleDES.OperatorFactory();
        this.fipsKeyWrapOperatorFactory = new FipsTripleDES.KeyWrapOperatorFactory();
    }

    public void configure(final BouncyCastleFipsProvider bouncyCastleFipsProvider) {
        bouncyCastleFipsProvider.addAlgorithmImplementation("Cipher.DESEDE", PREFIX + "$ECB", generalDesEdeAttributes, new EngineCreator(){

            public Object createInstance(Object object) {
                if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
                    return new BaseCipher.Builder(bouncyCastleFipsProvider, 64, FipsTripleDES.ECBwithPKCS7, FipsTripleDES.ECB, FipsTripleDES.ECBwithISO10126_2, FipsTripleDES.ECBwithISO7816_4, FipsTripleDES.ECBwithTBC, FipsTripleDES.ECBwithX923, FipsTripleDES.CBC, FipsTripleDES.CBCwithPKCS7, FipsTripleDES.CBCwithISO10126_2, FipsTripleDES.CBCwithISO7816_4, FipsTripleDES.CBCwithTBC, FipsTripleDES.CBCwithX923, FipsTripleDES.CBCwithCS1, FipsTripleDES.CBCwithCS2, FipsTripleDES.CBCwithCS3, FipsTripleDES.CFB64, FipsTripleDES.CFB8, FipsTripleDES.OFB, FipsTripleDES.CTR).withFipsOperators(ProvDESede.this.fipsParametersCreatorProvider, ProvDESede.this.fipsOperatorFactory, null).withParameters(ProvDESede.this.availableSpecs).build();
                }
                return new BaseCipher.Builder(bouncyCastleFipsProvider, 64, FipsTripleDES.ECBwithPKCS7, FipsTripleDES.ECB, FipsTripleDES.ECBwithISO10126_2, FipsTripleDES.ECBwithISO7816_4, FipsTripleDES.ECBwithTBC, FipsTripleDES.ECBwithX923, FipsTripleDES.CBC, FipsTripleDES.CBCwithPKCS7, FipsTripleDES.CBCwithISO10126_2, FipsTripleDES.CBCwithISO7816_4, FipsTripleDES.CBCwithTBC, FipsTripleDES.CBCwithX923, FipsTripleDES.CBCwithCS1, FipsTripleDES.CBCwithCS2, FipsTripleDES.CBCwithCS3, FipsTripleDES.CFB64, FipsTripleDES.CFB8, FipsTripleDES.OFB, FipsTripleDES.CTR, TripleDES.OpenPGPCFB, TripleDES.EAX).withFipsOperators(ProvDESede.this.fipsParametersCreatorProvider, ProvDESede.this.fipsOperatorFactory, null).withGeneralOperators(ProvDESede.this.generalParametersCreatorProvider, null, new TripleDES.AEADOperatorFactory()).withParameters(ProvDESede.this.availableSpecs).build();
            }
        });
        bouncyCastleFipsProvider.addAlgorithmImplementation("Cipher", PKCSObjectIdentifiers.des_EDE3_CBC, PREFIX + "$CBC", generalDesEdeAttributes, new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseCipher.Builder(bouncyCastleFipsProvider, 64, FipsTripleDES.CBCwithPKCS7).withFipsOperators(ProvDESede.this.fipsParametersCreatorProvider, ProvDESede.this.fipsOperatorFactory, null).withParameters(ProvDESede.this.availableSpecs).build();
            }
        });
        bouncyCastleFipsProvider.addAlgorithmImplementation("Cipher.DESEDEWRAP", PREFIX + "$Wrap", generalDesEdeAttributes, new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseWrapCipher.Builder(bouncyCastleFipsProvider, FipsTripleDES.TKW).withFipsOperators(ProvDESede.this.fipsParametersCreatorProvider, ProvDESede.this.fipsKeyWrapOperatorFactory).withParameters(ProvDESede.this.availableSpecs).build();
            }
        });
        bouncyCastleFipsProvider.addAlias("Alg.Alias.Cipher.DESEDETKW", "DESEDEWRAP");
        if (!CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            bouncyCastleFipsProvider.addAlgorithmImplementation("Cipher.DESEDERFC3217WRAP", PREFIX + "$RFC3217Wrap", generalDesEdeAttributes, (EngineCreator)new GuardedEngineCreator(new EngineCreator(){

                public Object createInstance(Object object) {
                    return new BaseWrapCipher.Builder(bouncyCastleFipsProvider, TripleDES.RFC3217_WRAP).withGeneralOperators(ProvDESede.this.generalParametersCreatorProvider, new TripleDES.KeyWrapOperatorFactory()).withParameters(ProvDESede.this.availableSpecs).build();
                }
            }));
            bouncyCastleFipsProvider.addAlias("Cipher", "DESEDERFC3217WRAP", PKCSObjectIdentifiers.id_alg_CMS3DESwrap);
            bouncyCastleFipsProvider.addAlgorithmImplementation("Cipher.DESEDERFC3211WRAP", PREFIX + "$RFC3211Wrap", generalDesEdeAttributes, (EngineCreator)new GuardedEngineCreator(new EngineCreator(){

                public Object createInstance(Object object) {
                    return new BaseWrapCipher.Builder(bouncyCastleFipsProvider, TripleDES.RFC3211_WRAP).withGeneralOperators(ProvDESede.this.generalParametersCreatorProvider, new TripleDES.KeyWrapOperatorFactory()).withParameters(ProvDESede.this.availableSpecs).build();
                }
            }));
            bouncyCastleFipsProvider.addAlgorithmImplementation("Cipher.DESEDE/OPENPGPCFB/NOPADDING", PREFIX + "$OpenPGP", generalDesEdeAttributes, (EngineCreator)new GuardedEngineCreator(new EngineCreator(){

                public Object createInstance(Object object) {
                    return new BaseCipher.Builder(bouncyCastleFipsProvider, 64, TripleDES.OpenPGPCFB).withGeneralOperators(ProvDESede.this.generalParametersCreatorProvider, new TripleDES.OperatorFactory(), null).withParameters(ProvDESede.this.availableSpecs).build();
                }
            }));
            bouncyCastleFipsProvider.addAlgorithmImplementation("Cipher.PBEWITHSHAAND3-KEYDESEDE-CBC", PREFIX + "$PBEWithSHAAndDES3Key", new GuardedEngineCreator(new EngineCreator(){

                public Object createInstance(Object object) {
                    return new BaseCipher.Builder(bouncyCastleFipsProvider, 64, FipsTripleDES.CBCwithPKCS7).withFixedKeySize(192).withScheme(PBEScheme.PKCS12).withFipsOperators(ProvDESede.this.fipsParametersCreatorProvider, ProvDESede.this.fipsOperatorFactory, null).withParameters(new Class[]{PBEParameterSpec.class}).build();
                }
            }));
            bouncyCastleFipsProvider.addAlgorithmImplementation("Cipher.PBEWITHSHAAND2-KEYDESEDE-CBC", PREFIX + "$PBEWithSHAAndDES2Key", new GuardedEngineCreator(new EngineCreator(){

                public Object createInstance(Object object) {
                    return new BaseCipher.Builder(bouncyCastleFipsProvider, 64, FipsTripleDES.CBCwithPKCS7).withFixedKeySize(128).withScheme(PBEScheme.PKCS12).withFipsOperators(ProvDESede.this.fipsParametersCreatorProvider, ProvDESede.this.fipsOperatorFactory, null).withParameters(new Class[]{PBEParameterSpec.class}).build();
                }
            }));
            bouncyCastleFipsProvider.addAlias("Cipher", "PBEWITHSHAAND3-KEYDESEDE-CBC", PKCSObjectIdentifiers.pbeWithSHAAnd3_KeyTripleDES_CBC);
            bouncyCastleFipsProvider.addAlias("Cipher", "PBEWITHSHAAND3-KEYDESEDE-CBC", "PBEWITHSHA1ANDDESEDE", "PBEWITHSHAAND3KEYTRIPLEDES");
            bouncyCastleFipsProvider.addAlias("Cipher", "PBEWITHSHAAND2-KEYDESEDE-CBC", PKCSObjectIdentifiers.pbeWithSHAAnd2_KeyTripleDES_CBC);
            bouncyCastleFipsProvider.addAlias("Cipher", "PBEWITHSHAAND2-KEYDESEDE-CBC", "PBEWITHSHAAND2KEYTRIPLEDES");
            bouncyCastleFipsProvider.addAlias("Alg.Alias.Cipher.PBEWITHSHA1ANDDESEDE-CBC", "PBEWITHSHAAND3-KEYDESEDE-CBC");
            bouncyCastleFipsProvider.addAlias("Alg.Alias.Cipher.PBEWITHSHAAND3-KEYTRIPLEDES-CBC", "PBEWITHSHAAND3-KEYDESEDE-CBC");
            bouncyCastleFipsProvider.addAlias("Alg.Alias.Cipher.PBEWITHSHAAND2-KEYTRIPLEDES-CBC", "PBEWITHSHAAND2-KEYDESEDE-CBC");
            bouncyCastleFipsProvider.addAlias("Alg.Alias.Cipher.PBEWITHSHA1AND3-KEYTRIPLEDES-CBC", "PBEWITHSHAAND3-KEYDESEDE-CBC");
            bouncyCastleFipsProvider.addAlias("Alg.Alias.Cipher.PBEWITHSHA1AND2-KEYTRIPLEDES-CBC", "PBEWITHSHAAND2-KEYDESEDE-CBC");
        }
        bouncyCastleFipsProvider.addAlgorithmImplementation("KeyGenerator.DESEDE", PREFIX + "$KeyGenerator", new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseKeyGenerator(bouncyCastleFipsProvider, "DESede", 168, new KeyGeneratorCreator(){

                    public SymmetricKeyGenerator createInstance(int n2, SecureRandom secureRandom) {
                        return new FipsTripleDES.KeyGenerator(n2, secureRandom);
                    }
                });
            }
        });
        bouncyCastleFipsProvider.addAlias("KeyGenerator", "DESEDE", "TRIPLEDES");
        bouncyCastleFipsProvider.addAlias("KeyGenerator", "DESEDE", OIWObjectIdentifiers.desEDE);
        bouncyCastleFipsProvider.addAlgorithmImplementation("KeyGenerator", PKCSObjectIdentifiers.des_EDE3_CBC, PREFIX + "$KeyGenerator3", new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseKeyGenerator(bouncyCastleFipsProvider, "DESede", 168, true, new KeyGeneratorCreator(){

                    public SymmetricKeyGenerator createInstance(int n2, SecureRandom secureRandom) {
                        return new FipsTripleDES.KeyGenerator(FipsTripleDES.CBC, 168, secureRandom);
                    }
                });
            }
        });
        bouncyCastleFipsProvider.addAlgorithmImplementation("Mac.DESEDECMAC", PREFIX + "$CMAC", generalDesEdeAttributes, new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseMac(FipsTripleDES.CMAC, (MACOperatorFactory)new FipsTripleDES.MACOperatorFactory(), new AuthParametersCreator(FipsTripleDES.CMAC));
            }
        });
        bouncyCastleFipsProvider.addAlias("Mac", "DESEDECMAC", "DESEDE-CMAC");
        bouncyCastleFipsProvider.addAlgorithmImplementation("AlgorithmParameters.DESEDE", PREFIX + ".util.IvAlgorithmParameters", new EngineCreator(){

            public Object createInstance(Object object) {
                return new IvAlgorithmParameters();
            }
        });
        bouncyCastleFipsProvider.addAlias("AlgorithmParameters", "DESEDE", PKCSObjectIdentifiers.des_EDE3_CBC);
        bouncyCastleFipsProvider.addAlgorithmImplementation("AlgorithmParameterGenerator", PKCSObjectIdentifiers.des_EDE3_CBC, PREFIX + "$AlgParamGen", new EngineCreator(){

            public Object createInstance(Object object) {
                return new IVAlgorithmParameterGenerator(bouncyCastleFipsProvider, "DESede", 8);
            }
        });
        bouncyCastleFipsProvider.addAlgorithmImplementation("SecretKeyFactory.DESEDE", PREFIX + "$KeyFactory", new EngineCreator(){

            public Object createInstance(Object object) {
                return new KeyFactory();
            }
        });
        bouncyCastleFipsProvider.addAlias("SecretKeyFactory", "DESEDE", "TDEA", "TRIPLEDES");
        bouncyCastleFipsProvider.addAlias("Cipher", "DESEDE", "TDEA");
        bouncyCastleFipsProvider.addAlias("Cipher", "DESEDEWRAP", "TDEAWRAP");
        bouncyCastleFipsProvider.addAlias("KeyGenerator", "DESEDE", "TDEA");
        bouncyCastleFipsProvider.addAlias("AlgorithmParameters", "DESEDE", "TDEA");
        if (!CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            bouncyCastleFipsProvider.addAlgorithmImplementation("Mac.DESEDEMAC", PREFIX + "$CBCMAC", generalDesEdeAttributes, (EngineCreator)new GuardedEngineCreator(new EngineCreator(){

                public Object createInstance(Object object) {
                    return new BaseMac(TripleDES.CBC_MAC, (MACOperatorFactory)new TripleDES.MACOperatorFactory(), new AuthParametersCreator(TripleDES.CBC_MAC));
                }
            }));
            bouncyCastleFipsProvider.addAlias("Alg.Alias.Mac.DESEDE", "DESEDEMAC");
            bouncyCastleFipsProvider.addAlgorithmImplementation("Mac.DESEDEMAC/CFB8", PREFIX + "$DESedeCFB8", generalDesEdeAttributes, (EngineCreator)new GuardedEngineCreator(new EngineCreator(){

                public Object createInstance(Object object) {
                    return new BaseMac(TripleDES.CFB8_MAC, (MACOperatorFactory)new TripleDES.MACOperatorFactory(), new AuthParametersCreator(TripleDES.CFB8_MAC));
                }
            }));
            bouncyCastleFipsProvider.addAlias("Mac", "DESEDEMAC/CFB8", "DESEDE/CFB8");
            bouncyCastleFipsProvider.addAlgorithmImplementation("Mac.DESEDEMAC64", PREFIX + "$DESede64", generalDesEdeAttributes, (EngineCreator)new GuardedEngineCreator(new EngineCreator(){

                public Object createInstance(Object object) {
                    return new BaseMac(TripleDES.CBC_MAC, (MACOperatorFactory)new TripleDES.MACOperatorFactory(), new MacParametersCreator(){

                        public AuthenticationParameters getBaseParameters() {
                            return TripleDES.CBC_MAC.withMACSize(64);
                        }

                        public AuthenticationParameters createParameters(boolean bl2, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
                            return TripleDES.CBC_MAC.withMACSize(64);
                        }
                    });
                }
            }));
            bouncyCastleFipsProvider.addAlias("Mac", "DESEDEMAC64", "DESEDE64");
            bouncyCastleFipsProvider.addAlgorithmImplementation("Mac.DESEDEMAC64WITHISO7816-4PADDING", PREFIX + "$DESede64with7816d4", generalDesEdeAttributes, (EngineCreator)new GuardedEngineCreator(new EngineCreator(){

                public Object createInstance(Object object) {
                    return new BaseMac(TripleDES.CBC_MACwithISO7816_4, (MACOperatorFactory)new TripleDES.MACOperatorFactory(), new MacParametersCreator(){

                        public AuthenticationParameters getBaseParameters() {
                            return TripleDES.CBC_MACwithISO7816_4.withMACSize(64);
                        }

                        public AuthenticationParameters createParameters(boolean bl2, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
                            return TripleDES.CBC_MACwithISO7816_4.withMACSize(64);
                        }
                    });
                }
            }));
            bouncyCastleFipsProvider.addAlias("Mac", "DESEDEMAC64WITHISO7816-4PADDING", "DESEDE64WITHISO7816-4PADDING");
            bouncyCastleFipsProvider.addAlias("Mac", "DESEDEMAC64WITHISO7816-4PADDING", "DESEDEISO9797ALG1MACWITHISO7816-4PADDING");
            bouncyCastleFipsProvider.addAlias("Mac", "DESEDEMAC64WITHISO7816-4PADDING", "DESEDEISO9797ALG1WITHISO7816-4PADDING");
            bouncyCastleFipsProvider.addAlgorithmImplementation("SecretKeyFactory.PBEWITHSHAAND2-KEYTRIPLEDES", PREFIX + "$PBEWithSHAAndDES2KeyFactory", new GuardedEngineCreator(new EngineCreator(){

                public Object createInstance(Object object) {
                    return new ProvPKCS12.KeyFactory("DESede", PasswordBasedDeriver.KeyType.CIPHER, 128);
                }
            }));
            bouncyCastleFipsProvider.addAlias("SecretKeyFactory", "PBEWITHSHAAND2-KEYTRIPLEDES", "PBEWITHSHA1AND2-KEYTRIPLEDES", "PBEWITHSHA-1AND2-KEYTRIPLEDES", "PBEWITHSHAAND2-KEYDESEDE", "PBEWITHSHA1AND2-KEYDESEDE", "PBEWITHSHA-1AND2-KEYDESEDE");
            bouncyCastleFipsProvider.addAlgorithmImplementation("SecretKeyFactory.PBEWITHSHAAND3-KEYTRIPLEDES", PREFIX + "$PBEWithSHAAndDES3KeyFactory", new GuardedEngineCreator(new EngineCreator(){

                public Object createInstance(Object object) {
                    return new ProvPKCS12.KeyFactory("DESede", PasswordBasedDeriver.KeyType.CIPHER, 192);
                }
            }));
            bouncyCastleFipsProvider.addAlias("SecretKeyFactory", "PBEWITHSHAAND3-KEYTRIPLEDES", "PBEWITHSHA1AND3-KEYTRIPLEDES", "PBEWITHSHA-1AND3-KEYTRIPLEDES", "PBEWITHSHAAND3-KEYDESEDE", "PBEWITHSHA1AND3-KEYDESEDE", "PBEWITHSHA-1AND3-KEYDESEDE", "PBEWITHSHA1ANDDESEDE");
            bouncyCastleFipsProvider.addAlias("SecretKeyFactory", "DESEDE", OIWObjectIdentifiers.desEDE);
            bouncyCastleFipsProvider.addAlias("AlgorithmParameters", "PBKDF-PKCS12", PKCSObjectIdentifiers.pbeWithSHAAnd2_KeyTripleDES_CBC, PKCSObjectIdentifiers.pbeWithSHAAnd3_KeyTripleDES_CBC);
        }
    }

    static {
        generalDesEdeAttributes.put("SupportedKeyClasses", "javax.crypto.SecretKey");
        generalDesEdeAttributes.put("SupportedKeyFormats", "RAW");
        PREFIX = ProvDESede.class.getName() + ".";
    }

    static class KeyFactory
    extends BaseSecretKeyFactory {
        KeyFactory() {
            super("DESede", FipsTripleDES.ALGORITHM, new BaseSecretKeyFactory.Validator(){

                public byte[] validated(byte[] byArray) throws InvalidKeySpecException {
                    int n2 = byArray.length * 8;
                    if (n2 != 128 && n2 != 192) {
                        throw new InvalidKeySpecException("Provided key data wrong size for DESede");
                    }
                    DesParameters.setOddParity(byArray);
                    return byArray;
                }
            });
        }

        protected KeySpec engineGetKeySpec(SecretKey secretKey, Class clazz) throws InvalidKeySpecException {
            if (clazz == null) {
                throw new InvalidKeySpecException("keySpec parameter is null");
            }
            if (secretKey == null) {
                throw new InvalidKeySpecException("key parameter is null");
            }
            if (DESedeKeySpec.class.isAssignableFrom(clazz)) {
                byte[] byArray = secretKey.getEncoded();
                try {
                    if (byArray.length == 16) {
                        byte[] byArray2 = new byte[24];
                        System.arraycopy(byArray, 0, byArray2, 0, 16);
                        System.arraycopy(byArray, 0, byArray2, 16, 8);
                        return new DESedeKeySpec(byArray2);
                    }
                    return new DESedeKeySpec(this.validator.validated(byArray));
                }
                catch (Exception exception) {
                    throw new InvalidKeySpecException(exception.getMessage(), exception);
                }
            }
            return super.engineGetKeySpec(secretKey, clazz);
        }

        protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
            if (keySpec instanceof DESedeKeySpec) {
                DESedeKeySpec dESedeKeySpec = (DESedeKeySpec)keySpec;
                return new ProvSecretKeySpec(new ValidatedSymmetricKey(FipsTripleDES.ALGORITHM, this.validator.validated(dESedeKeySpec.getKey())));
            }
            return super.engineGenerateSecret(keySpec);
        }
    }
}

