/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.jcajce.provider;

import com.aspose.html.internal.ms.core.bc.asn1.ASN1ObjectIdentifier;
import com.aspose.html.internal.ms.core.bc.asn1.oiw.OIWObjectIdentifiers;
import com.aspose.html.internal.ms.core.bc.asn1.pkcs.PKCSObjectIdentifiers;
import com.aspose.html.internal.ms.core.bc.crypto.AuthenticationParameters;
import com.aspose.html.internal.ms.core.bc.crypto.AuthenticationParametersWithIV;
import com.aspose.html.internal.ms.core.bc.crypto.MACOperatorFactory;
import com.aspose.html.internal.ms.core.bc.crypto.Parameters;
import com.aspose.html.internal.ms.core.bc.crypto.ParametersWithIV;
import com.aspose.html.internal.ms.core.bc.crypto.PasswordConverter;
import com.aspose.html.internal.ms.core.bc.crypto.SymmetricKeyGenerator;
import com.aspose.html.internal.ms.core.bc.crypto.fips.FipsSHS;
import com.aspose.html.internal.ms.core.bc.crypto.general.DES;
import com.aspose.html.internal.ms.core.bc.crypto.general.SecureHash;
import com.aspose.html.internal.ms.core.bc.crypto.internal.ValidatedSymmetricKey;
import com.aspose.html.internal.ms.core.bc.crypto.internal.params.DesParameters;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.AlgorithmProvider;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.AuthParametersCreator;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.BaseCipher;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.BaseKeyGenerator;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.BaseMac;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.BaseSecretKeyFactory;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.BouncyCastleFipsProvider;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.EngineCreator;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.GuardedEngineCreator;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.IVAlgorithmParameterGenerator;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.IvAlgorithmParameters;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.IvParametersCreator;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.KeyGeneratorCreator;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.MacParametersCreator;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.PBEScheme;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.ParametersCreator;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.ParametersCreatorProvider;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.ProvPBEPBKDF1;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.ProvSecretKeySpec;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.Utils;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.SecretKey;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.IvParameterSpec;

final class ProvDES
extends AlgorithmProvider {
    private static final String PREFIX = ProvDES.class.getName();
    private Class[] availableSpecs = new Class[]{IvParameterSpec.class};
    private ParametersCreatorProvider<Parameters> generalParametersCreatorProvider = new ParametersCreatorProvider<Parameters>(){

        @Override
        public ParametersCreator get(Parameters parameters) {
            if (Utils.isAuthMode(parameters.getAlgorithm())) {
                return new AuthParametersCreator((AuthenticationParametersWithIV)parameters);
            }
            return new IvParametersCreator((ParametersWithIV)parameters);
        }
    };

    ProvDES() {
    }

    public void configure(final BouncyCastleFipsProvider bouncyCastleFipsProvider) {
        bouncyCastleFipsProvider.addAlgorithmImplementation("Cipher.DES", PREFIX + "$ECB", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseCipher.Builder(bouncyCastleFipsProvider, 64, DES.ECBwithPKCS7, DES.ECB, DES.ECBwithISO10126_2, DES.ECBwithISO7816_4, DES.ECBwithTBC, DES.ECBwithX923, DES.CBC, DES.CBCwithPKCS7, DES.CBCwithISO10126_2, DES.CBCwithISO7816_4, DES.CBCwithTBC, DES.CBCwithX923, DES.CBCwithCS1, DES.CBCwithCS2, DES.CBCwithCS3, DES.CFB64, DES.CFB8, DES.OFB, DES.OpenPGPCFB, DES.CTR, DES.EAX).withFixedKeySize(64).withGeneralOperators(ProvDES.this.generalParametersCreatorProvider, new DES.OperatorFactory(), new DES.AEADOperatorFactory()).withParameters(ProvDES.this.availableSpecs).build();
            }
        }));
        bouncyCastleFipsProvider.addAlgorithmImplementation("Cipher", OIWObjectIdentifiers.desCBC, PREFIX + "$CBC", (EngineCreator)new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseCipher.Builder(bouncyCastleFipsProvider, 64, DES.CBCwithPKCS7).withFixedKeySize(64).withGeneralOperators(ProvDES.this.generalParametersCreatorProvider, new DES.OperatorFactory(), null).withParameters(ProvDES.this.availableSpecs).build();
            }
        }));
        bouncyCastleFipsProvider.addAlgorithmImplementation("KeyGenerator.DES", PREFIX + "$KeyGenerator", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseKeyGenerator(bouncyCastleFipsProvider, "DES", 56, true, new KeyGeneratorCreator(){

                    public SymmetricKeyGenerator createInstance(int n2, SecureRandom secureRandom) {
                        return new DES.KeyGenerator(secureRandom);
                    }
                });
            }
        }));
        bouncyCastleFipsProvider.addAlias("KeyGenerator", "DES", "DEA");
        bouncyCastleFipsProvider.addAlgorithmImplementation("SecretKeyFactory.DES", PREFIX + "$KeyFactory", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new KeyFactory();
            }
        }));
        bouncyCastleFipsProvider.addAlias("SecretKeyFactory", "DES", "DEA");
        bouncyCastleFipsProvider.addAlgorithmImplementation("Mac.DESCMAC", PREFIX + "$CMAC", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseMac(DES.CMAC, (MACOperatorFactory)new DES.MACOperatorFactory(), new AuthParametersCreator(DES.CMAC));
            }
        }));
        bouncyCastleFipsProvider.addAlgorithmImplementation("Mac.DESMAC", PREFIX + "$CBCMAC", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseMac(DES.CBC_MAC, (MACOperatorFactory)new DES.MACOperatorFactory(), new AuthParametersCreator(DES.CBC_MAC));
            }
        }));
        bouncyCastleFipsProvider.addAlias("Alg.Alias.Mac.DES", "DESMAC");
        bouncyCastleFipsProvider.addAlgorithmImplementation("Mac.DESMAC/CFB8", PREFIX + "$DESCFB8", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseMac(DES.CFB8_MAC, (MACOperatorFactory)new DES.MACOperatorFactory(), new AuthParametersCreator(DES.CFB8_MAC));
            }
        }));
        bouncyCastleFipsProvider.addAlias("Alg.Alias.Mac.DES/CFB8", "DESMAC/CFB8");
        bouncyCastleFipsProvider.addAlgorithmImplementation("Mac.DESMAC64", PREFIX + "$DES64", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseMac(DES.CBC_MAC, (MACOperatorFactory)new DES.MACOperatorFactory(), new MacParametersCreator(){

                    public AuthenticationParameters getBaseParameters() {
                        return DES.CBC_MAC.withMACSize(64);
                    }

                    public AuthenticationParameters createParameters(boolean bl2, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
                        return DES.CBC_MAC.withMACSize(64);
                    }
                });
            }
        }));
        bouncyCastleFipsProvider.addAlias("Alg.Alias.Mac.DES64", "DESMAC64");
        bouncyCastleFipsProvider.addAlgorithmImplementation("Mac.DESMAC64WITHISO7816-4PADDING", PREFIX + "$DES64with7816d4", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseMac(DES.CBC_MACwithISO7816_4, (MACOperatorFactory)new DES.MACOperatorFactory(), new MacParametersCreator(){

                    public AuthenticationParameters getBaseParameters() {
                        return DES.CBC_MACwithISO7816_4.withMACSize(64);
                    }

                    public AuthenticationParameters createParameters(boolean bl2, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
                        return DES.CBC_MACwithISO7816_4.withMACSize(64);
                    }
                });
            }
        }));
        bouncyCastleFipsProvider.addAlias("Mac", "DESMAC64WITHISO7816-4PADDING", "DES64WITHISO7816-4PADDING");
        bouncyCastleFipsProvider.addAlias("Mac", "DESMAC64WITHISO7816-4PADDING", "DESISO9797ALG1MACWITHISO7816-4PADDING");
        bouncyCastleFipsProvider.addAlias("Mac", "DESMAC64WITHISO7816-4PADDING", "DESISO9797ALG1WITHISO7816-4PADDING");
        bouncyCastleFipsProvider.addAlgorithmImplementation("Mac.DESWITHISO9797", PREFIX + "$DES9797Alg3", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseMac(DES.ISO9797alg3Mac, (MACOperatorFactory)new DES.MACOperatorFactory(), new MacParametersCreator(){

                    public AuthenticationParameters getBaseParameters() {
                        return DES.ISO9797alg3Mac;
                    }

                    public AuthenticationParameters createParameters(boolean bl2, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
                        return DES.ISO9797alg3Mac;
                    }
                });
            }
        }));
        bouncyCastleFipsProvider.addAlias("Mac", "DESWITHISO9797", "DESISO9797MAC", "ISO9797ALG3", "ISO9797ALG3MAC");
        bouncyCastleFipsProvider.addAlgorithmImplementation("Mac.ISO9797ALG3WITHISO7816-4PADDING", PREFIX + "$DES9797Alg3with7816d4", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseMac(DES.ISO9797alg3MACwithISO7816_4, (MACOperatorFactory)new DES.MACOperatorFactory(), new MacParametersCreator(){

                    public AuthenticationParameters getBaseParameters() {
                        return DES.ISO9797alg3MACwithISO7816_4.withMACSize(64);
                    }

                    public AuthenticationParameters createParameters(boolean bl2, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
                        return DES.ISO9797alg3MACwithISO7816_4.withMACSize(64);
                    }
                });
            }
        }));
        bouncyCastleFipsProvider.addAlias("Alg.Alias.Mac.ISO9797ALG3MACWITHISO7816-4PADDING", "ISO9797ALG3WITHISO7816-4PADDING");
        bouncyCastleFipsProvider.addAlgorithmImplementation("AlgorithmParameters.DES", PREFIX + ".util.IvAlgorithmParameters", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new IvAlgorithmParameters();
            }
        }));
        bouncyCastleFipsProvider.addAlias("AlgorithmParameters", "DES", OIWObjectIdentifiers.desCBC);
        bouncyCastleFipsProvider.addAlgorithmImplementation("AlgorithmParameterGenerator", OIWObjectIdentifiers.desCBC, PREFIX + "$AlgParamGen", (EngineCreator)new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new IVAlgorithmParameterGenerator(bouncyCastleFipsProvider, "DES", 8);
            }
        }));
        bouncyCastleFipsProvider.addAlgorithmImplementation("Cipher.PBEWITHMD5ANDDES-CBC", PREFIX + "$PBEWithMD5", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseCipher.Builder(bouncyCastleFipsProvider, 64, DES.CBCwithPKCS7).withGeneralOperators(ProvDES.this.generalParametersCreatorProvider, new DES.OperatorFactory(), null).withFixedKeySize(64).withScheme(PBEScheme.PBKDF1).withPrf(SecureHash.Algorithm.MD5).withParameters(ProvDES.this.availableSpecs).build();
            }
        }));
        bouncyCastleFipsProvider.addAlgorithmImplementation("Cipher.PBEWITHSHA1ANDDES-CBC", PREFIX + "$PBEWithSHA1", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseCipher.Builder(bouncyCastleFipsProvider, 64, DES.CBCwithPKCS7).withGeneralOperators(ProvDES.this.generalParametersCreatorProvider, new DES.OperatorFactory(), null).withFixedKeySize(64).withScheme(PBEScheme.PBKDF1).withPrf(FipsSHS.Algorithm.SHA1).withParameters(ProvDES.this.availableSpecs).build();
            }
        }));
        bouncyCastleFipsProvider.addAlias("Cipher", "PBEWITHMD5ANDDES-CBC", "PBEWITHMD5ANDDES");
        bouncyCastleFipsProvider.addAlias("Cipher", "PBEWITHSHA1ANDDES-CBC", "PBEWITHSHA1ANDDES");
        bouncyCastleFipsProvider.addAlias("Cipher", "PBEWITHMD5ANDDES-CBC", PKCSObjectIdentifiers.pbeWithMD5AndDES_CBC);
        bouncyCastleFipsProvider.addAlias("Cipher", "PBEWITHSHA1ANDDES-CBC", PKCSObjectIdentifiers.pbeWithSHA1AndDES_CBC);
        bouncyCastleFipsProvider.addAlgorithmImplementation("SecretKeyFactory.PBEWITHSHAANDDES", PREFIX + "PBESHADES", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new ProvPBEPBKDF1.FixedPBKDF1("DES", PasswordConverter.ASCII, FipsSHS.Algorithm.SHA1, 64);
            }
        }));
        bouncyCastleFipsProvider.addAlias("SecretKeyFactory", "PBEWITHSHAANDDES", "PBEWITHSHA1ANDDES", "PBEWITHSHA-1ANDDES");
        bouncyCastleFipsProvider.addAlgorithmImplementation("SecretKeyFactory.PBEWITHMD5ANDDES", PREFIX + "PBEMD5DES", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new ProvPBEPBKDF1.FixedPBKDF1("DES", PasswordConverter.ASCII, SecureHash.Algorithm.MD5, 64);
            }
        }));
        this.addAlias(bouncyCastleFipsProvider, OIWObjectIdentifiers.desCBC, "DES");
    }

    private void addAlias(BouncyCastleFipsProvider bouncyCastleFipsProvider, ASN1ObjectIdentifier aSN1ObjectIdentifier, String string) {
        bouncyCastleFipsProvider.addAlias("KeyGenerator", string, aSN1ObjectIdentifier);
    }

    static class KeyFactory
    extends BaseSecretKeyFactory {
        KeyFactory() {
            super("DES", DES.ALGORITHM, new BaseSecretKeyFactory.Validator(){

                public byte[] validated(byte[] byArray) throws InvalidKeySpecException {
                    int n2 = byArray.length * 8;
                    if (n2 != 64) {
                        throw new InvalidKeySpecException("Provided key data wrong size for DES");
                    }
                    DesParameters.setOddParity(byArray);
                    return byArray;
                }
            });
        }

        protected KeySpec engineGetKeySpec(SecretKey secretKey, Class clazz) throws InvalidKeySpecException {
            if (clazz == null) {
                throw new InvalidKeySpecException("keySpec parameter is null");
            }
            if (secretKey == null) {
                throw new InvalidKeySpecException("key parameter is null");
            }
            if (DESKeySpec.class.isAssignableFrom(clazz)) {
                try {
                    return new DESKeySpec(this.validator.validated(secretKey.getEncoded()));
                }
                catch (InvalidKeyException invalidKeyException) {
                    throw new InvalidKeySpecException(invalidKeyException.getMessage(), invalidKeyException);
                }
            }
            return super.engineGetKeySpec(secretKey, clazz);
        }

        protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
            if (keySpec instanceof DESKeySpec) {
                DESKeySpec dESKeySpec = (DESKeySpec)keySpec;
                return new ProvSecretKeySpec(new ValidatedSymmetricKey(DES.ALGORITHM, this.validator.validated(dESKeySpec.getKey())));
            }
            return super.engineGenerateSecret(keySpec);
        }
    }
}

