/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.jcajce.provider;

import com.aspose.html.internal.ms.core.bc.crypto.asymmetric.AsymmetricEdDSAPublicKey;
import com.aspose.html.internal.ms.core.bc.crypto.asymmetric.AsymmetricXDHPublicKey;
import com.aspose.html.internal.ms.core.bc.crypto.asymmetric.DHDomainParameters;
import com.aspose.html.internal.ms.core.bc.crypto.asymmetric.DSADomainParameters;
import com.aspose.html.internal.ms.core.bc.crypto.asymmetric.ECDomainParameters;
import com.aspose.html.internal.ms.core.bc.crypto.asymmetric.GOST3410DomainParameters;
import com.aspose.html.internal.ms.core.bc.math.ec.ECCurve;
import com.aspose.html.internal.ms.core.bc.math.ec.ECPoint;
import com.aspose.html.internal.ms.core.bc.util.Arrays;
import com.aspose.html.internal.ms.core.bc.util.Fingerprint;
import com.aspose.html.internal.ms.core.bc.util.Strings;
import com.aspose.html.internal.ms.core.bc.util.encoders.Hex;
import java.math.BigInteger;
import javax.security.auth.Destroyable;

class KeyUtil {
    KeyUtil() {
    }

    static void checkDestroyed(Destroyable destroyable) {
        if (destroyable.isDestroyed()) {
            throw new IllegalStateException("key has been destroyed");
        }
    }

    static String generateFingerPrint(BigInteger bigInteger) {
        return new Fingerprint(bigInteger.toByteArray()).toString();
    }

    static String generateExponentFingerprint(BigInteger bigInteger) {
        return new Fingerprint(bigInteger.toByteArray(), 32).toString();
    }

    static String destroyedPrivateKeyToString(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = Strings.lineSeparator();
        stringBuilder.append(string).append(" Private Key [DESTROYED]").append(string2);
        return stringBuilder.toString();
    }

    static String privateKeyToString(String string, BigInteger bigInteger, DHDomainParameters dHDomainParameters) {
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = Strings.lineSeparator();
        BigInteger bigInteger2 = dHDomainParameters.getG().modPow(bigInteger, dHDomainParameters.getP());
        stringBuilder.append(string);
        stringBuilder.append(" Private Key [").append(KeyUtil.generateKeyFingerprint(bigInteger2, dHDomainParameters)).append("]").append(string2);
        stringBuilder.append("              Y: ").append(bigInteger2.toString(16)).append(string2);
        return stringBuilder.toString();
    }

    static String publicKeyToString(String string, BigInteger bigInteger, DHDomainParameters dHDomainParameters) {
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = Strings.lineSeparator();
        stringBuilder.append(string);
        stringBuilder.append(" Public Key [").append(KeyUtil.generateKeyFingerprint(bigInteger, dHDomainParameters)).append("]").append(string2);
        stringBuilder.append("             Y: ").append(bigInteger.toString(16)).append(string2);
        return stringBuilder.toString();
    }

    private static String generateKeyFingerprint(BigInteger bigInteger, DHDomainParameters dHDomainParameters) {
        return new Fingerprint(Arrays.concatenate(bigInteger.toByteArray(), dHDomainParameters.getP().toByteArray(), dHDomainParameters.getG().toByteArray())).toString();
    }

    static String privateKeyToString(String string, BigInteger bigInteger, DSADomainParameters dSADomainParameters) {
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = Strings.lineSeparator();
        BigInteger bigInteger2 = dSADomainParameters.getG().modPow(bigInteger, dSADomainParameters.getP());
        stringBuilder.append(string);
        stringBuilder.append(" Private Key [").append(KeyUtil.generateKeyFingerprint(bigInteger2, dSADomainParameters)).append("]").append(string2);
        stringBuilder.append("              Y: ").append(bigInteger2.toString(16)).append(string2);
        return stringBuilder.toString();
    }

    static String publicKeyToString(String string, BigInteger bigInteger, DSADomainParameters dSADomainParameters) {
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = Strings.lineSeparator();
        stringBuilder.append(string);
        stringBuilder.append(" Public Key [").append(KeyUtil.generateKeyFingerprint(bigInteger, dSADomainParameters)).append("]").append(string2);
        stringBuilder.append("             Y: ").append(bigInteger.toString(16)).append(string2);
        return stringBuilder.toString();
    }

    private static String generateKeyFingerprint(BigInteger bigInteger, DSADomainParameters dSADomainParameters) {
        return new Fingerprint(Arrays.concatenate(bigInteger.toByteArray(), dSADomainParameters.getP().toByteArray(), dSADomainParameters.getQ().toByteArray(), dSADomainParameters.getG().toByteArray())).toString();
    }

    static String privateKeyToString(String string, BigInteger bigInteger, GOST3410DomainParameters gOST3410DomainParameters) {
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = Strings.lineSeparator();
        BigInteger bigInteger2 = gOST3410DomainParameters.getA().modPow(bigInteger, gOST3410DomainParameters.getP());
        stringBuilder.append(string);
        stringBuilder.append(" Private Key [").append(KeyUtil.generateKeyFingerprint(bigInteger2, gOST3410DomainParameters)).append("]").append(string2);
        stringBuilder.append("                  Y: ").append(bigInteger2.toString(16)).append(string2);
        return stringBuilder.toString();
    }

    static String publicKeyToString(String string, BigInteger bigInteger, GOST3410DomainParameters gOST3410DomainParameters) {
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = Strings.lineSeparator();
        stringBuilder.append(string);
        stringBuilder.append(" Public Key [").append(KeyUtil.generateKeyFingerprint(bigInteger, gOST3410DomainParameters)).append("]").append(string2);
        stringBuilder.append("                 Y: ").append(bigInteger.toString(16)).append(string2);
        return stringBuilder.toString();
    }

    private static String generateKeyFingerprint(BigInteger bigInteger, GOST3410DomainParameters gOST3410DomainParameters) {
        return new Fingerprint(Arrays.concatenate(bigInteger.toByteArray(), gOST3410DomainParameters.getP().toByteArray(), gOST3410DomainParameters.getA().toByteArray())).toString();
    }

    static String publicKeyToString(String string, ECPoint eCPoint, ECDomainParameters eCDomainParameters) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = Strings.lineSeparator();
        stringBuffer.append(string);
        stringBuffer.append(" Public Key [").append(KeyUtil.generateKeyFingerprint(eCPoint, eCDomainParameters)).append("]").append(string2);
        stringBuffer.append("            X: ").append(eCPoint.getAffineXCoord().toBigInteger().toString(16)).append(string2);
        stringBuffer.append("            Y: ").append(eCPoint.getAffineYCoord().toBigInteger().toString(16)).append(string2);
        return stringBuffer.toString();
    }

    static String privateKeyToString(String string, BigInteger bigInteger, ECDomainParameters eCDomainParameters) {
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = Strings.lineSeparator();
        ECPoint eCPoint = KeyUtil.calculateQ(bigInteger, eCDomainParameters);
        stringBuilder.append(string);
        stringBuilder.append(" Private Key [").append(KeyUtil.generateKeyFingerprint(eCPoint, eCDomainParameters)).append("]").append(string2);
        stringBuilder.append("            X: ").append(eCPoint.getAffineXCoord().toBigInteger().toString(16)).append(string2);
        stringBuilder.append("            Y: ").append(eCPoint.getAffineYCoord().toBigInteger().toString(16)).append(string2);
        return stringBuilder.toString();
    }

    private static ECPoint calculateQ(BigInteger bigInteger, ECDomainParameters eCDomainParameters) {
        return eCDomainParameters.getG().multiply(bigInteger).normalize();
    }

    private static String generateKeyFingerprint(ECPoint eCPoint, ECDomainParameters eCDomainParameters) {
        ECCurve eCCurve = eCDomainParameters.getCurve();
        ECPoint eCPoint2 = eCDomainParameters.getG();
        if (eCCurve != null) {
            return new Fingerprint(Arrays.concatenate(eCPoint.getEncoded(false), eCCurve.getA().getEncoded(), eCCurve.getB().getEncoded(), eCPoint2.getEncoded(false))).toString();
        }
        return new Fingerprint(eCPoint.getEncoded(false)).toString();
    }

    static String restrictedToString(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = Strings.lineSeparator();
        stringBuilder.append(string);
        stringBuilder.append(" Private Key [RESTRICTED]").append(string2);
        return stringBuilder.toString();
    }

    static String keyToString(String string, String string2, AsymmetricEdDSAPublicKey asymmetricEdDSAPublicKey) {
        StringBuilder stringBuilder = new StringBuilder();
        String string3 = Strings.lineSeparator();
        byte[] byArray = asymmetricEdDSAPublicKey.getPublicData();
        stringBuilder.append(string2).append(" ").append(string).append(" [").append(new Fingerprint(byArray).toString()).append("]").append(string3).append("    public data: ").append(Hex.toHexString(byArray)).append(string3);
        return stringBuilder.toString();
    }

    static String keyToString(String string, String string2, AsymmetricXDHPublicKey asymmetricXDHPublicKey) {
        StringBuilder stringBuilder = new StringBuilder();
        String string3 = Strings.lineSeparator();
        byte[] byArray = asymmetricXDHPublicKey.getPublicData();
        stringBuilder.append(string2).append(" ").append(string).append(" [").append(new Fingerprint(byArray).toString()).append("]").append(string3).append("    public data: ").append(Hex.toHexString(byArray)).append(string3);
        return stringBuilder.toString();
    }
}

