/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.jcajce.provider;

import com.aspose.html.internal.ms.core.bc.asn1.DEROctetString;
import com.aspose.html.internal.ms.core.bc.asn1.cms.GCMParameters;
import com.aspose.html.internal.ms.core.bc.crypto.AEADOperatorFactory;
import com.aspose.html.internal.ms.core.bc.crypto.Algorithm;
import com.aspose.html.internal.ms.core.bc.crypto.AuthenticationParametersWithIV;
import com.aspose.html.internal.ms.core.bc.crypto.CryptoServicesRegistrar;
import com.aspose.html.internal.ms.core.bc.crypto.DigestAlgorithm;
import com.aspose.html.internal.ms.core.bc.crypto.IllegalKeyException;
import com.aspose.html.internal.ms.core.bc.crypto.OutputAEADDecryptor;
import com.aspose.html.internal.ms.core.bc.crypto.OutputAEADEncryptor;
import com.aspose.html.internal.ms.core.bc.crypto.OutputCipher;
import com.aspose.html.internal.ms.core.bc.crypto.OutputDecryptor;
import com.aspose.html.internal.ms.core.bc.crypto.OutputEncryptor;
import com.aspose.html.internal.ms.core.bc.crypto.Parameters;
import com.aspose.html.internal.ms.core.bc.crypto.ParametersWithIV;
import com.aspose.html.internal.ms.core.bc.crypto.PasswordBasedDeriver;
import com.aspose.html.internal.ms.core.bc.crypto.SymmetricKey;
import com.aspose.html.internal.ms.core.bc.crypto.SymmetricOperatorFactory;
import com.aspose.html.internal.ms.core.bc.crypto.UpdateOutputStream;
import com.aspose.html.internal.ms.core.bc.crypto.fips.FipsAEADOperatorFactory;
import com.aspose.html.internal.ms.core.bc.crypto.fips.FipsAlgorithm;
import com.aspose.html.internal.ms.core.bc.crypto.fips.FipsParameters;
import com.aspose.html.internal.ms.core.bc.crypto.fips.FipsSHS;
import com.aspose.html.internal.ms.core.bc.crypto.fips.FipsSymmetricOperatorFactory;
import com.aspose.html.internal.ms.core.bc.crypto.fips.FipsUnapprovedOperationError;
import com.aspose.html.internal.ms.core.bc.jcajce.PBKDF1Key;
import com.aspose.html.internal.ms.core.bc.jcajce.PBKDF2Key;
import com.aspose.html.internal.ms.core.bc.jcajce.PBKDFKey;
import com.aspose.html.internal.ms.core.bc.jcajce.PKCS12Key;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.BaseWrapCipher;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.BouncyCastleFipsProvider;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.ClassUtil;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.DataArrayOutputStream;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.PBEScheme;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.PBKDFPBEKey;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.ParametersCreator;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.ParametersCreatorProvider;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.ProvPBEPBKDF1;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.ProvPBEPBKDF2;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.ProvPKCS12;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.Utils;
import com.aspose.html.internal.ms.core.bc.jcajce.spec.AEADParameterSpec;
import com.aspose.html.internal.ms.core.bc.util.Strings;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.interfaces.PBEKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.SecretKeySpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BaseCipher
extends CipherSpi {
    private final BouncyCastleFipsProvider fipsProvider;
    private final FipsSymmetricOperatorFactory fipsFactory;
    private final SymmetricOperatorFactory generalFactory;
    private final FipsAEADOperatorFactory fipsAeadFactory;
    private final AEADOperatorFactory generalAeadFactory;
    private final int blockSizeInBits;
    private final int keySizeInBits;
    private final DigestAlgorithm prf;
    private final Class[] fipsAvailableSpecs;
    private final Class[] generalAvailableSpecs;
    private final ParametersCreatorProvider<FipsParameters> fipsParametersProvider;
    private final ParametersCreatorProvider<Parameters> generalParametersProvider;
    private final Algorithm[] algorithms;
    private final Map<Algorithm, Parameters> baseParametersMap;
    private final PBEScheme scheme;
    private Set<Algorithm> activeAlgorithmSet = new HashSet<Algorithm>();
    private PBEParameterSpec pbeSpec = null;
    private String pbeAlgorithm = null;
    private AlgorithmParameters engineParams = null;
    private String modeName = null;
    private OutputCipher<Parameters> cipher;
    private OutputEncryptor<Parameters> encryptor;
    private OutputDecryptor<Parameters> decryptor;
    private UpdateOutputStream aadStream;
    private UpdateOutputStream processingStream;
    private DataArrayOutputStream resultStream = new DataArrayOutputStream();
    private byte[] associatedData = null;

    private BaseCipher(BouncyCastleFipsProvider bouncyCastleFipsProvider, int n2, int n3, DigestAlgorithm digestAlgorithm, PBEScheme pBEScheme, FipsSymmetricOperatorFactory fipsSymmetricOperatorFactory, SymmetricOperatorFactory symmetricOperatorFactory, FipsAEADOperatorFactory fipsAEADOperatorFactory, AEADOperatorFactory aEADOperatorFactory, Class[] classArray, ParametersCreatorProvider parametersCreatorProvider, ParametersCreatorProvider parametersCreatorProvider2, Map<Algorithm, Parameters> map, Algorithm ... algorithmArray) {
        this.fipsProvider = bouncyCastleFipsProvider;
        this.keySizeInBits = n3;
        this.prf = digestAlgorithm;
        this.scheme = pBEScheme;
        this.fipsFactory = fipsSymmetricOperatorFactory;
        this.generalFactory = symmetricOperatorFactory;
        this.fipsAeadFactory = fipsAEADOperatorFactory;
        this.generalAeadFactory = aEADOperatorFactory;
        this.blockSizeInBits = n2;
        this.fipsAvailableSpecs = classArray;
        this.generalAvailableSpecs = classArray;
        this.fipsParametersProvider = parametersCreatorProvider;
        this.generalParametersProvider = parametersCreatorProvider2;
        this.baseParametersMap = map;
        this.algorithms = algorithmArray;
        this.activeAlgorithmSet.addAll(Arrays.asList(algorithmArray));
    }

    @Override
    protected int engineGetBlockSize() {
        return (this.blockSizeInBits + 7) / 8;
    }

    @Override
    protected byte[] engineGetIV() {
        Parameters parameters = this.cipher.getParameters();
        if (parameters instanceof ParametersWithIV) {
            return ((ParametersWithIV)parameters).getIV();
        }
        return null;
    }

    @Override
    protected int engineGetKeySize(Key key) {
        return key.getEncoded().length * 8;
    }

    @Override
    protected int engineGetOutputSize(int n2) {
        return this.cipher.getMaxOutputSize(n2);
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        if (this.engineParams == null && this.cipher != null) {
            ParametersWithIV parametersWithIV;
            Parameters parameters = this.cipher.getParameters();
            String string = Utils.getBaseName(parameters.getAlgorithm());
            if (parameters instanceof AuthenticationParametersWithIV) {
                try {
                    AuthenticationParametersWithIV authenticationParametersWithIV = (AuthenticationParametersWithIV)parameters;
                    this.engineParams = AlgorithmParameters.getInstance(string, this.fipsProvider);
                    this.engineParams.init(new GCMParameters(authenticationParametersWithIV.getIV(), authenticationParametersWithIV.getMACSizeInBits() / 8).getEncoded());
                }
                catch (Exception exception) {
                    throw new IllegalStateException(exception.toString(), exception);
                }
            }
            if (parameters instanceof ParametersWithIV && (parametersWithIV = (ParametersWithIV)parameters).getIV() != null) {
                try {
                    this.engineParams = AlgorithmParameters.getInstance(string, this.fipsProvider);
                    this.engineParams.init(new DEROctetString(parametersWithIV.getIV()).getEncoded());
                }
                catch (Exception exception) {
                    throw new IllegalStateException(exception.toString(), exception);
                }
            }
            if (this.pbeSpec != null) {
                try {
                    this.engineParams = AlgorithmParameters.getInstance(this.pbeAlgorithm, this.fipsProvider);
                    this.engineParams.init(this.pbeSpec);
                }
                catch (Exception exception) {
                    return null;
                }
            }
        }
        return this.engineParams;
    }

    @Override
    protected void engineSetMode(String string) throws NoSuchAlgorithmException {
        String string2;
        String string3;
        this.modeName = Strings.toUpperCase(string);
        if (this.modeName.equals("CTS")) {
            this.modeName = "CBC/CS3";
        }
        if (this.modeName.equals("SIC")) {
            string3 = "/CTR";
            string2 = "/CTR/";
        } else if (this.modeName.equals("CFB") || this.modeName.equals("OFB")) {
            string3 = "/" + this.modeName + Integer.toString(this.blockSizeInBits);
            string2 = "/" + this.modeName + Integer.toString(this.blockSizeInBits) + "/";
        } else {
            string3 = "/" + this.modeName;
            string2 = "/" + this.modeName + "/";
        }
        HashSet<Algorithm> hashSet = new HashSet<Algorithm>(this.activeAlgorithmSet);
        this.activeAlgorithmSet.clear();
        for (Algorithm algorithm : hashSet) {
            if (!algorithm.getName().endsWith(string3) && !algorithm.getName().contains(string2)) continue;
            this.activeAlgorithmSet.add(algorithm);
        }
        if (this.activeAlgorithmSet.isEmpty()) {
            throw new NoSuchAlgorithmException(this.modeName + " not found");
        }
    }

    @Override
    protected void engineSetPadding(String string) throws NoSuchPaddingException {
        String string2 = Strings.toUpperCase(string);
        HashSet<Algorithm> hashSet = new HashSet<Algorithm>(this.activeAlgorithmSet);
        this.activeAlgorithmSet.clear();
        if (string2.equals("NOPADDING")) {
            for (Algorithm algorithm : hashSet) {
                if (algorithm.getName().indexOf(47) != algorithm.getName().lastIndexOf(47)) continue;
                this.activeAlgorithmSet.add(algorithm);
            }
            if (this.activeAlgorithmSet.isEmpty() && hashSet.size() == 1) {
                for (Algorithm algorithm : hashSet) {
                    if (!algorithm.getName().endsWith("CS3")) continue;
                    this.activeAlgorithmSet.add(algorithm);
                }
            }
        } else if (string2.equals("PKCS5PADDING") || string2.equals("PKCS7PADDING")) {
            for (Algorithm algorithm : hashSet) {
                if (!algorithm.getName().endsWith("PKCS7")) continue;
                this.activeAlgorithmSet.add(algorithm);
            }
        } else if (string2.equals("ISO10126PADDING") || string2.equals("ISO10126-2PADDING")) {
            for (Algorithm algorithm : hashSet) {
                if (!algorithm.getName().endsWith("ISO10126-2")) continue;
                this.activeAlgorithmSet.add(algorithm);
            }
        } else if (string2.equals("X9.23PADDING") || string2.equals("X923PADDING")) {
            for (Algorithm algorithm : hashSet) {
                if (!algorithm.getName().endsWith("X9.23")) continue;
                this.activeAlgorithmSet.add(algorithm);
            }
        } else if (string2.equals("ISO7816-4PADDING") || string2.equals("ISO9797-1PADDING")) {
            for (Algorithm algorithm : hashSet) {
                if (!algorithm.getName().endsWith("ISO7816-4")) continue;
                this.activeAlgorithmSet.add(algorithm);
            }
        } else if (string2.equals("TBCPADDING")) {
            for (Algorithm algorithm : hashSet) {
                if (!algorithm.getName().endsWith("TBC")) continue;
                this.activeAlgorithmSet.add(algorithm);
            }
        } else if (string2.equals("CTSPADDING") || string2.equals("CS3PADDING")) {
            for (Algorithm algorithm : hashSet) {
                if (!algorithm.getName().endsWith("CS3")) continue;
                this.activeAlgorithmSet.add(algorithm);
            }
        } else if (string2.equals("CS1PADDING")) {
            for (Algorithm algorithm : hashSet) {
                if (!algorithm.getName().endsWith("CS1")) continue;
                this.activeAlgorithmSet.add(algorithm);
            }
        } else if (string2.equals("CS2PADDING")) {
            for (Algorithm algorithm : hashSet) {
                if (!algorithm.getName().endsWith("CS2")) continue;
                this.activeAlgorithmSet.add(algorithm);
            }
        } else {
            throw new NoSuchPaddingException("Padding " + string + " unknown");
        }
        if (this.activeAlgorithmSet.isEmpty()) {
            throw new NoSuchPaddingException(string2 + " not found");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void engineInit(int n2, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        Object t2;
        Object object;
        boolean bl2;
        AEADOperatorFactory aEADOperatorFactory;
        SymmetricOperatorFactory symmetricOperatorFactory;
        ParametersCreator parametersCreator;
        Algorithm algorithm;
        this.pbeAlgorithm = null;
        this.engineParams = null;
        if (!(key instanceof SecretKey)) {
            throw new InvalidKeyException("Key for algorithm " + key.getAlgorithm() + " not suitable for symmetric enryption.");
        }
        if (secureRandom == null) {
            secureRandom = this.fipsProvider.getDefaultSecureRandom();
        }
        if ((algorithm = this.getAlgorithm()) instanceof FipsAlgorithm) {
            parametersCreator = this.fipsParametersProvider.get((FipsParameters)this.baseParametersMap.get(algorithm));
            symmetricOperatorFactory = this.fipsFactory;
            aEADOperatorFactory = this.fipsAeadFactory;
        } else {
            if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
                throw new FipsUnapprovedOperationError("Cipher cannot be used in approved mode");
            }
            parametersCreator = this.generalParametersProvider.get(this.baseParametersMap.get(algorithm));
            symmetricOperatorFactory = this.generalFactory;
            aEADOperatorFactory = this.generalAeadFactory;
        }
        switch (n2) {
            case 1: 
            case 3: {
                bl2 = true;
                break;
            }
            case 2: 
            case 4: {
                bl2 = false;
                break;
            }
            default: {
                throw new InvalidParameterException("unknown opmode " + n2 + " passed");
            }
        }
        if (key instanceof PBEKey && !(key instanceof PBKDFPBEKey) || this.scheme != null || algorithmParameterSpec instanceof PBEParameterSpec) {
            SecretKey secretKey;
            if (algorithmParameterSpec instanceof PBEParameterSpec) {
                object = (PBEParameterSpec)algorithmParameterSpec;
                this.pbeSpec = object;
            } else if (key instanceof PBEKey) {
                secretKey = (PBEKey)key;
                object = new PBEParameterSpec(secretKey.getSalt(), secretKey.getIterationCount());
                this.pbeSpec = object;
            } else {
                if (key instanceof PBEKey) throw new InvalidAlgorithmParameterException("No algorithm parameters provided when required");
                throw new InvalidKeyException("Algorithm requires a PBE key");
            }
            try {
                secretKey = (SecretKey)key;
            }
            catch (Exception exception) {
                throw new InvalidKeyException("Algorithm requires a PBE key");
            }
            if (this.keySizeInBits == 0) {
                throw new InvalidAlgorithmParameterException("Invalid algorithm parameter: cannot use PBE with variable key size");
            }
            if (key instanceof PBKDF2Key || this.scheme == PBEScheme.PBKDF2) {
                this.pbeAlgorithm = "PBKDF2";
                key = new SecretKeySpec(ProvPBEPBKDF2.getSecretKey(secretKey, (PBEParameterSpec)object, PasswordBasedDeriver.KeyType.CIPHER, this.keySizeInBits), algorithm.getName());
                try {
                    if (algorithm.requiresAlgorithmParameters()) {
                        if (algorithmParameterSpec == null) {
                            throw new InvalidKeyException("No algorithm parameters provided when required");
                        }
                        t2 = parametersCreator.createParameters(bl2, algorithmParameterSpec, secureRandom);
                    }
                    t2 = parametersCreator.createParameters(bl2, null, secureRandom);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new InvalidAlgorithmParameterException("Invalid algorithm parameter: " + illegalArgumentException.getMessage(), illegalArgumentException);
                }
            } else if (key instanceof PBKDF1Key || this.scheme == PBEScheme.PBKDF1) {
                this.pbeAlgorithm = "PBKDF1";
                if (algorithm.requiresAlgorithmParameters()) {
                    byte[][] byArray = ProvPBEPBKDF1.getSecretKeyAndIV(secretKey, (PBEParameterSpec)object, this.prf, PasswordBasedDeriver.KeyType.CIPHER, this.keySizeInBits, this.blockSizeInBits);
                    key = new SecretKeySpec(byArray[0], algorithm.getName());
                    try {
                        t2 = parametersCreator.createParameters(bl2, algorithmParameterSpec != null && !(algorithmParameterSpec instanceof PBEParameterSpec) ? algorithmParameterSpec : new IvParameterSpec(byArray[1]), secureRandom);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new InvalidAlgorithmParameterException("Invalid algorithm parameter: " + illegalArgumentException.getMessage(), illegalArgumentException);
                    }
                } else {
                    key = new SecretKeySpec(ProvPBEPBKDF1.getSecretKey(secretKey, (PBEParameterSpec)object, this.prf, PasswordBasedDeriver.KeyType.CIPHER, this.keySizeInBits), algorithm.getName());
                    try {
                        t2 = parametersCreator.createParameters(bl2, null, secureRandom);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new InvalidAlgorithmParameterException("Invalid algorithm parameter: " + illegalArgumentException.getMessage(), illegalArgumentException);
                    }
                }
            } else {
                if (!(key instanceof PKCS12Key) && this.scheme != PBEScheme.PKCS12) throw new InvalidKeyException("Unable to use passed in key for PBE");
                this.pbeAlgorithm = "PBKDF-PKCS12";
                if (algorithm.requiresAlgorithmParameters()) {
                    byte[][] byArray = ProvPKCS12.getSecretKeyAndIV(secretKey, this.prf, (PBEParameterSpec)object, PasswordBasedDeriver.KeyType.CIPHER, this.keySizeInBits, this.blockSizeInBits);
                    key = new SecretKeySpec(byArray[0], algorithm.getName());
                    try {
                        t2 = parametersCreator.createParameters(bl2, algorithmParameterSpec != null && !(algorithmParameterSpec instanceof PBEParameterSpec) ? algorithmParameterSpec : new IvParameterSpec(byArray[1]), secureRandom);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new InvalidAlgorithmParameterException("Invalid algorithm parameter: " + illegalArgumentException.getMessage(), illegalArgumentException);
                    }
                } else {
                    key = new SecretKeySpec(ProvPKCS12.getSecretKey(secretKey, (PBEParameterSpec)object, PasswordBasedDeriver.KeyType.CIPHER, this.keySizeInBits), algorithm.getName());
                    try {
                        t2 = parametersCreator.createParameters(bl2, null, secureRandom);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new InvalidAlgorithmParameterException("Invalid algorithm parameter: " + illegalArgumentException.getMessage(), illegalArgumentException);
                    }
                }
            }
        } else {
            if (key instanceof PBKDFKey) {
                throw new InvalidKeyException("PBE key requires a PBEParameterSpec");
            }
            if (!bl2 && algorithm.requiresAlgorithmParameters() && algorithmParameterSpec == null) {
                throw new InvalidAlgorithmParameterException("No algorithm parameters provided when required");
            }
            try {
                t2 = parametersCreator.createParameters(bl2, algorithmParameterSpec, secureRandom);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new InvalidAlgorithmParameterException("Invalid algorithm parameter: " + illegalArgumentException.getMessage(), illegalArgumentException);
            }
        }
        try {
            object = Utils.convertKey(algorithm, key);
            if (this.keySizeInBits != 0 && Utils.keyNotLength((SymmetricKey)object, this.keySizeInBits)) {
                throw new InvalidKeyException("Cipher requires key of size " + this.keySizeInBits + " bits");
            }
            if (BaseCipher.isAEADMode(algorithm)) {
                if (bl2) {
                    this.cipher = this.encryptor = (OutputEncryptor)Utils.addRandomIfNeeded(aEADOperatorFactory.createOutputAEADEncryptor((SymmetricKey)object, t2), secureRandom);
                    this.processingStream = this.encryptor.getEncryptingStream(this.resultStream);
                    this.aadStream = ((OutputAEADEncryptor)this.encryptor).getAADStream();
                } else {
                    this.cipher = this.decryptor = (OutputDecryptor)Utils.addRandomIfNeeded(aEADOperatorFactory.createOutputAEADDecryptor((SymmetricKey)object, t2), secureRandom);
                    this.processingStream = this.decryptor.getDecryptingStream(this.resultStream);
                    this.aadStream = ((OutputAEADDecryptor)this.decryptor).getAADStream();
                }
                if (!(algorithmParameterSpec instanceof AEADParameterSpec)) return;
                this.associatedData = ((AEADParameterSpec)algorithmParameterSpec).getAssociatedData();
                if (this.associatedData == null) return;
                this.aadStream.update(this.associatedData);
                return;
            } else if (bl2) {
                this.encryptor = Utils.addRandomIfNeeded(symmetricOperatorFactory.createOutputEncryptor((SymmetricKey)object, t2), secureRandom);
                this.cipher = this.encryptor;
                this.processingStream = this.encryptor.getEncryptingStream(this.resultStream);
                this.aadStream = null;
                return;
            } else {
                this.decryptor = Utils.addRandomIfNeeded(symmetricOperatorFactory.createOutputDecryptor((SymmetricKey)object, t2), secureRandom);
                this.cipher = this.decryptor;
                this.processingStream = this.decryptor.getDecryptingStream(this.resultStream);
                this.aadStream = null;
            }
            return;
        }
        catch (InvalidParameterException invalidParameterException) {
            throw invalidParameterException;
        }
        catch (InvalidKeyException invalidKeyException) {
            throw invalidKeyException;
        }
        catch (IllegalKeyException illegalKeyException) {
            throw new InvalidKeyException(illegalKeyException.getMessage(), illegalKeyException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidAlgorithmParameterException(illegalArgumentException.getMessage(), illegalArgumentException);
        }
        catch (Exception exception) {
            throw new InvalidKeyException(exception.getMessage(), exception);
        }
    }

    private Algorithm getAlgorithm() {
        Algorithm algorithm = this.activeAlgorithmSet.size() == 1 ? this.activeAlgorithmSet.iterator().next() : this.algorithms[0];
        return algorithm;
    }

    @Override
    protected void engineInit(int n2, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        AlgorithmParameterSpec algorithmParameterSpec = null;
        if (algorithmParameters != null) {
            Class[] classArray = this.getAlgorithm() instanceof FipsAlgorithm ? this.fipsAvailableSpecs : this.generalAvailableSpecs;
            for (int i2 = 0; i2 != classArray.length; ++i2) {
                if (classArray[i2] == null) continue;
                try {
                    algorithmParameterSpec = (AlgorithmParameterSpec)algorithmParameters.getParameterSpec(classArray[i2]);
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (algorithmParameterSpec == null) {
                throw new InvalidAlgorithmParameterException("can't handle parameter " + algorithmParameters.toString());
            }
        }
        this.engineInit(n2, key, algorithmParameterSpec, secureRandom);
        this.engineParams = algorithmParameters;
    }

    @Override
    protected void engineInit(int n2, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        try {
            this.engineInit(n2, key, (AlgorithmParameterSpec)null, secureRandom);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InvalidKeyException(invalidAlgorithmParameterException.getMessage(), invalidAlgorithmParameterException);
        }
    }

    @Override
    protected void engineUpdateAAD(byte[] byArray, int n2, int n3) {
        this.aadStream.update(byArray, n2, n3);
    }

    @Override
    protected void engineUpdateAAD(ByteBuffer byteBuffer) {
        int n2 = byteBuffer.arrayOffset() + byteBuffer.position();
        int n3 = byteBuffer.limit() - byteBuffer.position();
        this.aadStream.update(byteBuffer.array(), n2, n3);
    }

    @Override
    protected byte[] engineUpdate(byte[] byArray, int n2, int n3) {
        this.processingStream.update(byArray, n2, n3);
        if (this.resultStream.size() > 0) {
            byte[] byArray2 = this.resultStream.toByteArray();
            this.resultStream.reset();
            return byArray2;
        }
        return null;
    }

    @Override
    protected int engineUpdate(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws ShortBufferException {
        if (n4 + this.cipher.getUpdateOutputSize(n3) > byArray2.length) {
            throw new ShortBufferException("Output buffer too short for input.");
        }
        byte[] byArray3 = this.engineUpdate(byArray, n2, n3);
        if (byArray3 != null) {
            System.arraycopy(byArray3, 0, byArray2, n4, byArray3.length);
            return byArray3.length;
        }
        return 0;
    }

    @Override
    protected byte[] engineDoFinal(byte[] byArray, int n2, int n3) throws IllegalBlockSizeException, BadPaddingException {
        try {
            if (byArray != null && n3 != 0) {
                this.processingStream.update(byArray, n2, n3);
            }
            this.processingStream.close();
        }
        catch (IOException iOException) {
            if (this.cipher.getParameters() instanceof AuthenticationParametersWithIV) {
                ClassUtil.throwBadTagException(iOException.getMessage());
            }
            throw new BadPaddingException(iOException.getMessage());
        }
        byte[] byArray2 = this.resultStream.toByteArray();
        this.resultStream.clearAndReset();
        if (this.associatedData != null) {
            this.aadStream.update(this.associatedData);
        }
        return byArray2;
    }

    @Override
    protected int engineDoFinal(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws IllegalBlockSizeException, BadPaddingException, ShortBufferException {
        if (n4 + this.engineGetOutputSize(n3) > byArray2.length) {
            throw new ShortBufferException("Output buffer too short for input.");
        }
        byte[] byArray3 = this.engineDoFinal(byArray, n2, n3);
        System.arraycopy(byArray3, 0, byArray2, n4, byArray3.length);
        Arrays.fill(byArray3, (byte)0);
        return byArray3.length;
    }

    @Override
    protected byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        byte[] byArray = key.getEncoded();
        if (byArray == null) {
            throw new InvalidKeyException("Cannot wrap key, null encoding.");
        }
        try {
            return this.engineDoFinal(byArray, 0, byArray.length);
        }
        catch (BadPaddingException badPaddingException) {
            throw new IllegalBlockSizeException(badPaddingException.getMessage());
        }
    }

    @Override
    protected Key engineUnwrap(byte[] byArray, String string, int n2) throws InvalidKeyException, NoSuchAlgorithmException {
        byte[] byArray2;
        try {
            byArray2 = this.engineDoFinal(byArray, 0, byArray.length);
        }
        catch (BadPaddingException badPaddingException) {
            throw new InvalidKeyException(badPaddingException.getMessage());
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new InvalidKeyException(illegalBlockSizeException.getMessage());
        }
        return BaseWrapCipher.rebuildKey(string, n2, byArray2, this.fipsProvider);
    }

    private static boolean isAEADMode(Algorithm algorithm) {
        String string = algorithm.getName();
        return string.contains("/CCM") || string.contains("/EAX") || string.contains("/GCM") || string.contains("/OCB");
    }

    static class Builder {
        private final BouncyCastleFipsProvider fipsProvider;
        private final int blockSize;
        private final Algorithm[] algorithms;
        private final Map<Algorithm, Parameters> baseParametersMap;
        private FipsSymmetricOperatorFactory fipsFactory;
        private SymmetricOperatorFactory generalFactory;
        private FipsAEADOperatorFactory fipsAeadFactory;
        private AEADOperatorFactory generalAeadFactory;
        private Class[] availableSpecs;
        private int keySizeInBits;
        private ParametersCreatorProvider fipsParametersProvider;
        private ParametersCreatorProvider generalParametersProvider;
        private DigestAlgorithm prf = FipsSHS.Algorithm.SHA1;
        private PBEScheme scheme;

        Builder(BouncyCastleFipsProvider bouncyCastleFipsProvider, int n2, Parameters ... parametersArray) {
            this.fipsProvider = bouncyCastleFipsProvider;
            this.blockSize = n2;
            this.baseParametersMap = new HashMap<Algorithm, Parameters>(parametersArray.length);
            this.algorithms = new Algorithm[parametersArray.length];
            for (int i2 = 0; i2 != parametersArray.length; ++i2) {
                this.baseParametersMap.put(parametersArray[i2].getAlgorithm(), parametersArray[i2]);
                this.algorithms[i2] = parametersArray[i2].getAlgorithm();
            }
        }

        Builder withFixedKeySize(int n2) {
            this.keySizeInBits = n2;
            return this;
        }

        Builder withFipsOperators(ParametersCreatorProvider parametersCreatorProvider, FipsSymmetricOperatorFactory fipsSymmetricOperatorFactory) {
            this.fipsParametersProvider = parametersCreatorProvider;
            this.fipsFactory = fipsSymmetricOperatorFactory;
            return this;
        }

        Builder withFipsOperators(ParametersCreatorProvider parametersCreatorProvider, FipsSymmetricOperatorFactory fipsSymmetricOperatorFactory, FipsAEADOperatorFactory fipsAEADOperatorFactory) {
            this.fipsParametersProvider = parametersCreatorProvider;
            this.fipsFactory = fipsSymmetricOperatorFactory;
            this.fipsAeadFactory = fipsAEADOperatorFactory;
            return this;
        }

        Builder withGeneralOperators(ParametersCreatorProvider parametersCreatorProvider, SymmetricOperatorFactory symmetricOperatorFactory, AEADOperatorFactory aEADOperatorFactory) {
            this.generalParametersProvider = parametersCreatorProvider;
            this.generalFactory = symmetricOperatorFactory;
            this.generalAeadFactory = aEADOperatorFactory;
            return this;
        }

        Builder withScheme(PBEScheme pBEScheme) {
            this.scheme = pBEScheme;
            return this;
        }

        Builder withPrf(DigestAlgorithm digestAlgorithm) {
            this.prf = digestAlgorithm;
            return this;
        }

        Builder withParameters(Class[] classArray) {
            this.availableSpecs = classArray;
            return this;
        }

        BaseCipher build() {
            boolean bl2 = CryptoServicesRegistrar.isInApprovedOnlyMode();
            if (!bl2) {
                return new BaseCipher(this.fipsProvider, this.blockSize, this.keySizeInBits, this.prf, this.scheme, this.fipsFactory, this.generalFactory, this.fipsAeadFactory, this.generalAeadFactory, this.availableSpecs, this.fipsParametersProvider, this.generalParametersProvider, (Map)this.baseParametersMap, this.algorithms);
            }
            Set<Algorithm> set = Utils.getActiveSet(this.algorithms);
            if (set.isEmpty()) {
                return null;
            }
            return new BaseCipher(this.fipsProvider, this.blockSize, this.keySizeInBits, this.prf, this.scheme, this.fipsFactory, this.generalFactory, this.fipsAeadFactory, this.generalAeadFactory, this.availableSpecs, this.fipsParametersProvider, this.generalParametersProvider, (Map)this.baseParametersMap, set.toArray(new Algorithm[set.size()]));
        }
    }
}

