/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.jcajce;

import com.aspose.html.internal.ms.core.bc.jcajce.ZeroizableSecretKey;
import com.aspose.html.internal.ms.core.bc.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.crypto.SecretKey;

public final class AgreedKeyWithMacKey
implements SecretKey {
    private SecretKey secretKey;
    private byte[] macKey;
    private String macAlgorithm;
    private final AtomicBoolean hasBeenDestroyed = new AtomicBoolean(false);
    private final AtomicBoolean isZeroed = new AtomicBoolean(false);

    public AgreedKeyWithMacKey(SecretKey secretKey) {
        this(secretKey, null, null);
    }

    public AgreedKeyWithMacKey(SecretKey secretKey, String string, byte[] byArray) {
        this.secretKey = secretKey;
        this.macKey = Arrays.clone(byArray);
        this.macAlgorithm = string;
    }

    public String getAlgorithm() {
        if (this.isDestroyed()) {
            throw new IllegalStateException("key has been destroyed");
        }
        return this.secretKey.getAlgorithm();
    }

    public String getFormat() {
        if (this.isDestroyed()) {
            throw new IllegalStateException("key has been destroyed");
        }
        return this.secretKey.getFormat();
    }

    public byte[] getEncoded() {
        if (this.isDestroyed()) {
            throw new IllegalStateException("key has been destroyed");
        }
        return this.secretKey.getEncoded();
    }

    public void destroy() {
        if (!this.hasBeenDestroyed.getAndSet(true)) {
            this.secretKey = null;
        }
    }

    public boolean isDestroyed() {
        return this.hasBeenDestroyed.get();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof SecretKey) {
            return this.secretKey.equals(object);
        }
        return false;
    }

    public int hashCode() {
        return this.secretKey.hashCode();
    }

    private byte[] getMacKeyBytes() {
        if (this.isZeroed.get()) {
            return null;
        }
        return this.macKey;
    }

    public ZeroizableSecretKey getMacKey() {
        if (this.isDestroyed()) {
            throw new IllegalStateException("key has been destroyed");
        }
        if (this.macKey == null) {
            return null;
        }
        return new ZeroizableSecretKey(){

            public void zeroize() {
                AgreedKeyWithMacKey.this.isZeroed.set(true);
                if (AgreedKeyWithMacKey.this.macKey != null) {
                    Arrays.fill(AgreedKeyWithMacKey.this.macKey, (byte)0);
                }
            }

            public void destroy() {
                this.zeroize();
            }

            public boolean isDestroyed() {
                return AgreedKeyWithMacKey.this.isZeroed.get();
            }

            public String getAlgorithm() {
                return AgreedKeyWithMacKey.this.macAlgorithm;
            }

            public String getFormat() {
                return "RAW";
            }

            public byte[] getEncoded() {
                return AgreedKeyWithMacKey.this.getMacKeyBytes();
            }
        };
    }
}

