/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.dvcs;

import com.aspose.html.internal.ms.core.bc.cms.CMSException;
import com.aspose.html.internal.ms.core.bc.cms.CMSProcessableByteArray;
import com.aspose.html.internal.ms.core.bc.cms.CMSSignedData;
import com.aspose.html.internal.ms.core.bc.cms.CMSSignedDataGenerator;
import com.aspose.html.internal.ms.core.bc.dvcs.DVCSException;
import com.aspose.html.internal.ms.core.bc.dvcs.DVCSMessage;
import java.io.IOException;

public class SignedDVCSMessageGenerator {
    private final CMSSignedDataGenerator signedDataGen;

    public SignedDVCSMessageGenerator(CMSSignedDataGenerator cMSSignedDataGenerator) {
        this.signedDataGen = cMSSignedDataGenerator;
    }

    public CMSSignedData build(DVCSMessage dVCSMessage) throws DVCSException {
        try {
            byte[] byArray = dVCSMessage.getContent().toASN1Primitive().getEncoded("DER");
            return this.signedDataGen.generate(new CMSProcessableByteArray(dVCSMessage.getContentType(), byArray), true);
        }
        catch (CMSException cMSException) {
            throw new DVCSException("Could not sign DVCS request", cMSException);
        }
        catch (IOException iOException) {
            throw new DVCSException("Could not encode DVCS request", iOException);
        }
    }
}

