/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.crypto.util;

import com.aspose.html.internal.ms.core.bc.crypto.EntropySource;
import com.aspose.html.internal.ms.core.bc.crypto.EntropySourceProvider;
import com.aspose.html.internal.ms.core.bc.crypto.fips.FipsSecureRandom;
import com.aspose.html.internal.ms.core.bc.crypto.general.GeneralSecureRandom;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.BouncyCastleFipsProvider;
import java.security.SecureRandom;

public class BasicEntropySourceProvider
implements EntropySourceProvider {
    private final SecureRandom _sr;
    private final boolean _predictionResistant;

    public BasicEntropySourceProvider(SecureRandom secureRandom, boolean bl2) {
        this._sr = secureRandom;
        this._predictionResistant = bl2;
    }

    public EntropySource get(final int n2) {
        return new EntropySource(){

            public boolean isPredictionResistant() {
                return BasicEntropySourceProvider.this._predictionResistant;
            }

            public byte[] getEntropy() {
                if (BasicEntropySourceProvider.this._sr instanceof FipsSecureRandom || BasicEntropySourceProvider.this._sr instanceof GeneralSecureRandom || BasicEntropySourceProvider.this._sr.getProvider() instanceof BouncyCastleFipsProvider) {
                    byte[] byArray = new byte[(n2 + 7) / 8];
                    BasicEntropySourceProvider.this._sr.nextBytes(byArray);
                    return byArray;
                }
                return BasicEntropySourceProvider.this._sr.generateSeed((n2 + 7) / 8);
            }

            public int entropySize() {
                return n2;
            }
        };
    }
}

