/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.crypto.internal.wrappers;

import com.aspose.html.internal.ms.core.bc.crypto.internal.BlockCipher;
import com.aspose.html.internal.ms.core.bc.crypto.internal.DataLengthException;
import com.aspose.html.internal.ms.core.bc.crypto.internal.InvalidCipherTextException;
import com.aspose.html.internal.ms.core.bc.crypto.internal.wrappers.SP80038FWrapper;
import com.aspose.html.internal.ms.core.bc.util.Arrays;

public final class SP80038FWrapEngine
extends SP80038FWrapper {
    public SP80038FWrapEngine(BlockCipher blockCipher, boolean bl2) {
        super(blockCipher, ivKW, bl2);
    }

    public String getAlgorithmName() {
        return this.engine.getAlgorithmName() + "/KW";
    }

    public byte[] wrap(byte[] byArray, int n2, int n3) {
        if (!this.forWrapping) {
            throw new IllegalStateException("not set for wrapping");
        }
        int n4 = n3 / this.delta;
        if (n4 * this.delta != n3) {
            throw new DataLengthException("wrap data must be a multiple of " + this.delta + " bytes");
        }
        byte[] byArray2 = new byte[n3 + this.iv.length];
        System.arraycopy(this.iv, 0, byArray2, 0, this.iv.length);
        System.arraycopy(byArray, n2, byArray2, this.iv.length, n3);
        return this.W(n4, byArray2);
    }

    public byte[] unwrap(byte[] byArray, int n2, int n3) throws InvalidCipherTextException {
        if (this.forWrapping) {
            throw new IllegalStateException("not set for unwrapping");
        }
        int n4 = n3 / this.delta;
        if (n4 * this.delta != n3) {
            throw new InvalidCipherTextException("unwrap data must be a multiple of " + this.delta + " bytes");
        }
        byte[] byArray2 = new byte[n3 - this.iv.length];
        byte[] byArray3 = new byte[this.iv.length];
        System.arraycopy(byArray, n2, byArray3, 0, this.iv.length);
        System.arraycopy(byArray, n2 + this.iv.length, byArray2, 0, n3 - this.iv.length);
        this.invW(n4, byArray2, byArray3);
        if (!Arrays.constantTimeAreEqual(byArray3, this.iv)) {
            throw new InvalidCipherTextException("checksum failed");
        }
        return byArray2;
    }
}

