/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.crypto.internal.params;

import com.aspose.html.internal.ms.core.bc.crypto.asymmetric.ECDomainParameters;
import com.aspose.html.internal.ms.core.bc.math.ec.ECAlgorithms;
import com.aspose.html.internal.ms.core.bc.math.ec.ECConstants;
import com.aspose.html.internal.ms.core.bc.math.ec.ECCurve;
import com.aspose.html.internal.ms.core.bc.math.ec.ECPoint;
import com.aspose.html.internal.ms.core.bc.util.Arrays;
import java.math.BigInteger;

public class EcDomainParameters
implements ECConstants {
    private final ECCurve curve;
    private final byte[] seed;
    private final ECPoint G;
    private final BigInteger n;
    private final BigInteger h;
    private final BigInteger hInv;

    public EcDomainParameters(ECDomainParameters eCDomainParameters) {
        this(eCDomainParameters.getCurve(), eCDomainParameters.getG(), eCDomainParameters.getN(), eCDomainParameters.getH(), eCDomainParameters.getSeed(), null);
    }

    public EcDomainParameters(ECDomainParameters eCDomainParameters, BigInteger bigInteger) {
        this(eCDomainParameters.getCurve(), eCDomainParameters.getG(), eCDomainParameters.getN(), eCDomainParameters.getH(), eCDomainParameters.getSeed(), bigInteger);
    }

    private EcDomainParameters(ECCurve eCCurve, ECPoint eCPoint, BigInteger bigInteger, BigInteger bigInteger2, byte[] byArray, BigInteger bigInteger3) {
        if (eCCurve == null) {
            throw new NullPointerException("curve");
        }
        if (bigInteger == null) {
            throw new NullPointerException("n");
        }
        this.curve = eCCurve;
        this.G = EcDomainParameters.validate(eCCurve, eCPoint);
        this.n = bigInteger;
        this.h = bigInteger2;
        this.seed = byArray;
        this.hInv = bigInteger3;
    }

    public ECCurve getCurve() {
        return this.curve;
    }

    public ECPoint getG() {
        return this.G;
    }

    public BigInteger getN() {
        return this.n;
    }

    public BigInteger getH() {
        return this.h;
    }

    public BigInteger getHInv() {
        return this.hInv;
    }

    public byte[] getSeed() {
        return Arrays.clone(this.seed);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof EcDomainParameters) {
            EcDomainParameters ecDomainParameters = (EcDomainParameters)object;
            return this.curve.equals(ecDomainParameters.curve) && this.G.equals(ecDomainParameters.G) && this.n.equals(ecDomainParameters.n) && this.h.equals(ecDomainParameters.h);
        }
        return false;
    }

    public int hashCode() {
        int n2 = this.curve.hashCode();
        n2 += 37 * this.G.hashCode();
        n2 += 37 * this.n.hashCode();
        return n2 += 37 * this.h.hashCode();
    }

    static ECPoint validate(ECCurve eCCurve, ECPoint eCPoint) {
        if (eCPoint == null) {
            throw new IllegalArgumentException("Point has null value");
        }
        if ((eCPoint = ECAlgorithms.importPoint(eCCurve, eCPoint).normalize()).isInfinity()) {
            throw new IllegalArgumentException("Point at infinity");
        }
        if (!eCPoint.isValid()) {
            throw new IllegalArgumentException("Point not on curve");
        }
        return eCPoint;
    }
}

