/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.crypto.internal.macs;

import com.aspose.html.internal.ms.core.bc.crypto.internal.CipherParameters;
import com.aspose.html.internal.ms.core.bc.crypto.internal.DataLengthException;
import com.aspose.html.internal.ms.core.bc.crypto.internal.Mac;

public class TruncatingMac
implements Mac {
    private final Mac mac;
    private final int macSizeInBits;

    public TruncatingMac(Mac mac, int n2) {
        this.mac = mac;
        this.macSizeInBits = n2;
    }

    public void init(CipherParameters cipherParameters) throws IllegalArgumentException {
        this.mac.init(cipherParameters);
    }

    public String getAlgorithmName() {
        return this.mac.getAlgorithmName();
    }

    public int getMacSize() {
        return this.macSizeInBits / 8;
    }

    public void update(byte by2) throws IllegalStateException {
        this.mac.update(by2);
    }

    public void update(byte[] byArray, int n2, int n3) throws DataLengthException, IllegalStateException {
        this.mac.update(byArray, n2, n3);
    }

    public int doFinal(byte[] byArray, int n2) throws DataLengthException, IllegalStateException {
        byte[] byArray2 = new byte[this.mac.getMacSize()];
        this.mac.doFinal(byArray2, 0);
        System.arraycopy(byArray2, 0, byArray, n2, this.macSizeInBits / 8);
        return this.macSizeInBits / 8;
    }

    public void reset() {
    }
}

