/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.crypto.internal.macs;

import com.aspose.html.internal.ms.core.bc.crypto.internal.CipherParameters;
import com.aspose.html.internal.ms.core.bc.crypto.internal.DataLengthException;
import com.aspose.html.internal.ms.core.bc.crypto.internal.InvalidCipherTextException;
import com.aspose.html.internal.ms.core.bc.crypto.internal.Mac;
import com.aspose.html.internal.ms.core.bc.crypto.internal.modes.AEADBlockCipher;
import com.aspose.html.internal.ms.core.bc.crypto.internal.params.AEADParameters;
import com.aspose.html.internal.ms.core.bc.crypto.internal.params.KeyParameter;
import com.aspose.html.internal.ms.core.bc.crypto.internal.params.ParametersWithIV;

public class GMac
implements Mac {
    private final AEADBlockCipher cipher;
    private final int macSizeBits;

    public GMac(AEADBlockCipher aEADBlockCipher) {
        this.cipher = aEADBlockCipher;
        this.macSizeBits = 128;
    }

    public GMac(AEADBlockCipher aEADBlockCipher, int n2) {
        this.cipher = aEADBlockCipher;
        this.macSizeBits = n2;
    }

    public void init(CipherParameters cipherParameters) throws IllegalArgumentException {
        if (!(cipherParameters instanceof ParametersWithIV)) {
            throw new IllegalArgumentException("GMAC requires ParametersWithIV");
        }
        ParametersWithIV parametersWithIV = (ParametersWithIV)cipherParameters;
        byte[] byArray = parametersWithIV.getIV();
        KeyParameter keyParameter = (KeyParameter)parametersWithIV.getParameters();
        this.cipher.init(true, new AEADParameters(keyParameter, this.macSizeBits, byArray));
    }

    public String getAlgorithmName() {
        return this.cipher.getUnderlyingCipher().getAlgorithmName() + "-GMAC";
    }

    public int getMacSize() {
        return this.macSizeBits / 8;
    }

    public void update(byte by2) throws IllegalStateException {
        this.cipher.processAADByte(by2);
    }

    public void update(byte[] byArray, int n2, int n3) throws DataLengthException, IllegalStateException {
        this.cipher.processAADBytes(byArray, n2, n3);
    }

    public int doFinal(byte[] byArray, int n2) throws DataLengthException, IllegalStateException {
        try {
            return this.cipher.doFinal(byArray, n2);
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            throw new IllegalStateException(invalidCipherTextException.toString());
        }
    }

    public void reset() {
        this.cipher.reset();
    }
}

