/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.crypto.internal.io;

import com.aspose.html.internal.ms.core.bc.crypto.CryptoServicesRegistrar;
import com.aspose.html.internal.ms.core.bc.crypto.UpdateOutputStream;
import com.aspose.html.internal.ms.core.bc.crypto.internal.Digest;
import com.aspose.html.internal.ms.core.bc.crypto.internal.io.Utils;
import java.io.IOException;

public class DigestOutputStream
extends UpdateOutputStream {
    private final String algorithmName;
    private final boolean isApprovedMode;
    protected Digest digest;

    public DigestOutputStream(Digest digest) {
        this.algorithmName = digest.getAlgorithmName();
        this.isApprovedMode = CryptoServicesRegistrar.isInApprovedOnlyMode();
        this.digest = digest;
    }

    public void write(int n2) throws IOException {
        Utils.approvedModeCheck(this.isApprovedMode, this.algorithmName);
        this.digest.update((byte)n2);
    }

    public void write(byte[] byArray, int n2, int n3) throws IOException {
        Utils.approvedModeCheck(this.isApprovedMode, this.algorithmName);
        this.digest.update(byArray, n2, n3);
    }

    public final byte[] getDigest() {
        Utils.approvedModeCheck(this.isApprovedMode, this.algorithmName);
        byte[] byArray = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(byArray, 0);
        return byArray;
    }
}

