/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.crypto.general;

import com.aspose.html.internal.ms.core.bc.crypto.internal.params.AsymmetricKeyParameter;
import com.aspose.html.internal.ms.core.bc.util.Arrays;
import com.aspose.html.internal.ms.core.bc.util.io.Streams;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

final class X448PublicKeyParameters
extends AsymmetricKeyParameter {
    public static final int KEY_SIZE = 56;
    private final byte[] data = new byte[56];

    public X448PublicKeyParameters(byte[] byArray, int n2) {
        super(false);
        System.arraycopy(byArray, n2, this.data, 0, 56);
    }

    public X448PublicKeyParameters(InputStream inputStream) throws IOException {
        super(false);
        if (56 != Streams.readFully(inputStream, this.data)) {
            throw new EOFException("EOF encountered in middle of X448 public key");
        }
    }

    public void encode(byte[] byArray, int n2) {
        System.arraycopy(this.data, 0, byArray, n2, 56);
    }

    public byte[] getEncoded() {
        return Arrays.clone(this.data);
    }
}

