/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.crypto.general;

import com.aspose.html.internal.ms.core.bc.crypto.AuthenticationParameters;
import com.aspose.html.internal.ms.core.bc.crypto.CryptoServicesRegistrar;
import com.aspose.html.internal.ms.core.bc.crypto.MACOperatorFactory;
import com.aspose.html.internal.ms.core.bc.crypto.OutputMACCalculator;
import com.aspose.html.internal.ms.core.bc.crypto.SymmetricKey;
import com.aspose.html.internal.ms.core.bc.crypto.UpdateOutputStream;
import com.aspose.html.internal.ms.core.bc.crypto.fips.FipsStatus;
import com.aspose.html.internal.ms.core.bc.crypto.fips.FipsUnapprovedOperationError;
import com.aspose.html.internal.ms.core.bc.crypto.internal.Mac;
import com.aspose.html.internal.ms.core.bc.crypto.internal.io.MacOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class GuardedMACOperatorFactory<T extends AuthenticationParameters>
implements MACOperatorFactory<T> {
    GuardedMACOperatorFactory() {
        FipsStatus.isReady();
        if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            throw new FipsUnapprovedOperationError("Attempt to create unapproved factory in approved only mode");
        }
    }

    @Override
    public final OutputMACCalculator<T> createOutputMACCalculator(SymmetricKey symmetricKey, T t2) {
        if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            throw new FipsUnapprovedOperationError("Attempt to create unapproved algorithm in approved only mode", t2.getAlgorithm());
        }
        Mac mac = this.createMAC(symmetricKey, t2);
        return new OutputMACCalculator<T>((AuthenticationParameters)t2, mac){
            final /* synthetic */ AuthenticationParameters val$parameters;
            final /* synthetic */ Mac val$mac;
            {
                this.val$parameters = authenticationParameters;
                this.val$mac = mac;
            }

            @Override
            public T getParameters() {
                return this.val$parameters;
            }

            @Override
            public int getMACSize() {
                return this.val$mac.getMacSize();
            }

            @Override
            public UpdateOutputStream getMACStream() {
                return new MacOutputStream(this.val$mac);
            }

            @Override
            public byte[] getMAC() {
                byte[] byArray = new byte[this.val$mac.getMacSize()];
                this.getMAC(byArray, 0);
                return byArray;
            }

            @Override
            public int getMAC(byte[] byArray, int n2) {
                return this.val$mac.doFinal(byArray, n2);
            }

            @Override
            public void reset() {
                this.val$mac.reset();
            }
        };
    }

    protected abstract Mac createMAC(SymmetricKey var1, T var2);

    protected abstract int calculateMACSize(T var1);
}

