/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.crypto.general;

import com.aspose.html.internal.ms.core.bc.crypto.AEADOperatorFactory;
import com.aspose.html.internal.ms.core.bc.crypto.CipherOutputStream;
import com.aspose.html.internal.ms.core.bc.crypto.CryptoServicesRegistrar;
import com.aspose.html.internal.ms.core.bc.crypto.InputAEADDecryptor;
import com.aspose.html.internal.ms.core.bc.crypto.OutputAEADDecryptor;
import com.aspose.html.internal.ms.core.bc.crypto.OutputAEADEncryptor;
import com.aspose.html.internal.ms.core.bc.crypto.Parameters;
import com.aspose.html.internal.ms.core.bc.crypto.SymmetricKey;
import com.aspose.html.internal.ms.core.bc.crypto.UpdateOutputStream;
import com.aspose.html.internal.ms.core.bc.crypto.fips.FipsStatus;
import com.aspose.html.internal.ms.core.bc.crypto.fips.FipsUnapprovedOperationError;
import com.aspose.html.internal.ms.core.bc.crypto.internal.io.CipherInputStream;
import com.aspose.html.internal.ms.core.bc.crypto.internal.io.CipherOutputStreamImpl;
import com.aspose.html.internal.ms.core.bc.crypto.internal.modes.AEADBlockCipher;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class GuardedAEADOperatorFactory<T extends Parameters>
implements AEADOperatorFactory<T> {
    GuardedAEADOperatorFactory() {
        FipsStatus.isReady();
        if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            throw new FipsUnapprovedOperationError("Attempt to create unapproved factory in approved only mode.");
        }
    }

    @Override
    public OutputAEADEncryptor<T> createOutputAEADEncryptor(SymmetricKey symmetricKey, T t2) {
        if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            throw new FipsUnapprovedOperationError("Attempt to create unapproved algorithm in approved only mode", t2.getAlgorithm());
        }
        return new OutEncryptor(this, symmetricKey, t2);
    }

    @Override
    public InputAEADDecryptor<T> createInputAEADDecryptor(SymmetricKey symmetricKey, T t2) {
        if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            throw new FipsUnapprovedOperationError("Attempt to create unapproved algorithm in approved only mode", t2.getAlgorithm());
        }
        AEADBlockCipher aEADBlockCipher = this.createAEADCipher(false, symmetricKey, t2);
        return new InputAEADDecryptor<T>((Parameters)t2, aEADBlockCipher){
            final /* synthetic */ Parameters val$parameters;
            final /* synthetic */ AEADBlockCipher val$cipher;
            {
                this.val$parameters = parameters;
                this.val$cipher = aEADBlockCipher;
            }

            @Override
            public T getParameters() {
                return this.val$parameters;
            }

            @Override
            public UpdateOutputStream getAADStream() {
                return new AADStream(this.val$cipher);
            }

            @Override
            public InputStream getDecryptingStream(InputStream inputStream) {
                return new CipherInputStream(inputStream, this.val$cipher);
            }

            @Override
            public byte[] getMAC() {
                return this.val$cipher.getMac();
            }
        };
    }

    @Override
    public OutputAEADDecryptor<T> createOutputAEADDecryptor(SymmetricKey symmetricKey, T t2) {
        if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            throw new FipsUnapprovedOperationError("Attempt to create unapproved algorithm in approved only mode", t2.getAlgorithm());
        }
        AEADBlockCipher aEADBlockCipher = this.createAEADCipher(false, symmetricKey, t2);
        return new OutputAEADDecryptor<T>((Parameters)t2, aEADBlockCipher){
            final /* synthetic */ Parameters val$parameters;
            final /* synthetic */ AEADBlockCipher val$cipher;
            {
                this.val$parameters = parameters;
                this.val$cipher = aEADBlockCipher;
            }

            @Override
            public T getParameters() {
                return this.val$parameters;
            }

            @Override
            public int getMaxOutputSize(int n2) {
                return this.val$cipher.getOutputSize(n2);
            }

            @Override
            public int getUpdateOutputSize(int n2) {
                return this.val$cipher.getUpdateOutputSize(n2);
            }

            @Override
            public UpdateOutputStream getAADStream() {
                return new AADStream(this.val$cipher);
            }

            @Override
            public CipherOutputStream getDecryptingStream(OutputStream outputStream) {
                return new CipherOutputStreamImpl(outputStream, this.val$cipher);
            }

            @Override
            public byte[] getMAC() {
                return this.val$cipher.getMac();
            }
        };
    }

    protected abstract AEADBlockCipher createAEADCipher(boolean var1, SymmetricKey var2, T var3);

    private class AADStream
    extends UpdateOutputStream {
        private AEADBlockCipher cipher;

        AADStream(AEADBlockCipher aEADBlockCipher) {
            this.cipher = aEADBlockCipher;
        }

        public void write(byte[] byArray, int n2, int n3) throws IOException {
            this.cipher.processAADBytes(byArray, n2, n3);
        }

        public void write(int n2) throws IOException {
            this.cipher.processAADByte((byte)n2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OutEncryptor
    implements OutputAEADEncryptor<T> {
        private final T parameters;
        private final AEADBlockCipher cipher;
        final /* synthetic */ GuardedAEADOperatorFactory this$0;

        OutEncryptor(SymmetricKey symmetricKey, T t2) {
            this.this$0 = var1_1;
            this.parameters = t2;
            this.cipher = var1_1.createAEADCipher(true, symmetricKey, t2);
        }

        @Override
        public T getParameters() {
            return this.parameters;
        }

        @Override
        public int getMaxOutputSize(int n2) {
            return this.cipher.getOutputSize(n2);
        }

        @Override
        public int getUpdateOutputSize(int n2) {
            return this.cipher.getUpdateOutputSize(n2);
        }

        @Override
        public UpdateOutputStream getAADStream() {
            return this.this$0.new AADStream(this.cipher);
        }

        @Override
        public CipherOutputStream getEncryptingStream(OutputStream outputStream) {
            return new CipherOutputStreamImpl(outputStream, this.cipher);
        }

        @Override
        public byte[] getMAC() {
            return this.cipher.getMac();
        }
    }
}

