/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.crypto.fips;

import com.aspose.html.internal.ms.core.bc.asn1.nist.NISTNamedCurves;
import com.aspose.html.internal.ms.core.bc.asn1.x9.X9ECParameters;
import com.aspose.html.internal.ms.core.bc.crypto.Algorithm;
import com.aspose.html.internal.ms.core.bc.crypto.AsymmetricPrivateKey;
import com.aspose.html.internal.ms.core.bc.crypto.AsymmetricPublicKey;
import com.aspose.html.internal.ms.core.bc.crypto.CryptoServicesRegistrar;
import com.aspose.html.internal.ms.core.bc.crypto.asymmetric.AsymmetricECPrivateKey;
import com.aspose.html.internal.ms.core.bc.crypto.asymmetric.AsymmetricECPublicKey;
import com.aspose.html.internal.ms.core.bc.crypto.asymmetric.AsymmetricKeyPair;
import com.aspose.html.internal.ms.core.bc.crypto.asymmetric.ECDomainParameters;
import com.aspose.html.internal.ms.core.bc.crypto.asymmetric.ECDomainParametersID;
import com.aspose.html.internal.ms.core.bc.crypto.asymmetric.NamedECDomainParameters;
import com.aspose.html.internal.ms.core.bc.crypto.fips.DSAOutputSigner;
import com.aspose.html.internal.ms.core.bc.crypto.fips.DSAOutputVerifier;
import com.aspose.html.internal.ms.core.bc.crypto.fips.EcDHAgreement;
import com.aspose.html.internal.ms.core.bc.crypto.fips.EcDHUAgreement;
import com.aspose.html.internal.ms.core.bc.crypto.fips.EcDhBasicAgreement;
import com.aspose.html.internal.ms.core.bc.crypto.fips.EcDhcBasicAgreement;
import com.aspose.html.internal.ms.core.bc.crypto.fips.EcDhcuBasicAgreement;
import com.aspose.html.internal.ms.core.bc.crypto.fips.EcDsaSigner;
import com.aspose.html.internal.ms.core.bc.crypto.fips.EcKeyGenerationParameters;
import com.aspose.html.internal.ms.core.bc.crypto.fips.EcKeyPairGenerator;
import com.aspose.html.internal.ms.core.bc.crypto.fips.EcMqvBasicAgreement;
import com.aspose.html.internal.ms.core.bc.crypto.fips.FipsAgreement;
import com.aspose.html.internal.ms.core.bc.crypto.fips.FipsAgreementFactory;
import com.aspose.html.internal.ms.core.bc.crypto.fips.FipsAgreementParameters;
import com.aspose.html.internal.ms.core.bc.crypto.fips.FipsAlgorithm;
import com.aspose.html.internal.ms.core.bc.crypto.fips.FipsAsymmetricKeyPairGenerator;
import com.aspose.html.internal.ms.core.bc.crypto.fips.FipsDigestAlgorithm;
import com.aspose.html.internal.ms.core.bc.crypto.fips.FipsEngineProvider;
import com.aspose.html.internal.ms.core.bc.crypto.fips.FipsKDF;
import com.aspose.html.internal.ms.core.bc.crypto.fips.FipsOutputSignerUsingSecureRandom;
import com.aspose.html.internal.ms.core.bc.crypto.fips.FipsOutputVerifier;
import com.aspose.html.internal.ms.core.bc.crypto.fips.FipsParameters;
import com.aspose.html.internal.ms.core.bc.crypto.fips.FipsSHS;
import com.aspose.html.internal.ms.core.bc.crypto.fips.FipsSignatureOperatorFactory;
import com.aspose.html.internal.ms.core.bc.crypto.fips.FipsUnapprovedOperationError;
import com.aspose.html.internal.ms.core.bc.crypto.fips.NullDigest;
import com.aspose.html.internal.ms.core.bc.crypto.fips.PrivilegedUtils;
import com.aspose.html.internal.ms.core.bc.crypto.fips.SelfTestExecutor;
import com.aspose.html.internal.ms.core.bc.crypto.fips.Utils;
import com.aspose.html.internal.ms.core.bc.crypto.fips.VariantInternalKatTest;
import com.aspose.html.internal.ms.core.bc.crypto.fips.VariantKatTest;
import com.aspose.html.internal.ms.core.bc.crypto.internal.AsymmetricCipherKeyPair;
import com.aspose.html.internal.ms.core.bc.crypto.internal.DSA;
import com.aspose.html.internal.ms.core.bc.crypto.internal.Digest;
import com.aspose.html.internal.ms.core.bc.crypto.internal.Permissions;
import com.aspose.html.internal.ms.core.bc.crypto.internal.params.EcDhuPrivateParameters;
import com.aspose.html.internal.ms.core.bc.crypto.internal.params.EcDhuPublicParameters;
import com.aspose.html.internal.ms.core.bc.crypto.internal.params.EcDomainParameters;
import com.aspose.html.internal.ms.core.bc.crypto.internal.params.EcMqvPrivateParameters;
import com.aspose.html.internal.ms.core.bc.crypto.internal.params.EcMqvPublicParameters;
import com.aspose.html.internal.ms.core.bc.crypto.internal.params.EcNamedDomainParameters;
import com.aspose.html.internal.ms.core.bc.crypto.internal.params.EcPrivateKeyParameters;
import com.aspose.html.internal.ms.core.bc.crypto.internal.params.EcPublicKeyParameters;
import com.aspose.html.internal.ms.core.bc.crypto.internal.params.ParametersWithRandom;
import com.aspose.html.internal.ms.core.bc.crypto.internal.test.ConsistencyTest;
import com.aspose.html.internal.ms.core.bc.math.ec.ECConstants;
import com.aspose.html.internal.ms.core.bc.math.ec.ECPoint;
import com.aspose.html.internal.ms.core.bc.util.Arrays;
import com.aspose.html.internal.ms.core.bc.util.Properties;
import com.aspose.html.internal.ms.core.bc.util.encoders.Hex;
import com.aspose.html.internal.ms.core.bc.util.test.TestRandomBigInteger;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.SecureRandom;

public final class FipsEC {
    private static final int MIN_FIPS_FIELD_SIZE = 224;
    private static final BigInteger TEST_D_OFFSET = new BigInteger("deadbeef", 16);
    public static final FipsAlgorithm ALGORITHM = new FipsAlgorithm("EC");
    private static final FipsAlgorithm ALGORITHM_MQV = new FipsAlgorithm("ECMQV", (Enum)Variations.ECMQV);
    private static final FipsAlgorithm ALGORITHM_DHU = new FipsAlgorithm("ECCDHU", (Enum)Variations.ECCDHU);
    public static final DSAParameters DSA = new DSAParameters(new FipsAlgorithm("ECDSA", (Enum)Variations.ECDSA), FipsSHS.Algorithm.SHA1);
    public static final AgreementParameters DH = new AgreementParameters(new FipsAlgorithm("ECDH", (Enum)Variations.ECDH));
    public static final AgreementParameters CDH = new AgreementParameters(new FipsAlgorithm("ECCDH", (Enum)Variations.ECCDH));
    public static final MQVAgreementParametersBuilder MQV = new MQVAgreementParametersBuilder();
    public static final DHUAgreementParametersBuilder CDHU = new DHUAgreementParametersBuilder();
    private static final FipsEngineProvider<EcDsaSigner> DSA_PROVIDER = new DsaProvider();
    private static final FipsEngineProvider<EcDhBasicAgreement> DH_PROVIDER = new DhProvider();
    private static final FipsEngineProvider<EcDhcBasicAgreement> CDH_PROVIDER = new DhcProvider();
    private static final FipsEngineProvider<EcMqvBasicAgreement> MQV_PROVIDER = new MqvProvider();
    private static final FipsEngineProvider<EcDhcuBasicAgreement> DHU_PROVIDER = new DhuProvider();

    private FipsEC() {
    }

    private static void checkEnabled() {
        if (Properties.isOverrideSet("com.aspose.html.internal.ms.core.bc.ec.disable")) {
            throw new UnsupportedOperationException("EC has been disabled by setting \"org.bouncycastle.ec.disable\"");
        }
    }

    private static void validateKeyPair(FipsAlgorithm fipsAlgorithm, AsymmetricCipherKeyPair asymmetricCipherKeyPair) {
        Variations variations = fipsAlgorithm == ALGORITHM ? Variations.ECDSA : (Variations)fipsAlgorithm.basicVariation();
        switch (variations) {
            case ECDSA: {
                SelfTestExecutor.validate(fipsAlgorithm, asymmetricCipherKeyPair, new ConsistencyTest<AsymmetricCipherKeyPair>(){

                    @Override
                    public boolean hasTestPassed(AsymmetricCipherKeyPair asymmetricCipherKeyPair) throws Exception {
                        EcDsaSigner ecDsaSigner = new EcDsaSigner();
                        ecDsaSigner.init(true, new ParametersWithRandom(asymmetricCipherKeyPair.getPrivate(), Utils.testRandom));
                        byte[] byArray = new byte[32];
                        byArray[1] = 1;
                        BigInteger[] bigIntegerArray = ecDsaSigner.generateSignature(byArray);
                        ecDsaSigner.init(false, asymmetricCipherKeyPair.getPublic());
                        return ecDsaSigner.verifySignature(byArray, bigIntegerArray[0], bigIntegerArray[1]);
                    }
                });
                break;
            }
            case ECDH: {
                SelfTestExecutor.validate(fipsAlgorithm, asymmetricCipherKeyPair, new ConsistencyTest<AsymmetricCipherKeyPair>(){

                    @Override
                    public boolean hasTestPassed(AsymmetricCipherKeyPair asymmetricCipherKeyPair) throws Exception {
                        EcDhBasicAgreement ecDhBasicAgreement = new EcDhBasicAgreement();
                        ecDhBasicAgreement.init(asymmetricCipherKeyPair.getPrivate());
                        BigInteger bigInteger = ecDhBasicAgreement.calculateAgreement(asymmetricCipherKeyPair.getPublic());
                        AsymmetricCipherKeyPair asymmetricCipherKeyPair2 = FipsEC.getTestKeyPair(asymmetricCipherKeyPair);
                        ecDhBasicAgreement.init(asymmetricCipherKeyPair2.getPrivate());
                        BigInteger bigInteger2 = ecDhBasicAgreement.calculateAgreement(asymmetricCipherKeyPair2.getPublic());
                        ecDhBasicAgreement.init(asymmetricCipherKeyPair.getPrivate());
                        BigInteger bigInteger3 = ecDhBasicAgreement.calculateAgreement(asymmetricCipherKeyPair2.getPublic());
                        ecDhBasicAgreement.init(asymmetricCipherKeyPair2.getPrivate());
                        BigInteger bigInteger4 = ecDhBasicAgreement.calculateAgreement(asymmetricCipherKeyPair.getPublic());
                        return !bigInteger.equals(bigInteger2) && !bigInteger.equals(bigInteger3) && bigInteger3.equals(bigInteger4);
                    }
                });
                break;
            }
            case ECCDH: {
                SelfTestExecutor.validate(fipsAlgorithm, asymmetricCipherKeyPair, new ConsistencyTest<AsymmetricCipherKeyPair>(){

                    @Override
                    public boolean hasTestPassed(AsymmetricCipherKeyPair asymmetricCipherKeyPair) throws Exception {
                        EcDhcBasicAgreement ecDhcBasicAgreement = new EcDhcBasicAgreement();
                        ecDhcBasicAgreement.init(asymmetricCipherKeyPair.getPrivate());
                        BigInteger bigInteger = ecDhcBasicAgreement.calculateAgreement(asymmetricCipherKeyPair.getPublic());
                        AsymmetricCipherKeyPair asymmetricCipherKeyPair2 = FipsEC.getTestKeyPair(asymmetricCipherKeyPair);
                        ecDhcBasicAgreement.init(asymmetricCipherKeyPair2.getPrivate());
                        BigInteger bigInteger2 = ecDhcBasicAgreement.calculateAgreement(asymmetricCipherKeyPair2.getPublic());
                        ecDhcBasicAgreement.init(asymmetricCipherKeyPair.getPrivate());
                        BigInteger bigInteger3 = ecDhcBasicAgreement.calculateAgreement(asymmetricCipherKeyPair2.getPublic());
                        ecDhcBasicAgreement.init(asymmetricCipherKeyPair2.getPrivate());
                        BigInteger bigInteger4 = ecDhcBasicAgreement.calculateAgreement(asymmetricCipherKeyPair.getPublic());
                        return !bigInteger.equals(bigInteger2) && !bigInteger.equals(bigInteger3) && bigInteger3.equals(bigInteger4);
                    }
                });
                break;
            }
            case ECMQV: {
                SelfTestExecutor.validate(fipsAlgorithm, asymmetricCipherKeyPair, new ConsistencyTest<AsymmetricCipherKeyPair>(){

                    @Override
                    public boolean hasTestPassed(AsymmetricCipherKeyPair asymmetricCipherKeyPair) throws Exception {
                        EcMqvBasicAgreement ecMqvBasicAgreement = new EcMqvBasicAgreement();
                        ecMqvBasicAgreement.init(new EcMqvPrivateParameters((EcPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate(), (EcPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate()));
                        BigInteger bigInteger = ecMqvBasicAgreement.calculateAgreement(new EcMqvPublicParameters((EcPublicKeyParameters)asymmetricCipherKeyPair.getPublic(), (EcPublicKeyParameters)asymmetricCipherKeyPair.getPublic()));
                        AsymmetricCipherKeyPair asymmetricCipherKeyPair2 = FipsEC.getTestKeyPair(asymmetricCipherKeyPair);
                        AsymmetricCipherKeyPair asymmetricCipherKeyPair3 = FipsEC.getTestKeyPair(asymmetricCipherKeyPair);
                        ecMqvBasicAgreement.init(new EcMqvPrivateParameters((EcPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate(), (EcPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate()));
                        BigInteger bigInteger2 = ecMqvBasicAgreement.calculateAgreement(new EcMqvPublicParameters((EcPublicKeyParameters)asymmetricCipherKeyPair2.getPublic(), (EcPublicKeyParameters)asymmetricCipherKeyPair3.getPublic()));
                        ecMqvBasicAgreement.init(new EcMqvPrivateParameters((EcPrivateKeyParameters)asymmetricCipherKeyPair2.getPrivate(), (EcPrivateKeyParameters)asymmetricCipherKeyPair3.getPrivate()));
                        BigInteger bigInteger3 = ecMqvBasicAgreement.calculateAgreement(new EcMqvPublicParameters((EcPublicKeyParameters)asymmetricCipherKeyPair.getPublic(), (EcPublicKeyParameters)asymmetricCipherKeyPair.getPublic()));
                        return !bigInteger.equals(bigInteger2) && bigInteger2.equals(bigInteger3);
                    }
                });
                break;
            }
            case ECCDHU: {
                SelfTestExecutor.validate(fipsAlgorithm, asymmetricCipherKeyPair, new ConsistencyTest<AsymmetricCipherKeyPair>(){

                    @Override
                    public boolean hasTestPassed(AsymmetricCipherKeyPair asymmetricCipherKeyPair) throws Exception {
                        EcDhcuBasicAgreement ecDhcuBasicAgreement = new EcDhcuBasicAgreement();
                        ecDhcuBasicAgreement.init(new EcDhuPrivateParameters((EcPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate(), (EcPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate()));
                        byte[] byArray = ecDhcuBasicAgreement.calculateAgreement(new EcDhuPublicParameters((EcPublicKeyParameters)asymmetricCipherKeyPair.getPublic(), (EcPublicKeyParameters)asymmetricCipherKeyPair.getPublic()));
                        AsymmetricCipherKeyPair asymmetricCipherKeyPair2 = FipsEC.getTestKeyPair(asymmetricCipherKeyPair);
                        AsymmetricCipherKeyPair asymmetricCipherKeyPair3 = FipsEC.getTestKeyPair(asymmetricCipherKeyPair);
                        ecDhcuBasicAgreement.init(new EcDhuPrivateParameters((EcPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate(), (EcPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate()));
                        byte[] byArray2 = ecDhcuBasicAgreement.calculateAgreement(new EcDhuPublicParameters((EcPublicKeyParameters)asymmetricCipherKeyPair2.getPublic(), (EcPublicKeyParameters)asymmetricCipherKeyPair3.getPublic()));
                        ecDhcuBasicAgreement.init(new EcDhuPrivateParameters((EcPrivateKeyParameters)asymmetricCipherKeyPair2.getPrivate(), (EcPrivateKeyParameters)asymmetricCipherKeyPair3.getPrivate()));
                        byte[] byArray3 = ecDhcuBasicAgreement.calculateAgreement(new EcDhuPublicParameters((EcPublicKeyParameters)asymmetricCipherKeyPair.getPublic(), (EcPublicKeyParameters)asymmetricCipherKeyPair.getPublic()));
                        return !Arrays.areEqual(byArray, byArray2) && Arrays.areEqual(byArray2, byArray3);
                    }
                });
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled EC algorithm: " + fipsAlgorithm.getName());
            }
        }
    }

    private static AsymmetricCipherKeyPair getKATKeyPair() {
        X9ECParameters x9ECParameters = NISTNamedCurves.getByName("P-256");
        EcDomainParameters ecDomainParameters = new EcDomainParameters(new ECDomainParameters(x9ECParameters.getCurve(), x9ECParameters.getG(), x9ECParameters.getN(), x9ECParameters.getH(), x9ECParameters.getSeed()));
        EcPrivateKeyParameters ecPrivateKeyParameters = new EcPrivateKeyParameters(new BigInteger("20186677036482506117540275567393538695075300175221296989956723148347484984008"), ecDomainParameters);
        EcPublicKeyParameters ecPublicKeyParameters = new EcPublicKeyParameters(ecDomainParameters.getCurve().decodePoint(Hex.decode("03596375E6CE57E0F20294FC46BDFCFD19A39F8161B58695B3EC5B3D16427C274D")), ecDomainParameters);
        return new AsymmetricCipherKeyPair(ecPublicKeyParameters, ecPrivateKeyParameters);
    }

    private static void ecPrimitiveZTest() {
        SelfTestExecutor.validate(ALGORITHM, new VariantInternalKatTest(ALGORITHM){

            void evaluate() throws Exception {
                X9ECParameters x9ECParameters = NISTNamedCurves.getByName("P-256");
                ECDomainParameters eCDomainParameters = new ECDomainParameters(x9ECParameters.getCurve(), x9ECParameters.getG(), x9ECParameters.getN(), x9ECParameters.getH(), x9ECParameters.getSeed());
                BigInteger bigInteger = new BigInteger("20186677036482506117540275567393538695075300175221296989956723148347484984008");
                ECPoint eCPoint = eCDomainParameters.getCurve().decodePoint(Hex.decode("03596375E6CE57E0F20294FC46BDFCFD19A39F8161B58695B3EC5B3D16427C274D"));
                if (!eCPoint.equals(eCDomainParameters.getG().multiply(bigInteger))) {
                    this.fail("EC primitive 'Z' computation failed");
                }
            }
        });
    }

    private static AsymmetricCipherKeyPair getTestKeyPair(AsymmetricCipherKeyPair asymmetricCipherKeyPair) {
        EcPrivateKeyParameters ecPrivateKeyParameters = (EcPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
        EcDomainParameters ecDomainParameters = ecPrivateKeyParameters.getParameters();
        BigInteger bigInteger = ecPrivateKeyParameters.getD().add(TEST_D_OFFSET).mod(ecDomainParameters.getN());
        if (bigInteger.compareTo(ECConstants.TWO) < 0) {
            bigInteger = bigInteger.add(TEST_D_OFFSET);
        }
        EcPrivateKeyParameters ecPrivateKeyParameters2 = new EcPrivateKeyParameters(bigInteger, ecDomainParameters);
        EcPublicKeyParameters ecPublicKeyParameters = new EcPublicKeyParameters(ecDomainParameters.getG().multiply(bigInteger), ecDomainParameters);
        return new AsymmetricCipherKeyPair(ecPublicKeyParameters, ecPrivateKeyParameters2);
    }

    private static void validateCurveSize(Algorithm algorithm, ECDomainParameters eCDomainParameters) {
        if (eCDomainParameters.getCurve().getFieldSize() < 224) {
            throw new FipsUnapprovedOperationError("Attempt to use curve with field size less than 224 bits", algorithm);
        }
    }

    private static EcDomainParameters getDomainParams(ECDomainParameters eCDomainParameters) {
        if (eCDomainParameters instanceof NamedECDomainParameters) {
            return new EcNamedDomainParameters((NamedECDomainParameters)eCDomainParameters);
        }
        return new EcDomainParameters(eCDomainParameters);
    }

    private static EcPrivateKeyParameters getLwKey(final AsymmetricECPrivateKey asymmetricECPrivateKey) {
        return AccessController.doPrivileged(new PrivilegedAction<EcPrivateKeyParameters>(){

            @Override
            public EcPrivateKeyParameters run() {
                return new EcPrivateKeyParameters(asymmetricECPrivateKey.getS(), FipsEC.getDomainParams(asymmetricECPrivateKey.getDomainParameters()));
            }
        });
    }

    private static EcDomainParameters getDomainParamsWithInv(ECDomainParameters eCDomainParameters) {
        if (eCDomainParameters instanceof NamedECDomainParameters) {
            return new EcNamedDomainParameters((NamedECDomainParameters)eCDomainParameters, eCDomainParameters.getInverseH());
        }
        return new EcDomainParameters(eCDomainParameters, eCDomainParameters.getInverseH());
    }

    private static EcPrivateKeyParameters getLwKeyWithInv(final AsymmetricECPrivateKey asymmetricECPrivateKey) {
        return AccessController.doPrivileged(new PrivilegedAction<EcPrivateKeyParameters>(){

            @Override
            public EcPrivateKeyParameters run() {
                return new EcPrivateKeyParameters(asymmetricECPrivateKey.getS(), FipsEC.getDomainParamsWithInv(asymmetricECPrivateKey.getDomainParameters()));
            }
        });
    }

    static {
        DSA_PROVIDER.createEngine();
        FipsEC.ecPrimitiveZTest();
    }

    public static final class AgreementParameters
    extends FipsAgreementParameters {
        AgreementParameters(FipsAlgorithm fipsAlgorithm) {
            this(fipsAlgorithm, null);
        }

        private AgreementParameters(FipsAlgorithm fipsAlgorithm, FipsAlgorithm fipsAlgorithm2) {
            super(fipsAlgorithm, fipsAlgorithm2);
        }

        private AgreementParameters(FipsAlgorithm fipsAlgorithm, FipsKDF.PRF pRF, byte[] byArray) {
            super(fipsAlgorithm, pRF, byArray);
        }

        private AgreementParameters(FipsAlgorithm fipsAlgorithm, FipsKDF.AgreementKDFParametersBuilder agreementKDFParametersBuilder, byte[] byArray, int n2) {
            super(fipsAlgorithm, agreementKDFParametersBuilder, byArray, n2);
        }

        public AgreementParameters withDigest(FipsDigestAlgorithm fipsDigestAlgorithm) {
            return new AgreementParameters(this.getAlgorithm(), fipsDigestAlgorithm);
        }

        public AgreementParameters withPRF(FipsKDF.PRF pRF, byte[] byArray) {
            return new AgreementParameters(this.getAlgorithm(), pRF, byArray);
        }

        public AgreementParameters withKDF(FipsKDF.AgreementKDFParametersBuilder agreementKDFParametersBuilder, byte[] byArray, int n2) {
            return new AgreementParameters(this.getAlgorithm(), agreementKDFParametersBuilder, byArray, n2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DHAgreementFactory
    extends FipsAgreementFactory<AgreementParameters> {
        public DHAgreementFactory() {
            FipsEC.checkEnabled();
        }

        @Override
        public FipsAgreement<AgreementParameters> createAgreement(AsymmetricPrivateKey asymmetricPrivateKey, AgreementParameters agreementParameters) {
            if (agreementParameters.getAlgorithm() == DH.getAlgorithm()) {
                AsymmetricECPrivateKey asymmetricECPrivateKey = (AsymmetricECPrivateKey)asymmetricPrivateKey;
                if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
                    if (!BigInteger.ONE.equals(asymmetricECPrivateKey.getDomainParameters().getH())) {
                        throw new FipsUnapprovedOperationError("ECDH can only be executed on curves with a co-factor of 1 in approved mode", asymmetricPrivateKey.getAlgorithm());
                    }
                    FipsEC.validateCurveSize(asymmetricPrivateKey.getAlgorithm(), asymmetricECPrivateKey.getDomainParameters());
                }
                EcPrivateKeyParameters ecPrivateKeyParameters = !BigInteger.ONE.equals(asymmetricECPrivateKey.getDomainParameters().getH()) ? FipsEC.getLwKeyWithInv(asymmetricECPrivateKey) : FipsEC.getLwKey(asymmetricECPrivateKey);
                EcDhBasicAgreement ecDhBasicAgreement = (EcDhBasicAgreement)DH_PROVIDER.createEngine();
                ecDhBasicAgreement.init(ecPrivateKeyParameters);
                return new EcDHAgreement<AgreementParameters>(ecDhBasicAgreement, agreementParameters);
            }
            if (agreementParameters.getAlgorithm() == CDH.getAlgorithm()) {
                AsymmetricECPrivateKey asymmetricECPrivateKey = (AsymmetricECPrivateKey)asymmetricPrivateKey;
                if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
                    FipsEC.validateCurveSize(asymmetricPrivateKey.getAlgorithm(), asymmetricECPrivateKey.getDomainParameters());
                }
                EcPrivateKeyParameters ecPrivateKeyParameters = FipsEC.getLwKey(asymmetricECPrivateKey);
                EcDhcBasicAgreement ecDhcBasicAgreement = (EcDhcBasicAgreement)CDH_PROVIDER.createEngine();
                ecDhcBasicAgreement.init(ecPrivateKeyParameters);
                return new EcDHAgreement<AgreementParameters>(ecDhcBasicAgreement, agreementParameters);
            }
            throw new IllegalArgumentException("Incorrect algorithm in parameters for EC DH: " + agreementParameters.getAlgorithm().getName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DHUAgreementFactory
    extends FipsAgreementFactory<DHUAgreementParameters> {
        public DHUAgreementFactory() {
            FipsEC.checkEnabled();
        }

        @Override
        public FipsAgreement<DHUAgreementParameters> createAgreement(AsymmetricPrivateKey asymmetricPrivateKey, DHUAgreementParameters dHUAgreementParameters) {
            AsymmetricECPrivateKey asymmetricECPrivateKey = (AsymmetricECPrivateKey)asymmetricPrivateKey;
            if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
                FipsEC.validateCurveSize(asymmetricPrivateKey.getAlgorithm(), asymmetricECPrivateKey.getDomainParameters());
            }
            EcPrivateKeyParameters ecPrivateKeyParameters = FipsEC.getLwKey(asymmetricECPrivateKey);
            EcDhcuBasicAgreement ecDhcuBasicAgreement = (EcDhcuBasicAgreement)DHU_PROVIDER.createEngine();
            ecDhcuBasicAgreement.init(new EcDhuPrivateParameters(ecPrivateKeyParameters, dHUAgreementParameters.ephemeralPrivateKey == null ? ecPrivateKeyParameters : FipsEC.getLwKey(dHUAgreementParameters.ephemeralPrivateKey)));
            return new EcDHUAgreement<DHUAgreementParameters>(ecDhcuBasicAgreement, dHUAgreementParameters);
        }
    }

    public static final class DHUAgreementParameters
    extends FipsAgreementParameters {
        private final AsymmetricECPublicKey ephemeralPublicKey;
        private final AsymmetricECPrivateKey ephemeralPrivateKey;
        private final AsymmetricECPublicKey otherPartyEphemeralKey;

        private DHUAgreementParameters(AsymmetricECPublicKey asymmetricECPublicKey, AsymmetricECPrivateKey asymmetricECPrivateKey, AsymmetricECPublicKey asymmetricECPublicKey2, FipsAlgorithm fipsAlgorithm) {
            super(ALGORITHM_DHU, fipsAlgorithm);
            this.ephemeralPublicKey = asymmetricECPublicKey;
            this.ephemeralPrivateKey = asymmetricECPrivateKey;
            this.otherPartyEphemeralKey = asymmetricECPublicKey2;
        }

        private DHUAgreementParameters(AsymmetricECPublicKey asymmetricECPublicKey, AsymmetricECPrivateKey asymmetricECPrivateKey, AsymmetricECPublicKey asymmetricECPublicKey2, FipsKDF.PRF pRF, byte[] byArray) {
            super(ALGORITHM_DHU, pRF, byArray);
            this.ephemeralPublicKey = asymmetricECPublicKey;
            this.ephemeralPrivateKey = asymmetricECPrivateKey;
            this.otherPartyEphemeralKey = asymmetricECPublicKey2;
        }

        private DHUAgreementParameters(AsymmetricECPublicKey asymmetricECPublicKey, AsymmetricECPrivateKey asymmetricECPrivateKey, AsymmetricECPublicKey asymmetricECPublicKey2, FipsKDF.AgreementKDFParametersBuilder agreementKDFParametersBuilder, byte[] byArray, int n2) {
            super(ALGORITHM_DHU, agreementKDFParametersBuilder, byArray, n2);
            this.ephemeralPublicKey = asymmetricECPublicKey;
            this.ephemeralPrivateKey = asymmetricECPrivateKey;
            this.otherPartyEphemeralKey = asymmetricECPublicKey2;
        }

        public AsymmetricECPublicKey getEphemeralPublicKey() {
            return this.ephemeralPublicKey;
        }

        public AsymmetricECPrivateKey getEphemeralPrivateKey() {
            return this.ephemeralPrivateKey;
        }

        public AsymmetricECPublicKey getOtherPartyEphemeralKey() {
            return this.otherPartyEphemeralKey;
        }

        public DHUAgreementParameters withDigest(FipsAlgorithm fipsAlgorithm) {
            return new DHUAgreementParameters(this.ephemeralPublicKey, this.ephemeralPrivateKey, this.otherPartyEphemeralKey, fipsAlgorithm);
        }

        public DHUAgreementParameters withPRF(FipsKDF.PRF pRF, byte[] byArray) {
            return new DHUAgreementParameters(this.ephemeralPublicKey, this.ephemeralPrivateKey, this.otherPartyEphemeralKey, pRF, byArray);
        }

        public DHUAgreementParameters withKDF(FipsKDF.AgreementKDFParametersBuilder agreementKDFParametersBuilder, byte[] byArray, int n2) {
            return new DHUAgreementParameters(this.ephemeralPublicKey, this.ephemeralPrivateKey, this.otherPartyEphemeralKey, agreementKDFParametersBuilder, byArray, n2);
        }
    }

    public static final class DHUAgreementParametersBuilder
    extends FipsParameters {
        DHUAgreementParametersBuilder() {
            super(ALGORITHM_DHU);
        }

        public DHUAgreementParameters using(AsymmetricKeyPair asymmetricKeyPair, AsymmetricECPublicKey asymmetricECPublicKey) {
            return new DHUAgreementParameters((AsymmetricECPublicKey)asymmetricKeyPair.getPublicKey(), (AsymmetricECPrivateKey)asymmetricKeyPair.getPrivateKey(), asymmetricECPublicKey, null);
        }

        public DHUAgreementParameters using(AsymmetricECPrivateKey asymmetricECPrivateKey, AsymmetricECPublicKey asymmetricECPublicKey) {
            return new DHUAgreementParameters(null, asymmetricECPrivateKey, asymmetricECPublicKey, null);
        }

        public DHUAgreementParameters using(AsymmetricECPublicKey asymmetricECPublicKey, AsymmetricECPrivateKey asymmetricECPrivateKey, AsymmetricECPublicKey asymmetricECPublicKey2) {
            return new DHUAgreementParameters(asymmetricECPublicKey, asymmetricECPrivateKey, asymmetricECPublicKey2, null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DSAOperatorFactory
    extends FipsSignatureOperatorFactory<DSAParameters> {
        public DSAOperatorFactory() {
            FipsEC.checkEnabled();
        }

        @Override
        public FipsOutputSignerUsingSecureRandom<DSAParameters> createSigner(AsymmetricPrivateKey asymmetricPrivateKey, DSAParameters dSAParameters) {
            AsymmetricECPrivateKey asymmetricECPrivateKey = (AsymmetricECPrivateKey)asymmetricPrivateKey;
            if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
                FipsEC.validateCurveSize(asymmetricPrivateKey.getAlgorithm(), asymmetricECPrivateKey.getDomainParameters());
            }
            EcDsaSigner ecDsaSigner = (EcDsaSigner)DSA_PROVIDER.createEngine();
            Digest digest = dSAParameters.digestAlgorithm != null ? FipsSHS.createDigest(dSAParameters.digestAlgorithm) : new NullDigest();
            final EcPrivateKeyParameters ecPrivateKeyParameters = FipsEC.getLwKey(asymmetricECPrivateKey);
            return new DSAOutputSigner<DSAParameters>(ecDsaSigner, digest, dSAParameters, new DSAOutputSigner.Initializer(){

                public void initialize(DSA dSA, SecureRandom secureRandom) {
                    dSA.init(true, new ParametersWithRandom(ecPrivateKeyParameters, secureRandom));
                }
            });
        }

        @Override
        public FipsOutputVerifier<DSAParameters> createVerifier(AsymmetricPublicKey asymmetricPublicKey, DSAParameters dSAParameters) {
            EcDsaSigner ecDsaSigner = (EcDsaSigner)DSA_PROVIDER.createEngine();
            Digest digest = dSAParameters.digestAlgorithm != null ? FipsSHS.createDigest(dSAParameters.digestAlgorithm) : new NullDigest();
            AsymmetricECPublicKey asymmetricECPublicKey = (AsymmetricECPublicKey)asymmetricPublicKey;
            EcPublicKeyParameters ecPublicKeyParameters = new EcPublicKeyParameters(asymmetricECPublicKey.getW(), FipsEC.getDomainParams(asymmetricECPublicKey.getDomainParameters()));
            ecDsaSigner.init(false, ecPublicKeyParameters);
            return new DSAOutputVerifier<DSAParameters>(ecDsaSigner, digest, dSAParameters);
        }
    }

    public static final class DSAParameters
    extends FipsParameters {
        private final FipsDigestAlgorithm digestAlgorithm;

        DSAParameters(FipsAlgorithm fipsAlgorithm, FipsDigestAlgorithm fipsDigestAlgorithm) {
            super(fipsAlgorithm);
            if (fipsDigestAlgorithm == null && CryptoServicesRegistrar.isInApprovedOnlyMode()) {
                PrivilegedUtils.checkPermission(Permissions.TlsNullDigestEnabled);
            }
            this.digestAlgorithm = fipsDigestAlgorithm;
        }

        public FipsDigestAlgorithm getDigestAlgorithm() {
            return this.digestAlgorithm;
        }

        public DSAParameters withDigestAlgorithm(FipsDigestAlgorithm fipsDigestAlgorithm) {
            return new DSAParameters(this.getAlgorithm(), fipsDigestAlgorithm);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DhProvider
    extends FipsEngineProvider<EcDhBasicAgreement> {
        static BigInteger expected = new BigInteger("cad5c428ea0645794bc5634549e08a3ed563bd0cf32e909862e08b41d4b6fc17", 16);

        private DhProvider() {
        }

        @Override
        public EcDhBasicAgreement createEngine() {
            return SelfTestExecutor.validate(ALGORITHM, new EcDhBasicAgreement(), new VariantKatTest<EcDhBasicAgreement>(){

                @Override
                void evaluate(EcDhBasicAgreement ecDhBasicAgreement) throws Exception {
                    AsymmetricCipherKeyPair asymmetricCipherKeyPair = FipsEC.getKATKeyPair();
                    AsymmetricCipherKeyPair asymmetricCipherKeyPair2 = FipsEC.getTestKeyPair(asymmetricCipherKeyPair);
                    ecDhBasicAgreement.init(asymmetricCipherKeyPair.getPrivate());
                    if (!expected.equals(ecDhBasicAgreement.calculateAgreement(asymmetricCipherKeyPair2.getPublic()))) {
                        this.fail("KAT ECDH agreement not verified");
                    }
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DhcProvider
    extends FipsEngineProvider<EcDhcBasicAgreement> {
        static final BigInteger expected = new BigInteger("cad5c428ea0645794bc5634549e08a3ed563bd0cf32e909862e08b41d4b6fc17", 16);

        private DhcProvider() {
        }

        @Override
        public EcDhcBasicAgreement createEngine() {
            return SelfTestExecutor.validate(ALGORITHM, new EcDhcBasicAgreement(), new VariantKatTest<EcDhcBasicAgreement>(){

                @Override
                void evaluate(EcDhcBasicAgreement ecDhcBasicAgreement) throws Exception {
                    AsymmetricCipherKeyPair asymmetricCipherKeyPair = FipsEC.getKATKeyPair();
                    AsymmetricCipherKeyPair asymmetricCipherKeyPair2 = FipsEC.getTestKeyPair(asymmetricCipherKeyPair);
                    ecDhcBasicAgreement.init(asymmetricCipherKeyPair.getPrivate());
                    if (!expected.equals(ecDhcBasicAgreement.calculateAgreement(asymmetricCipherKeyPair2.getPublic()))) {
                        this.fail("KAT ECDH agreement not verified");
                    }
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DhuProvider
    extends FipsEngineProvider<EcDhcuBasicAgreement> {
        static final byte[] expected = Hex.decode("cad5c428ea0645794bc5634549e08a3ed563bd0cf32e909862e08b41d4b6fc17cad5c428ea0645794bc5634549e08a3ed563bd0cf32e909862e08b41d4b6fc17");

        private DhuProvider() {
        }

        @Override
        public EcDhcuBasicAgreement createEngine() {
            return SelfTestExecutor.validate(ALGORITHM, new EcDhcuBasicAgreement(), new VariantKatTest<EcDhcuBasicAgreement>(){

                @Override
                void evaluate(EcDhcuBasicAgreement ecDhcuBasicAgreement) throws Exception {
                    AsymmetricCipherKeyPair asymmetricCipherKeyPair = FipsEC.getKATKeyPair();
                    AsymmetricCipherKeyPair asymmetricCipherKeyPair2 = FipsEC.getTestKeyPair(asymmetricCipherKeyPair);
                    AsymmetricCipherKeyPair asymmetricCipherKeyPair3 = FipsEC.getTestKeyPair(asymmetricCipherKeyPair);
                    ecDhcuBasicAgreement.init(new EcDhuPrivateParameters((EcPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate(), (EcPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate()));
                    byte[] byArray = ecDhcuBasicAgreement.calculateAgreement(new EcDhuPublicParameters((EcPublicKeyParameters)asymmetricCipherKeyPair2.getPublic(), (EcPublicKeyParameters)asymmetricCipherKeyPair3.getPublic()));
                    if (!Arrays.areEqual(expected, byArray)) {
                        this.fail("KAT ECCDHU agreement not verified");
                    }
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DomainParameterID implements ECDomainParametersID
    {
        B571("B-571"),
        B409("B-409"),
        B283("B-283"),
        B233("B-233"),
        B163("B-163"),
        K571("K-571"),
        K409("K-409"),
        K283("K-283"),
        K233("K-233"),
        K163("K-163"),
        P521("P-521"),
        P384("P-384"),
        P256("P-256"),
        P224("P-224"),
        P192("P-192");

        private final String curveName;

        private DomainParameterID(String string2) {
            this.curveName = string2;
        }

        @Override
        public String getCurveName() {
            return this.curveName;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DsaProvider
    extends FipsEngineProvider<EcDsaSigner> {
        private DsaProvider() {
        }

        @Override
        public EcDsaSigner createEngine() {
            return SelfTestExecutor.validate(ALGORITHM, new EcDsaSigner(), new VariantKatTest<EcDsaSigner>(){

                @Override
                void evaluate(EcDsaSigner ecDsaSigner) throws Exception {
                    AsymmetricCipherKeyPair asymmetricCipherKeyPair = FipsEC.getKATKeyPair();
                    TestRandomBigInteger testRandomBigInteger = new TestRandomBigInteger("72546832179840998877302529996971396893172522460793442785601695562409154906335");
                    byte[] byArray = Hex.decode("1BD4ED430B0F384B4E8D458EFF1A8A553286D7AC21CB2F6806172EF5F94A06AD");
                    ecDsaSigner.init(true, new ParametersWithRandom(asymmetricCipherKeyPair.getPrivate(), testRandomBigInteger));
                    BigInteger[] bigIntegerArray = ecDsaSigner.generateSignature(byArray);
                    ecDsaSigner.init(false, asymmetricCipherKeyPair.getPublic());
                    if (!ecDsaSigner.verifySignature(byArray, bigIntegerArray[0], bigIntegerArray[1])) {
                        this.fail("signature fails");
                    }
                }
            });
        }
    }

    public static final class KeyGenParameters
    extends FipsParameters {
        private final ECDomainParameters domainParameters;

        public KeyGenParameters(ECDomainParameters eCDomainParameters) {
            this(ALGORITHM, eCDomainParameters);
        }

        public KeyGenParameters(DSAParameters dSAParameters, ECDomainParameters eCDomainParameters) {
            this(dSAParameters.getAlgorithm(), eCDomainParameters);
        }

        public KeyGenParameters(AgreementParameters agreementParameters, ECDomainParameters eCDomainParameters) {
            this(agreementParameters.getAlgorithm(), eCDomainParameters);
        }

        public KeyGenParameters(MQVAgreementParametersBuilder mQVAgreementParametersBuilder, ECDomainParameters eCDomainParameters) {
            this(ALGORITHM_MQV, eCDomainParameters);
        }

        public KeyGenParameters(DHUAgreementParametersBuilder dHUAgreementParametersBuilder, ECDomainParameters eCDomainParameters) {
            this(ALGORITHM_DHU, eCDomainParameters);
        }

        KeyGenParameters(FipsAlgorithm fipsAlgorithm, ECDomainParameters eCDomainParameters) {
            super(fipsAlgorithm);
            this.domainParameters = eCDomainParameters;
        }

        public ECDomainParameters getDomainParameters() {
            return this.domainParameters;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class KeyPairGenerator
    extends FipsAsymmetricKeyPairGenerator<KeyGenParameters, AsymmetricECPublicKey, AsymmetricECPrivateKey> {
        private final EcKeyPairGenerator engine = new EcKeyPairGenerator();
        private final ECDomainParameters domainParameters;
        private final EcKeyGenerationParameters param;

        public KeyPairGenerator(KeyGenParameters keyGenParameters, SecureRandom secureRandom) {
            super(keyGenParameters);
            FipsEC.checkEnabled();
            if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
                FipsEC.validateCurveSize(keyGenParameters.getAlgorithm(), keyGenParameters.getDomainParameters());
                Utils.validateKeyPairGenRandom(secureRandom, Utils.getECCurveSecurityStrength(keyGenParameters.getDomainParameters().getCurve()), ALGORITHM);
            }
            this.param = ((KeyGenParameters)this.getParameters()).getAlgorithm().equals(DH.getAlgorithm()) && !ECConstants.ONE.equals(keyGenParameters.domainParameters.getH()) ? new EcKeyGenerationParameters(FipsEC.getDomainParamsWithInv(keyGenParameters.getDomainParameters()), secureRandom) : new EcKeyGenerationParameters(FipsEC.getDomainParams(keyGenParameters.getDomainParameters()), secureRandom);
            this.domainParameters = keyGenParameters.getDomainParameters();
            this.engine.init(this.param);
        }

        @Override
        public AsymmetricKeyPair<AsymmetricECPublicKey, AsymmetricECPrivateKey> generateKeyPair() {
            AsymmetricCipherKeyPair asymmetricCipherKeyPair = this.engine.generateKeyPair();
            EcPublicKeyParameters ecPublicKeyParameters = (EcPublicKeyParameters)asymmetricCipherKeyPair.getPublic();
            EcPrivateKeyParameters ecPrivateKeyParameters = (EcPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
            FipsAlgorithm fipsAlgorithm = ((KeyGenParameters)this.getParameters()).getAlgorithm();
            FipsEC.validateKeyPair(fipsAlgorithm, asymmetricCipherKeyPair);
            return new AsymmetricKeyPair<AsymmetricECPublicKey, AsymmetricECPrivateKey>(new AsymmetricECPublicKey((Algorithm)fipsAlgorithm, this.domainParameters, ecPublicKeyParameters.getQ()), new AsymmetricECPrivateKey((Algorithm)fipsAlgorithm, this.domainParameters, ecPrivateKeyParameters.getD(), ecPublicKeyParameters.getQ()));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class MQVAgreementFactory
    extends FipsAgreementFactory<MQVAgreementParameters> {
        public MQVAgreementFactory() {
            FipsEC.checkEnabled();
            if (Properties.isOverrideSet("com.aspose.html.internal.ms.core.bc.ec.disable_mqv")) {
                throw new UnsupportedOperationException("EC MQV has been disabled by setting \"org.bouncycastle.ec.disable_mqv\"");
            }
        }

        @Override
        public FipsAgreement<MQVAgreementParameters> createAgreement(AsymmetricPrivateKey asymmetricPrivateKey, MQVAgreementParameters mQVAgreementParameters) {
            AsymmetricECPrivateKey asymmetricECPrivateKey = (AsymmetricECPrivateKey)asymmetricPrivateKey;
            if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
                FipsEC.validateCurveSize(asymmetricPrivateKey.getAlgorithm(), asymmetricECPrivateKey.getDomainParameters());
            }
            EcPrivateKeyParameters ecPrivateKeyParameters = FipsEC.getLwKey(asymmetricECPrivateKey);
            EcMqvBasicAgreement ecMqvBasicAgreement = (EcMqvBasicAgreement)MQV_PROVIDER.createEngine();
            ecMqvBasicAgreement.init(new EcMqvPrivateParameters(ecPrivateKeyParameters, mQVAgreementParameters.ephemeralPrivateKey == null ? ecPrivateKeyParameters : FipsEC.getLwKey(mQVAgreementParameters.ephemeralPrivateKey)));
            return new EcDHAgreement<MQVAgreementParameters>(ecMqvBasicAgreement, mQVAgreementParameters);
        }
    }

    public static final class MQVAgreementParameters
    extends FipsAgreementParameters {
        private final AsymmetricECPublicKey ephemeralPublicKey;
        private final AsymmetricECPrivateKey ephemeralPrivateKey;
        private final AsymmetricECPublicKey otherPartyEphemeralKey;

        private MQVAgreementParameters(AsymmetricECPublicKey asymmetricECPublicKey, AsymmetricECPrivateKey asymmetricECPrivateKey, AsymmetricECPublicKey asymmetricECPublicKey2, FipsAlgorithm fipsAlgorithm) {
            super(ALGORITHM_MQV, fipsAlgorithm);
            this.ephemeralPublicKey = asymmetricECPublicKey;
            this.ephemeralPrivateKey = asymmetricECPrivateKey;
            this.otherPartyEphemeralKey = asymmetricECPublicKey2;
        }

        private MQVAgreementParameters(AsymmetricECPublicKey asymmetricECPublicKey, AsymmetricECPrivateKey asymmetricECPrivateKey, AsymmetricECPublicKey asymmetricECPublicKey2, FipsKDF.PRF pRF, byte[] byArray) {
            super(ALGORITHM_MQV, pRF, byArray);
            this.ephemeralPublicKey = asymmetricECPublicKey;
            this.ephemeralPrivateKey = asymmetricECPrivateKey;
            this.otherPartyEphemeralKey = asymmetricECPublicKey2;
        }

        private MQVAgreementParameters(AsymmetricECPublicKey asymmetricECPublicKey, AsymmetricECPrivateKey asymmetricECPrivateKey, AsymmetricECPublicKey asymmetricECPublicKey2, FipsKDF.AgreementKDFParametersBuilder agreementKDFParametersBuilder, byte[] byArray, int n2) {
            super(ALGORITHM_MQV, agreementKDFParametersBuilder, byArray, n2);
            this.ephemeralPublicKey = asymmetricECPublicKey;
            this.ephemeralPrivateKey = asymmetricECPrivateKey;
            this.otherPartyEphemeralKey = asymmetricECPublicKey2;
        }

        public AsymmetricECPublicKey getEphemeralPublicKey() {
            return this.ephemeralPublicKey;
        }

        public AsymmetricECPrivateKey getEphemeralPrivateKey() {
            return this.ephemeralPrivateKey;
        }

        public AsymmetricECPublicKey getOtherPartyEphemeralKey() {
            return this.otherPartyEphemeralKey;
        }

        public MQVAgreementParameters withDigest(FipsAlgorithm fipsAlgorithm) {
            return new MQVAgreementParameters(this.ephemeralPublicKey, this.ephemeralPrivateKey, this.otherPartyEphemeralKey, fipsAlgorithm);
        }

        public MQVAgreementParameters withPRF(FipsKDF.PRF pRF, byte[] byArray) {
            return new MQVAgreementParameters(this.ephemeralPublicKey, this.ephemeralPrivateKey, this.otherPartyEphemeralKey, pRF, byArray);
        }

        public MQVAgreementParameters withKDF(FipsKDF.AgreementKDFParametersBuilder agreementKDFParametersBuilder, byte[] byArray, int n2) {
            return new MQVAgreementParameters(this.ephemeralPublicKey, this.ephemeralPrivateKey, this.otherPartyEphemeralKey, agreementKDFParametersBuilder, byArray, n2);
        }
    }

    public static final class MQVAgreementParametersBuilder
    extends FipsParameters {
        MQVAgreementParametersBuilder() {
            super(ALGORITHM_MQV);
        }

        public MQVAgreementParameters using(AsymmetricKeyPair asymmetricKeyPair, AsymmetricECPublicKey asymmetricECPublicKey) {
            return new MQVAgreementParameters((AsymmetricECPublicKey)asymmetricKeyPair.getPublicKey(), (AsymmetricECPrivateKey)asymmetricKeyPair.getPrivateKey(), asymmetricECPublicKey, null);
        }

        public MQVAgreementParameters using(AsymmetricECPrivateKey asymmetricECPrivateKey, AsymmetricECPublicKey asymmetricECPublicKey) {
            return new MQVAgreementParameters(null, asymmetricECPrivateKey, asymmetricECPublicKey, null);
        }

        public MQVAgreementParameters using(AsymmetricECPublicKey asymmetricECPublicKey, AsymmetricECPrivateKey asymmetricECPrivateKey, AsymmetricECPublicKey asymmetricECPublicKey2) {
            return new MQVAgreementParameters(asymmetricECPublicKey, asymmetricECPrivateKey, asymmetricECPublicKey2, null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MqvProvider
    extends FipsEngineProvider<EcMqvBasicAgreement> {
        static final BigInteger expected = new BigInteger("8cae3483c0d3dac87d1c1d32be8e7b7a3c1558bd01cb7e7bb37c1c81126b0f98", 16);

        private MqvProvider() {
        }

        @Override
        public EcMqvBasicAgreement createEngine() {
            return SelfTestExecutor.validate(ALGORITHM, new EcMqvBasicAgreement(), new VariantKatTest<EcMqvBasicAgreement>(){

                @Override
                void evaluate(EcMqvBasicAgreement ecMqvBasicAgreement) throws Exception {
                    AsymmetricCipherKeyPair asymmetricCipherKeyPair = FipsEC.getKATKeyPair();
                    AsymmetricCipherKeyPair asymmetricCipherKeyPair2 = FipsEC.getTestKeyPair(asymmetricCipherKeyPair);
                    AsymmetricCipherKeyPair asymmetricCipherKeyPair3 = FipsEC.getTestKeyPair(asymmetricCipherKeyPair);
                    ecMqvBasicAgreement.init(new EcMqvPrivateParameters((EcPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate(), (EcPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate()));
                    BigInteger bigInteger = ecMqvBasicAgreement.calculateAgreement(new EcMqvPublicParameters((EcPublicKeyParameters)asymmetricCipherKeyPair2.getPublic(), (EcPublicKeyParameters)asymmetricCipherKeyPair3.getPublic()));
                    if (!expected.equals(bigInteger)) {
                        this.fail("KAT ECMQV agreement not verified");
                    }
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Variations {
        ECDSA,
        ECDH,
        ECCDH,
        ECMQV,
        ECCDHU;

    }
}

