/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.crypto.fips;

import com.aspose.html.internal.ms.core.bc.crypto.IllegalKeyException;
import com.aspose.html.internal.ms.core.bc.crypto.internal.BasicAgreement;
import com.aspose.html.internal.ms.core.bc.crypto.internal.CipherParameters;
import com.aspose.html.internal.ms.core.bc.crypto.internal.params.EcDomainParameters;
import com.aspose.html.internal.ms.core.bc.crypto.internal.params.EcPrivateKeyParameters;
import com.aspose.html.internal.ms.core.bc.crypto.internal.params.EcPublicKeyParameters;
import com.aspose.html.internal.ms.core.bc.math.ec.ECAlgorithms;
import com.aspose.html.internal.ms.core.bc.math.ec.ECConstants;
import com.aspose.html.internal.ms.core.bc.math.ec.ECPoint;
import java.math.BigInteger;

class EcDhBasicAgreement
implements BasicAgreement {
    EcPrivateKeyParameters key;

    EcDhBasicAgreement() {
    }

    public void init(CipherParameters cipherParameters) {
        this.key = (EcPrivateKeyParameters)cipherParameters;
    }

    public int getFieldSize() {
        return (this.key.getParameters().getCurve().getFieldSize() + 7) / 8;
    }

    public BigInteger calculateAgreement(CipherParameters cipherParameters) {
        ECPoint eCPoint;
        EcPublicKeyParameters ecPublicKeyParameters = (EcPublicKeyParameters)cipherParameters;
        EcDomainParameters ecDomainParameters = this.key.getParameters();
        if (!ecDomainParameters.equals(ecPublicKeyParameters.getParameters())) {
            throw new IllegalKeyException("ECDH public key has wrong domain parameters");
        }
        BigInteger bigInteger = this.key.getD();
        ECPoint eCPoint2 = ECAlgorithms.cleanPoint(ecDomainParameters.getCurve(), ecPublicKeyParameters.getQ());
        if (eCPoint2.isInfinity()) {
            throw new IllegalStateException("Infinity is not a valid public key for ECDHC");
        }
        BigInteger bigInteger2 = ecDomainParameters.getH();
        if (!bigInteger2.equals(ECConstants.ONE)) {
            bigInteger = ecDomainParameters.getHInv().multiply(bigInteger).mod(ecDomainParameters.getN());
            eCPoint2 = ECAlgorithms.referenceMultiply(eCPoint2, bigInteger2);
        }
        if ((eCPoint = eCPoint2.multiply(bigInteger).normalize()).isInfinity()) {
            throw new IllegalStateException("Infinity is not a valid agreement value for ECDH");
        }
        return eCPoint.getAffineXCoord().toBigInteger();
    }
}

