/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.crypto.fips;

import com.aspose.html.internal.ms.core.bc.crypto.AsymmetricPublicKey;
import com.aspose.html.internal.ms.core.bc.crypto.asymmetric.AsymmetricECPublicKey;
import com.aspose.html.internal.ms.core.bc.crypto.asymmetric.ECDomainParameters;
import com.aspose.html.internal.ms.core.bc.crypto.asymmetric.NamedECDomainParameters;
import com.aspose.html.internal.ms.core.bc.crypto.fips.EcDhcuBasicAgreement;
import com.aspose.html.internal.ms.core.bc.crypto.fips.FipsAgreement;
import com.aspose.html.internal.ms.core.bc.crypto.fips.FipsAgreementParameters;
import com.aspose.html.internal.ms.core.bc.crypto.fips.FipsEC;
import com.aspose.html.internal.ms.core.bc.crypto.fips.FipsKDF;
import com.aspose.html.internal.ms.core.bc.crypto.internal.params.EcDhuPublicParameters;
import com.aspose.html.internal.ms.core.bc.crypto.internal.params.EcDomainParameters;
import com.aspose.html.internal.ms.core.bc.crypto.internal.params.EcNamedDomainParameters;
import com.aspose.html.internal.ms.core.bc.crypto.internal.params.EcPublicKeyParameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EcDHUAgreement<T extends FipsAgreementParameters>
extends FipsAgreement<T> {
    private final EcDhcuBasicAgreement dh;
    private final T parameter;

    EcDHUAgreement(EcDhcuBasicAgreement ecDhcuBasicAgreement, T t2) {
        this.dh = ecDhcuBasicAgreement;
        this.parameter = t2;
    }

    @Override
    public T getParameters() {
        return this.parameter;
    }

    @Override
    public byte[] calculate(AsymmetricPublicKey asymmetricPublicKey) {
        AsymmetricECPublicKey asymmetricECPublicKey = (AsymmetricECPublicKey)asymmetricPublicKey;
        EcPublicKeyParameters ecPublicKeyParameters = new EcPublicKeyParameters(asymmetricECPublicKey.getW(), EcDHUAgreement.getDomainParams(asymmetricECPublicKey.getDomainParameters()));
        AsymmetricECPublicKey asymmetricECPublicKey2 = ((FipsEC.DHUAgreementParameters)this.parameter).getOtherPartyEphemeralKey();
        byte[] byArray = this.dh.calculateAgreement(new EcDhuPublicParameters(ecPublicKeyParameters, new EcPublicKeyParameters(asymmetricECPublicKey2.getW(), EcDHUAgreement.getDomainParams(asymmetricECPublicKey2.getDomainParameters()))));
        return FipsKDF.processZBytes(byArray, this.parameter);
    }

    private static EcDomainParameters getDomainParams(ECDomainParameters eCDomainParameters) {
        if (eCDomainParameters instanceof NamedECDomainParameters) {
            return new EcNamedDomainParameters((NamedECDomainParameters)eCDomainParameters);
        }
        return new EcDomainParameters(eCDomainParameters);
    }
}

