/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.crypto.asymmetric;

import com.aspose.html.internal.ms.core.bc.asn1.ASN1Encodable;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1OctetString;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1Set;
import com.aspose.html.internal.ms.core.bc.asn1.DEROctetString;
import com.aspose.html.internal.ms.core.bc.asn1.edec.EdECObjectIdentifiers;
import com.aspose.html.internal.ms.core.bc.asn1.pkcs.PrivateKeyInfo;
import com.aspose.html.internal.ms.core.bc.asn1.x509.AlgorithmIdentifier;
import com.aspose.html.internal.ms.core.bc.crypto.Algorithm;
import com.aspose.html.internal.ms.core.bc.crypto.AsymmetricPrivateKey;
import com.aspose.html.internal.ms.core.bc.crypto.asymmetric.AsymmetricXDHKey;
import com.aspose.html.internal.ms.core.bc.crypto.asymmetric.KeyUtils;
import com.aspose.html.internal.ms.core.bc.crypto.general.EdEC;
import com.aspose.html.internal.ms.core.bc.crypto.internal.Permissions;
import com.aspose.html.internal.ms.core.bc.util.Arrays;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.security.auth.Destroyable;

public final class AsymmetricXDHPrivateKey
extends AsymmetricXDHKey
implements AsymmetricPrivateKey,
Destroyable {
    private final AtomicBoolean hasBeenDestroyed = new AtomicBoolean(false);
    private final byte[] keyData;
    private byte[] publicData;
    private boolean hasPublicKey;
    private ASN1Set attributes;
    private int hashCode;

    public AsymmetricXDHPrivateKey(Algorithm algorithm, byte[] byArray, byte[] byArray2) {
        super(algorithm);
        this.keyData = Arrays.clone(byArray);
        this.hashCode = this.calculateHashCode();
        this.attributes = null;
        if (byArray2 == null) {
            this.hasPublicKey = false;
            this.publicData = EdEC.computePublicData(algorithm, byArray);
        } else {
            this.hasPublicKey = true;
            this.publicData = Arrays.clone(byArray2);
        }
    }

    public AsymmetricXDHPrivateKey(byte[] byArray) throws IOException {
        this(PrivateKeyInfo.getInstance(byArray));
    }

    public AsymmetricXDHPrivateKey(PrivateKeyInfo privateKeyInfo) throws IOException {
        super(EdECObjectIdentifiers.id_X448.equals(privateKeyInfo.getPrivateKeyAlgorithm().getAlgorithm()) ? EdEC.Algorithm.X448 : EdEC.Algorithm.X25519);
        ASN1Encodable aSN1Encodable = privateKeyInfo.parsePrivateKey();
        this.keyData = Arrays.clone(ASN1OctetString.getInstance(aSN1Encodable).getOctets());
        if (privateKeyInfo.hasPublicKey()) {
            this.hasPublicKey = true;
            this.publicData = Arrays.clone(privateKeyInfo.getPublicKeyData().getOctets());
        } else {
            this.publicData = null;
        }
        if (EdECObjectIdentifiers.id_X448.equals(privateKeyInfo.getPrivateKeyAlgorithm().getAlgorithm()) ? this.keyData.length != 56 : this.keyData.length != 32) {
            throw new IllegalArgumentException("raw key data incorrect size");
        }
        this.attributes = privateKeyInfo.getAttributes();
        this.hashCode = this.calculateHashCode();
    }

    public byte[] getSecret() {
        this.checkApprovedOnlyModeStatus();
        KeyUtils.checkPermission(Permissions.CanOutputPrivateKey);
        KeyUtils.checkDestroyed(this);
        return Arrays.clone(this.keyData);
    }

    public byte[] getPublicData() {
        KeyUtils.checkDestroyed(this);
        return Arrays.clone(this.publicData);
    }

    public byte[] getEncoded() {
        byte[] byArray;
        this.checkApprovedOnlyModeStatus();
        KeyUtils.checkPermission(Permissions.CanOutputPrivateKey);
        KeyUtils.checkDestroyed(this);
        byte[] byArray2 = byArray = this.hasPublicKey ? this.publicData : null;
        if (this.getAlgorithm().equals(EdEC.Algorithm.X448)) {
            return KeyUtils.getEncodedPrivateKeyInfo(new AlgorithmIdentifier(EdECObjectIdentifiers.id_X448), new DEROctetString(this.keyData), this.attributes, byArray);
        }
        return KeyUtils.getEncodedPrivateKeyInfo(new AlgorithmIdentifier(EdECObjectIdentifiers.id_X25519), new DEROctetString(this.keyData), this.attributes, byArray);
    }

    protected void zeroize() {
        super.zeroize();
        Arrays.clear(this.keyData);
    }

    public void destroy() {
        this.checkApprovedOnlyModeStatus();
        if (!this.hasBeenDestroyed.getAndSet(true)) {
            Arrays.clear(this.keyData);
            if (this.publicData != null) {
                Arrays.clear(this.publicData);
            }
            this.publicData = null;
            this.hasPublicKey = false;
            this.attributes = null;
            this.hashCode = -1;
        }
    }

    public boolean isDestroyed() {
        this.checkApprovedOnlyModeStatus();
        return this.hasBeenDestroyed.get();
    }

    public boolean equals(Object object) {
        this.checkApprovedOnlyModeStatus();
        if (this == object) {
            return true;
        }
        if (!(object instanceof AsymmetricXDHPrivateKey)) {
            return false;
        }
        AsymmetricXDHPrivateKey asymmetricXDHPrivateKey = (AsymmetricXDHPrivateKey)object;
        if (this.isDestroyed() || asymmetricXDHPrivateKey.isDestroyed()) {
            return false;
        }
        if (!Arrays.areEqual(this.keyData, asymmetricXDHPrivateKey.keyData)) {
            return false;
        }
        return this.getAlgorithm().equals(asymmetricXDHPrivateKey.getAlgorithm());
    }

    public int hashCode() {
        this.checkApprovedOnlyModeStatus();
        return this.hashCode;
    }

    private int calculateHashCode() {
        int n2 = this.getAlgorithm().hashCode();
        n2 = 31 * n2 + Arrays.hashCode(this.keyData);
        return n2;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.destroy();
    }
}

